/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.index.MaskLine;
import org.maachang.rimdb.util.NAdd;
import org.maachang.rimdb.util.NNChild;
import org.maachang.rimdb.util.NNKeyValue;

public final class MaskFlags {
    protected NNKeyValue list;
    protected final int maxLength;

    public MaskFlags(int len) {
        this.maxLength = len;
        this.list = new NNKeyValue();
    }

    public void clear() {
        this.list.clear();
    }

    public final int or(MaskFlags mask) {
        NNKeyValue n = mask.list;
        n.reset();
        while (n.hasNext()) {
            NNChild ch = n.nextChild();
            int no = ch.getKey();
            NNChild d = this.list.getChild(no);
            if (d == null) {
                this.list.put(no, ch.o);
                continue;
            }
            d.o |= ch.o;
        }
        return this.list.size();
    }

    public final int and(MaskFlags mask) {
        NNKeyValue b;
        NNKeyValue a;
        if (mask.list.size() < this.list.size()) {
            a = mask.list;
            b = this.list;
        } else {
            a = this.list;
            b = mask.list;
        }
        if (a.size() == 0 || b.size() == 0) {
            this.list.clear();
            return 0;
        }
        NNKeyValue newList = new NNKeyValue();
        a.reset();
        while (a.hasNext()) {
            NNChild ch = a.nextChild();
            int no = ch.getKey();
            NNChild d = b.getChild(no);
            if (d == null || (ch.o & d.o) == 0) continue;
            newList.put(no, ch.o & d.o);
        }
        this.list = newList;
        return this.list.size();
    }

    public final void orLine(int no) {
        int key = no >> 5;
        NNChild n = this.list.getChild(key);
        if (n == null) {
            this.list.put(key, 1 << (no & 0x1F));
        } else {
            n.o |= 1 << (no & 0x1F);
        }
    }

    public final void orMask(int key, int mask) {
        NNChild n = this.list.getChild(key);
        if (n == null) {
            this.list.put(key, mask);
        } else {
            n.o |= mask;
        }
    }

    public final void orLine(int[] noList) {
        int len = noList.length;
        int i = 0;
        while (i < len) {
            int no = noList[i];
            int key = no >> 5;
            NNChild n = this.list.getChild(key);
            if (n == null) {
                this.list.put(key, 1 << (no & 0x1F));
            } else {
                n.o |= 1 << (no & 0x1F);
            }
            ++i;
        }
    }

    public final void orMask(int[] keyList, int[] maskList) {
        int len = keyList.length;
        int i = 0;
        while (i < len) {
            int key = keyList[i];
            NNChild n = this.list.getChild(key);
            if (n == null) {
                this.list.put(key, maskList[i]);
            } else {
                n.o |= maskList[i];
            }
            ++i;
        }
    }

    public final void orMask(MaskLine lineIndex) {
        int[] keyList = lineIndex.index;
        int[] maskList = lineIndex.maskList;
        int len = keyList.length;
        int i = 0;
        while (i < len) {
            int key = keyList[i];
            NNChild n = this.list.getChild(key);
            if (n == null) {
                this.list.put(key, maskList[i]);
            } else {
                n.o |= maskList[i];
            }
            ++i;
        }
    }

    public final void get(NAdd out) {
        int mx = this.maxLength;
        this.list.reset();
        while (this.list.hasNext()) {
            int i;
            int h = this.list.next() << 5;
            int v = this.list.nextValue();
            if (v == 0) continue;
            if (h + 32 > mx) {
                i = 0;
                while (i < 32) {
                    if ((v & 1 << i) != 0 && (h | i) < mx) {
                        out.add(h | i);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < 32) {
                if ((v & 1 << i) != 0) {
                    out.add(h | i);
                }
                ++i;
            }
        }
    }

    public final int size() {
        int ret = 0;
        int mx = this.maxLength;
        this.list.reset();
        while (this.list.hasNext()) {
            int h = this.list.next() << 5;
            int v = this.list.nextValue();
            if (v == 0) continue;
            if (h + 32 > mx) {
                int i = 0;
                while (i < 32) {
                    if ((v & 1 << i) != 0 && (h | i) < mx) {
                        ++ret;
                    }
                    ++i;
                }
                continue;
            }
            if (v == -1) {
                ret += 32;
                continue;
            }
            v = (v & 0x55555555) + (v >> 1 & 0x55555555);
            v = (v & 0x33333333) + (v >> 2 & 0x33333333);
            v = (v & 0xF0F0F0F) + (v >> 4 & 0xF0F0F0F);
            v = (v & 0xFF00FF) + (v >> 8 & 0xFF00FF);
            ret += (v & 0xFFFF) + (v >> 16 & 0xFFFF);
        }
        return ret;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final NNKeyValue getList() {
        return this.list;
    }

    public final int getListSize() {
        return this.list.size();
    }
}

