/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.MaskLine;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.util.NAdd;
import org.maachang.rimdb.util.OList;

public abstract class InPointer<W>
extends SearchPointer<Index<W>> {
    protected int[] position;
    protected OList<W> word;

    @Override
    public void reset(boolean mode) {
        super.reset(mode);
        if (mode) {
            this.word = null;
        }
        this.position = null;
    }

    public void set(OList<W> word) {
        if (word == null) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.word = word;
        this.resetFlag = false;
    }

    public final int[] position() {
        return this.position;
    }

    @Override
    public final void search(Index<W> index) {
        if (this.resetFlag) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = 0;
        int cnt = 0;
        int iLen = this.word.size();
        MaskLine[] lm = index.getMaskLine();
        this.position = new int[iLen];
        int i = 0;
        while (i < iLen) {
            int p = index.eq(this.word.get(i));
            if (p == -1) {
                this.position[i] = -1;
            } else {
                this.position[i] = p;
                cnt += lm[p].length;
                ++len;
            }
            ++i;
        }
        this.length = len;
        this.count = cnt;
    }

    @Override
    public final void get(NAdd out, Index<W> index) {
        int[][] indexToLine = index.getIndexToLine();
        int[] pos = this.position;
        int len = pos.length;
        int i = 0;
        while (i < len) {
            if (pos[i] != -1) {
                int[] n = indexToLine[pos[i]];
                int lenJ = n.length;
                int j = 0;
                while (j < lenJ) {
                    out.add(n[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void baseCopy(boolean mode, InPointer o) {
        super.baseCopy(mode, o);
        if (!mode) {
            o.word = this.word;
            o.resetFlag = false;
        }
        o.position = null;
    }
}

