/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import java.util.Arrays;
import org.maachang.rimdb.util.NList;
import org.maachang.rimdb.util.OList;
import org.maachang.rimdb.util.OOKeyValue;

public abstract class CreateIndex<T, O> {
    protected OList<T> list = null;
    protected boolean ngram;

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
    }

    public void add(T value) {
        this.list.add(value);
    }

    public void setNGram(boolean flg) {
        this.ngram = flg;
    }

    public O create() {
        SrcIndex n;
        int len;
        int max = len = this.list.size();
        OOKeyValue idx = new OOKeyValue();
        int i = 0;
        while (i < len) {
            T v = this.list.get(i);
            n = (SrcIndex)idx.get(v);
            if (n == null) {
                n = new SrcIndex();
                n.value = v;
                idx.put(v, n);
            }
            n.lines.add(i);
            ++i;
        }
        this.clear();
        int cnt = 0;
        len = idx.size();
        Object[] target = new SrcIndex[len];
        idx.reset();
        while (idx.hasNext()) {
            target[cnt++] = (SrcIndex)idx.nextValue();
        }
        idx = null;
        Arrays.sort(target);
        Object index = this.create(len);
        int[][] lines = new int[len][];
        i = 0;
        while (i < len) {
            n = target[i];
            this.set(index, i, n.value);
            lines[i] = n.lines.getArray();
            ++i;
        }
        target = null;
        return this.convert(index, this.ngram, lines, max);
    }

    protected abstract Object create(int var1);

    protected abstract void set(Object var1, int var2, Object var3);

    protected abstract O convert(Object var1, int[][] var2, int var3);

    protected O convert(Object index, boolean ngram, int[][] lines, int max) {
        return this.convert(index, lines, max);
    }

    private static final class SrcIndex<T>
    implements Comparable<Object> {
        T value;
        NList lines = new NList();

        private SrcIndex() {
        }

        @Override
        public int compareTo(Object n) {
            return ((Comparable)this.value).compareTo(((SrcIndex)n).value);
        }
    }
}

