/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.Search;
import org.maachang.rimdb.TableFactory;
import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.search.CacheSearch;
import org.maachang.rimdb.search.CreateSearch;
import org.maachang.rimdb.search.SearchImpl;
import org.maachang.rimdb.table.Indexs;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.TableUtil;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.NList;
import org.maachang.rimdb.util.OList;

public final class Sql {
    private static final CacheSearch cache = TableFactory.getInstance().getCacheSearch();
    private static final TableFactory tableFactory = TableFactory.getInstance();

    protected Sql() {
    }

    public static final void remove(String name) {
        cache.remove(name);
    }

    public static final Search get(String name) {
        return cache.get(name);
    }

    public static final Search create(String sql) {
        NList code;
        int len;
        char c;
        int i;
        String cacheName = null;
        int off = 0;
        int sqlLen = sql.length();
        if (sql.charAt(0) == '$') {
            i = 1;
            while (i < sqlLen) {
                c = sql.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ';') {
                    cacheName = sql.substring(1, i);
                    off = i;
                    break;
                }
                ++i;
            }
            if (cacheName == null) {
                return cache.get(sql.substring(1));
            }
            SearchImpl ret = cache.get(cacheName);
            if (ret != null) {
                return ret;
            }
        }
        if ((len = (code = Sql.cutCode(sql, off, sqlLen)).size()) == 0) {
            throw null;
        }
        int[] array = code.toArray();
        if (ConvertUtil.eqEng(sql, array[i = 0], array[i + 1], "select")) {
            i += 2;
        }
        String column = null;
        int pointerType = -1;
        boolean descFlag = false;
        TableImpl table = null;
        Indexs indexTable = null;
        int type = 0;
        String name = null;
        CreateSearch search = null;
        while (i < len) {
            int s = array[i];
            int e = array[i + 1];
            if (ConvertUtil.eqEng(sql, s, e, ";")) break;
            if (sql.charAt(s) == '$') {
                cacheName = sql.substring(s + 1, e);
            } else {
                switch (type) {
                    case 0: {
                        if (!ConvertUtil.eqEng(sql, s, e, "from")) break;
                        type = 1;
                        break;
                    }
                    case 1: {
                        name = TableUtil.convertJavaNameByDBName(sql.substring(s, e));
                        table = (TableImpl)tableFactory.get(name);
                        if (table == null) {
                            throw new RimDbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093:" + sql);
                        }
                        indexTable = table.getIndexs();
                        search = new CreateSearch(name);
                        type = 2;
                        break;
                    }
                    case 2: {
                        if (ConvertUtil.eqEng(sql, s, e, "where")) {
                            column = null;
                            pointerType = -1;
                            type = 4;
                            break;
                        }
                        if (ConvertUtil.eqEng(sql, s, e, "order")) {
                            type = 3;
                            break;
                        }
                        throw new RimDbException("\u4e0d\u660e\u306e\u30b3\u30de\u30f3\u30c9[" + sql.substring(s, e) + "]\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f:" + sql);
                    }
                    case 3: {
                        if (ConvertUtil.eqEng(sql, s, e, "by")) {
                            column = null;
                            pointerType = -1;
                            descFlag = false;
                            type = 5;
                            break;
                        }
                        throw new RimDbException("\u4e0d\u660e\u306eorder\u30b3\u30de\u30f3\u30c9[" + sql.substring(s, e) + "]\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f:" + sql);
                    }
                    case 4: {
                        String o;
                        if (ConvertUtil.eqEng(sql, s, e, "order")) {
                            type = 3;
                            break;
                        }
                        if (column == null) {
                            c = sql.charAt(s);
                            if (c == '(') {
                                search.begin();
                                break;
                            }
                            if (c == ')') {
                                search.end();
                                break;
                            }
                            if (c == '&' || ConvertUtil.eqEng(sql, s, e, "and")) {
                                search.and();
                                break;
                            }
                            if (c == '|' || ConvertUtil.eqEng(sql, s, e, "or")) {
                                search.or();
                                break;
                            }
                            if (ConvertUtil.eqEng(sql, s, e, "point")) {
                                column = "point";
                                pointerType = 10;
                                break;
                            }
                            column = TableUtil.convertJavaNameByDBName(sql.substring(s, e));
                            break;
                        }
                        if (pointerType == -1) {
                            c = sql.charAt(s);
                            if (c == '=') {
                                pointerType = 1;
                                break;
                            }
                            if (c == '!' || ConvertUtil.eqEng(sql, s, e, "<>")) {
                                pointerType = 7;
                                break;
                            }
                            if (c == '>') {
                                if (ConvertUtil.eqEng(sql, s, e, ">=")) {
                                    pointerType = 4;
                                    break;
                                }
                                pointerType = 3;
                                break;
                            }
                            if (c == '<') {
                                if (ConvertUtil.eqEng(sql, s, e, "<=")) {
                                    pointerType = 6;
                                    break;
                                }
                                pointerType = 5;
                                break;
                            }
                            if (ConvertUtil.eqEng(sql, s, e, "in")) {
                                pointerType = 2;
                                break;
                            }
                            if (ConvertUtil.eqEng(sql, s, e, "between")) {
                                pointerType = 8;
                                break;
                            }
                            if (ConvertUtil.eqEng(sql, s, e, "like")) {
                                pointerType = 9;
                                break;
                            }
                            throw new RimDbException("\u4e0d\u660e\u306a\u6761\u4ef6\u5f0f[" + sql.substring(s, e) + "]\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059:" + sql);
                        }
                        c = sql.charAt(s);
                        if (c == '?') {
                            search.pointer(Sql.getPointer(indexTable, column, pointerType));
                            column = null;
                            pointerType = -1;
                            break;
                        }
                        if (c == '(') {
                            if (i + 4 < len && sql.charAt(array[i + 2]) == '?' && sql.charAt(array[i + 4]) == ')') {
                                i += 4;
                                search.pointer(Sql.getPointer(indexTable, column, pointerType));
                                column = null;
                                pointerType = -1;
                                break;
                            }
                            OList<String> params = new OList<String>();
                            while (true) {
                                s = array[i += 2];
                                e = array[i + 1];
                                c = sql.charAt(s);
                                if (c == ')') break;
                                if (c == ',') continue;
                                o = sql.substring(s, e);
                                c = o.charAt(0);
                                if (c == '\"' || c == '\'') {
                                    params.add(o.substring(1, o.length() - 1));
                                } else {
                                    params.add(o);
                                }
                                o = null;
                            }
                            search.pointer(Sql.getPointer(indexTable, column, pointerType), params.getArray());
                            column = null;
                            pointerType = -1;
                            params = null;
                            break;
                        }
                        o = sql.substring(s, e);
                        c = o.charAt(0);
                        if (c == '\"' || c == '\'') {
                            o = o.substring(1, o.length() - 1);
                        }
                        search.pointer(Sql.getPointer(indexTable, column, pointerType), o);
                        column = null;
                        pointerType = -1;
                        o = null;
                        break;
                    }
                    case 5: {
                        if (ConvertUtil.eqEng(sql, s, e, "where")) {
                            column = null;
                            pointerType = -1;
                            type = 4;
                            break;
                        }
                        if (sql.charAt(s) == ',') break;
                        if (column != null) {
                            c = '\u0000';
                            if (ConvertUtil.eqEng(sql, s, e, "asc")) {
                                c = '\u0001';
                                descFlag = false;
                            } else if (ConvertUtil.eqEng(sql, s, e, "desc")) {
                                c = '\u0001';
                                descFlag = true;
                            }
                            if ("point".equals(column)) {
                                search.sort(descFlag);
                                column = null;
                            } else {
                                search.sort(descFlag, column);
                                column = null;
                            }
                            if (c == '\u0001') break;
                        }
                        column = ConvertUtil.eqEng(sql, s, e, "point") ? "point" : TableUtil.convertJavaNameByDBName(sql.substring(s, e));
                    }
                }
            }
            i += 2;
        }
        if (type == 5 && column != null) {
            if ("point".equals(column)) {
                search.sort(descFlag);
            } else {
                search.sort(descFlag, column);
            }
        }
        if (search == null) {
            throw new RimDbException("\u5bfe\u8c61SQL\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + sql);
        }
        if (cacheName != null) {
            SearchImpl ret = search.create();
            cache.set(cacheName, ret);
            return ret;
        }
        return search.create();
    }

    private static final NList cutCode(String sql, int offset, int len) {
        int cote = -1;
        int b = -1;
        int s = -1;
        NList ret = new NList(len >> 2);
        int i = offset;
        while (i < len) {
            int c = sql.charAt(i);
            if (cote != -1) {
                if (c == cote && b != 92) {
                    ret.add(s);
                    ret.add(i + 1);
                    cote = -1;
                    s = -1;
                }
            } else if (c == 39 || c == 34) {
                if (s != -1) {
                    ret.add(s);
                    ret.add(i);
                }
                s = i;
                cote = c;
            } else if (c == 40 || c == 41 || c == 91 || c == 93 || c == 63 || c == 59 || c == 44 || c == 58) {
                if (s != -1) {
                    ret.add(s);
                    ret.add(i);
                }
                s = -1;
                ret.add(i);
                ret.add(i + 1);
            } else if (c == 33 || c == 60 || c == 62 || c == 61) {
                char cc;
                if (s != -1) {
                    ret.add(s);
                    ret.add(i);
                }
                s = -1;
                if (i + 1 < len && ((cc = sql.charAt(i + 1)) == '=' || c == 60 && cc == '>')) {
                    ret.add(i);
                    ret.add(i + 2);
                    c = cc;
                    ++i;
                } else {
                    ret.add(i);
                    ret.add(i + 1);
                }
            } else if (c == 32 || c == 9 || c == 13 || c == 10) {
                if (s != -1) {
                    ret.add(s);
                    ret.add(i);
                }
                s = -1;
            } else if (s == -1) {
                s = i;
            }
            b = c;
            ++i;
        }
        if (s != -1) {
            ret.add(s);
            ret.add(len);
        }
        return ret;
    }

    private static final Pointer getPointer(Indexs indexTable, String name, int type) {
        switch (type) {
            case 1: {
                return indexTable.eq(name);
            }
            case 2: {
                return indexTable.in(name);
            }
            case 3: {
                return indexTable.big(name);
            }
            case 4: {
                return indexTable.bigEq(name);
            }
            case 5: {
                return indexTable.small(name);
            }
            case 6: {
                return indexTable.smallEq(name);
            }
            case 7: {
                return indexTable.not(name);
            }
            case 8: {
                return indexTable.between(name);
            }
            case 9: {
                return indexTable.like(name);
            }
            case 10: {
                return indexTable.position();
            }
        }
        throw new RimDbException("\u30ab\u30e9\u30e0\u540d[" + name + "]\u306b\u5bfe\u3057\u3066\u3001\u6761\u4ef6\u5f0f[" + type + "]\u304c\u4e0d\u660e\u3067\u3059");
    }
}

