package org.maachang.mimdb.core.impl ;

import org.maachang.mimdb.core.ResultArray;

/**
 * フラグリスト
 * 
 * @version 2013/10/27
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface Flags {
    
    /** １ブロックサイズ. **/
    public static int BLOCK_SIZE = 1024 ;
    
    /** １ブロックの内部配列数. **/
    public static int BLOCK_INNER_SIZE = 32 ;
    
    /**
     * 情報破棄.
     */
    public void destroy() ;
    
    /**
     * 管理情報をクリア.
     */
    public void clear() ;
    
    /**
     * Andモード取得.
     * @return boolean [true]の場合、ANDモードです.
     */
    public boolean isAnd() ;
    
    /**
     * 指定位置のフラグをON.
     * @param no 対象の項番を設定します.
     */
    public void add( int no ) ;
    
    /**
     * 指定位置のフラグをON.
     * @param array 対象の項番群を設定します.
     */
    public void addArray( int[] array ) ;
    
    /**
     * 指定位置のフラグを設定.
     * @param no 対象の項番を設定します.
     * @param f フラグ条件を設定します.
     *          [0]がOFF、[1]がONです.
     */
    public void set( int no,int f ) ;
    
    /**
     * 指定位置のフラグを設定.
     * @param array 対象の項番群を設定します.
     * @param f フラグ条件を設定します.
     *          [0]がOFF、[1]がONです.
     */
    public void setArray( int[] array,int f ) ;
    
    /**
     * 全てのフラグをONに設定.
     */
    public void all() ;
    
    /**
     * 対象の条件をマージ.
     * @param f マージ対象のオブジェクトを設定します.
     */
    public void marge( Flags f ) ;
    
    /**
     * 指定位置のフラグを取得.
     * @param no 対照の項番を設定します.
     * @return int フラグ条件が返却されます.
     *          [0]がOFF、[1]がONです.
     */
    public int get( int no ) ;
    
    /**
     * 最大データ数を取得.
     * @return int データ数が返却されます.
     */
    public int max() ;
    
    /**
     * フラグがONの件数を取得.
     * @return int フラグがONの件数が返却されます.
     */
    public int size() ;
    
    /**
     * 検索結果情報を取得.
     * @param out 対象のオブジェクトが設定されます.
     * @return int 取得件数が返却されます.
     */
    public int getResultArray( ResultArray[] out ) ;
    
    /**
     * 検索結果情報を取得.
     * @param out 対象のオブジェクトが設定されます.
     * @param off 対象のオフセット値を設定します.
     * @return int 取得件数が返却されます.
     */
    public int getResultArray( ResultArray[] out,int off )  ;
}
