/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.maachang.mimdb.MimdbDatabase;
import org.maachang.mimdb.core.MimdbMetaData;
import org.maachang.mimdb.core.MimdbQuery;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.core.util.AtomicObject;

class ReceiveMaintenanceServer
extends Thread {
    private static final int MAX_READ = 4096;
    private static final String CHARSET = "UTF8";
    private Map<String, MimdbDatabase> map = null;
    private final AtomicObject<Socket> socket = new AtomicObject();
    private final AtomicNumber32 stopFlag = new AtomicNumber32(0);
    private final Object waitObject = new Object();
    private static final byte[] NOT_BYTE = new byte[]{0, 0};

    public ReceiveMaintenanceServer(Map<String, MimdbDatabase> map) {
        this.map = map;
        this.stopFlag.set(1);
        this.setDaemon(true);
        this.start();
    }

    public void stopThread() {
        this.stopFlag.set(0);
        Socket s = this.socket.get();
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSocket(Socket s) throws Exception {
        if (this.stopFlag.get() == 0) {
            return false;
        }
        if (this.socket.get() == null) {
            s.setReuseAddress(true);
            s.setSoLinger(true, 5);
            s.setSendBufferSize(32768);
            s.setReceiveBufferSize(32768);
            s.setKeepAlive(false);
            s.setTcpNoDelay(true);
            s.setOOBInline(true);
            s.setSoTimeout(1000);
            this.socket.set(s);
            Object object = this.waitObject;
            synchronized (object) {
                this.waitObject.notify();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block57: {
            s = null;
            buf = new byte[4096];
            block53: while (true) {
                while (true) {
                    if (this.stopFlag.get() == 0) break block57;
                    s = this.socket.get();
                    if (s == null) {
                        e = this.waitObject;
                        synchronized (e) {
                            this.waitObject.wait(100L);
                        }
                        s = this.socket.get();
                        if (s == null) continue;
                    }
                    if (this.stopFlag.get() == 0) break block57;
                    if (this.recv(s, buf)) {
                        s = null;
                    }
                    if (s == null) continue;
                    this.socket.set(null);
                    try {
                        s.getInputStream().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        s.getOutputStream().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        s.close();
                        continue block53;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {}
                    continue block53;
                    finally {
                        if (s != null) ** break;
                        continue;
                        this.socket.set(null);
                        try {
                            s.getInputStream().close();
                        }
                        catch (Exception e) {}
                        try {
                            s.getOutputStream().close();
                        }
                        catch (Exception e) {}
                        try {
                            s.close();
                            continue block53;
                        }
                        catch (Exception e) {}
                    }
                    break;
                }
            }
            finally {
                this.stopThread();
            }
        }
    }

    private final boolean recv(Socket s, byte[] buf) throws Exception {
        int len = -1;
        int recvLen = -1;
        int off = 0;
        InputStream in = s.getInputStream();
        while (true) {
            if (this.stopFlag.get() == 0) {
                return false;
            }
            try {
                len = in.read(buf, off, 4096 - off);
                if (len <= 0) {
                    if (len > -1) continue;
                    return false;
                }
            }
            catch (SocketTimeoutException st) {
                continue;
            }
            if (off == 0 && (recvLen = buf[0] & 0xFF | (buf[1] & 0xFF) << 8) + 2 >= 4096) {
                return false;
            }
            if ((off += len) >= recvLen + 2) break;
        }
        String rv = new String(buf, 2, recvLen, CHARSET);
        ReceiveMaintenanceServer.execution(this.map, rv, new BufferedOutputStream(s.getOutputStream()), buf);
        return true;
    }

    private static final void execution(Map<String, MimdbDatabase> map, String sv, OutputStream out, byte[] buf) throws Exception {
        try {
            sv = sv.trim();
            if (sv.endsWith(";")) {
                sv = sv.substring(0, sv.length() - 1).trim();
            }
            String lw = sv.trim().toLowerCase();
            String[] lcmd = ReceiveMaintenanceServer.analysisCmd(lw);
            String top = lcmd[0];
            MimdbDatabase emb = null;
            if (lw.equals("?")) {
                StringBuilder b = new StringBuilder();
                b.append("[database]").append("  \u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u4e00\u89a7").append("\n");
                b.append("[tables] $(databaseName)").append("  \u30c6\u30fc\u30d6\u30eb\u4e00\u89a7").append("\n");
                b.append("[length] $(databaseName)").append("  \u30c6\u30fc\u30d6\u30eb\u6570").append("\n");
                b.append("[reload] $(databaseName)").append("  database\u518d\u8aad\u307f\u8fbc\u307f").append("\n");
                b.append("[id      $(databaseName) $(tableName)]").append("  \u30c6\u30fc\u30d6\u30eb\u66f4\u65b0ID\u53d6\u5f97").append("\n");
                b.append("[update  $(databaseName) $(tableName) or *]").append("  \u30c6\u30fc\u30d6\u30eb\u66f4\u65b0").append("\n");
                ReceiveMaintenanceServer.sendString(b.toString(), out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (top.equals("database")) {
                int len = map.size();
                String[] v = new String[len];
                int c = 0;
                Iterator<String> it = map.keySet().iterator();
                while (it.hasNext()) {
                    if (c & true) {
                        v[c++] = "    " + it.next();
                        continue;
                    }
                    v[c++] = it.next();
                }
                ReceiveMaintenanceServer.sendString(v, out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (top.equals("tables")) {
                if (lcmd.length <= 1) {
                    ReceiveMaintenanceServer.sendString("tables\u30b3\u30de\u30f3\u30c9\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5fc5\u8981\u3067\u3059", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb = map.get(lcmd[1]);
                if (emb == null) {
                    ReceiveMaintenanceServer.sendString("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d(" + lcmd[1] + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                String[] list = emb.getTables();
                int len = list.length;
                String[] v = new String[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = list[i] + " " + MimdbTableManager.getInstance().getId(list[i]);
                }
                ReceiveMaintenanceServer.sendString(v, out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (top.equals("length")) {
                if (lcmd.length <= 1) {
                    ReceiveMaintenanceServer.sendString("length\u30b3\u30de\u30f3\u30c9\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5fc5\u8981\u3067\u3059", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb = map.get(lcmd[1]);
                if (emb == null) {
                    ReceiveMaintenanceServer.sendString("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d(" + lcmd[1] + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                ReceiveMaintenanceServer.sendString(String.valueOf(emb.length()), out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (top.equals("reload")) {
                if (lcmd.length <= 1) {
                    ReceiveMaintenanceServer.sendString("reload\u30b3\u30de\u30f3\u30c9\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5fc5\u8981\u3067\u3059", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb = map.get(lcmd[1]);
                if (emb == null) {
                    ReceiveMaintenanceServer.sendString("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d(" + lcmd[1] + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb.loadAll();
                ReceiveMaintenanceServer.sendString("true", out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (top.equals("id")) {
                if (lcmd.length <= 2) {
                    ReceiveMaintenanceServer.sendString("id\u30b3\u30de\u30f3\u30c9\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u3001\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5fc5\u8981\u3067\u3059", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb = map.get(lcmd[1]);
                if (emb == null) {
                    ReceiveMaintenanceServer.sendString("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d(" + lcmd[1] + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                if (emb.isTable(lcmd[2])) {
                    ReceiveMaintenanceServer.sendString(String.valueOf(MimdbTableManager.getInstance().getId(lcmd[2])), out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                } else {
                    ReceiveMaintenanceServer.sendString("-1", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                }
            } else if (top.equals("update")) {
                if (lcmd.length <= 2) {
                    ReceiveMaintenanceServer.sendString("update\u30b3\u30de\u30f3\u30c9\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u3001\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5fc5\u8981\u3067\u3059", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                emb = map.get(lcmd[1]);
                if (emb == null) {
                    ReceiveMaintenanceServer.sendString("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d(" + lcmd[1] + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", out, buf);
                    ReceiveMaintenanceServer.endByte(out);
                    out.flush();
                    return;
                }
                ReceiveMaintenanceServer.sendString(ReceiveMaintenanceServer.updateTable(emb, lcmd[2].trim()), out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            } else if (lw.indexOf(" from ") != -1) {
                ReceiveMaintenanceServer.executionSQL(sv, out, buf);
                out.flush();
            } else {
                ReceiveMaintenanceServer.sendString("[" + sv + "]\u306e\u30b3\u30de\u30f3\u30c9\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093", out, buf);
                ReceiveMaintenanceServer.endByte(out);
                out.flush();
            }
        }
        catch (Throwable t) {
            ReceiveMaintenanceServer.sendString(t.toString(), out, buf);
            ReceiveMaintenanceServer.endByte(out);
            out.flush();
        }
    }

    private static final void endByte(OutputStream os) throws Exception {
        os.write(NOT_BYTE, 0, 2);
    }

    private static final void sendString(Object out, OutputStream os, byte[] buf) throws Exception {
        String s;
        int len;
        if (out instanceof String[]) {
            String[] n = (String[])out;
            len = n.length;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    b.append("\n");
                }
                b.append(n[i]);
            }
            s = b.toString();
        } else {
            s = (String)out;
        }
        byte[] res = s.getBytes(CHARSET);
        len = res.length;
        if (len + 2 >= 4096) {
            len = 4094;
        }
        buf[0] = (byte)(len & 0xFF);
        buf[1] = (byte)((len & 0xFF00) >> 8);
        System.arraycopy(res, 0, buf, 2, len);
        res = null;
        os.write(buf, 0, len + 2);
    }

    private static final String updateTable(MimdbDatabase emb, String table) throws Exception {
        if (emb.isTable(table)) {
            if (emb.reload(table)) {
                return "true";
            }
            return "false";
        }
        if ("*".equals(table)) {
            emb.reloadAll();
            return "true";
        }
        return "false";
    }

    private static final void executionSQL(String sql, OutputStream out, byte[] b) throws Exception {
        MimdbQuery stmt = MimdbQuery.create(sql);
        MimdbResult res = stmt.executeQuery();
        MimdbMetaData meta = res.getMetaData();
        int len = meta.getColumnSize();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                buf.append("| ");
            }
            buf.append(meta.getColumnName(i));
        }
        String s = buf.append("\n").toString();
        buf = null;
        ReceiveMaintenanceServer.sendString(s, out, b);
        int resLen = res.length();
        for (int i = 0; i < resLen; ++i) {
            buf = new StringBuilder();
            if (i != 0) {
                buf.append("\n");
            }
            MimdbResultRow r = res.get(i);
            for (int j = 0; j < len; ++j) {
                if (j != 0) {
                    buf.append("| ");
                }
                buf.append(r.get(j));
            }
            s = buf.toString();
            buf = null;
            ReceiveMaintenanceServer.sendString(s, out, b);
        }
        ReceiveMaintenanceServer.sendString("\n" + resLen + "\u4ef6", out, b);
        ReceiveMaintenanceServer.endByte(out);
    }

    private static final String[] analysisCmd(String s) {
        int cote = -1;
        int len = s.length();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> cmd = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (cote != -1) {
                if (c == cote) {
                    cmd.add(buf.toString().substring(1, buf.length()));
                    buf = new StringBuilder();
                    cote = -1;
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            if (c == 39 || c == 34) {
                cote = c;
                buf.append((char)c);
                continue;
            }
            if (c == 32 || c == 9) {
                if (buf.length() <= 0) continue;
                cmd.add(buf.toString().trim());
                buf = new StringBuilder();
                continue;
            }
            buf.append((char)c);
        }
        if (buf.length() > 0) {
            cmd.add(buf.toString().trim());
        }
        String[] ret = new String[cmd.size()];
        for (int i = 0; i < cmd.size(); ++i) {
            ret[i] = (String)cmd.get(i);
        }
        return ret;
    }
}

