/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import org.maachang.mimdb.Mimdb;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.core.util.Config;
import org.maachang.mimdb.server.MimdbIOThread;
import org.maachang.mimdb.server.NioSelector;

public final class MimdbServer
extends Thread {
    protected static final int SEND_BYTE_ARRAY_LENGTH = 4096;
    protected static final int RECV_BYTE_ARRAY_LENGTH = 1024;
    private static final String SERVER_CONF = "mimdb.conf";
    private static final int DEF_BACK_LOG = 50;
    private static final int DEF_THREAD = 1;
    private static final int MAX_THREAD = 100;
    private static final int SELECTOR_TIMEOUT = 1000;
    private final AtomicNumber32 stopFlag = new AtomicNumber32(0);
    private NioSelector selector;
    private ServerSocketChannel channel;
    private Mimdb mimdb;
    protected String envFolder;
    private MimdbIOThread[] ioList;
    private String bindAddr;
    private int bindPort;
    private int backlog;
    private boolean compress;

    private MimdbServer() {
    }

    public MimdbServer(String folder) throws Exception {
        this._init(folder);
    }

    public static final void print(String s) {
        System.out.print(s);
    }

    public static final void println(String s) {
        System.out.println(s);
    }

    private final void _init(String folder) throws Exception {
        if (folder == null || folder.length() == 0) {
            throw new IllegalArgumentException("\u74b0\u5883\u5b9a\u7fa9\u30d5\u30a9\u30eb\u30c0\u30fc\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        long allTime = System.currentTimeMillis();
        if (!(folder = MimdbUtils.getFullPath(folder)).endsWith("/")) {
            folder = folder + "/";
        }
        String file = folder + SERVER_CONF;
        Config conf = Config.read(file);
        String bindAddr = conf.getString("server", "addr", 0);
        int bindPort = conf.getInt("server", "port", 0);
        int backlog = conf.getInt("server", "backlog", 0);
        int threadLength = conf.getInt("server", "thread", 0);
        boolean compress = conf.getBoolean("server", "compress", 0);
        if (bindAddr == null || (bindAddr = bindAddr.trim()).length() <= 0 || "0.0.0.0".equals(bindAddr)) {
            bindAddr = null;
        }
        if (bindPort <= 0 || bindPort > 65535) {
            bindPort = 3210;
        }
        if (backlog <= 0) {
            backlog = 50;
        }
        if (threadLength <= 0) {
            threadLength = 1;
        } else if (threadLength > 100) {
            threadLength = 100;
        }
        MimdbServer.println("## start mimdb server ");
        MimdbServer.println("   address :" + (bindAddr == null ? "0.0.0.0" : bindAddr));
        MimdbServer.println("   port    :" + bindPort);
        MimdbServer.println("   backlog :" + backlog);
        MimdbServer.println("   thread  :" + threadLength);
        MimdbServer.println("   compress:" + compress);
        MimdbServer.println("");
        Mimdb mimdb = Mimdb.getInstance();
        mimdb.init(conf);
        Map<String, String> alias = mimdb.getAlias();
        for (String name : alias.keySet()) {
            long time = System.currentTimeMillis();
            MimdbServer.print("## load database " + name + " ");
            mimdb.getDatabase(name);
            time = System.currentTimeMillis() - time;
            MimdbServer.println(" ... ok   " + time + "msec");
        }
        MimdbServer.println("");
        MimdbServer.println("## start server.");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "0");
        ServerSocketChannel ch = ServerSocketChannel.open();
        ch.configureBlocking(false);
        ServerSocket soc = ch.socket();
        soc.setReuseAddress(true);
        if (bindAddr == null) {
            soc.bind(new InetSocketAddress(bindPort), backlog);
        } else {
            soc.bind(new InetSocketAddress(bindAddr, bindPort), backlog);
        }
        soc = null;
        NioSelector sc = new NioSelector();
        sc.register(ch, 16);
        MimdbIOThread[] io = new MimdbIOThread[threadLength];
        for (int i = 0; i < threadLength; ++i) {
            io[i] = new MimdbIOThread(i, compress);
        }
        allTime = System.currentTimeMillis() - allTime;
        MimdbServer.println("");
        MimdbServer.println("## success " + allTime + "msec.");
        this.selector = sc;
        this.channel = ch;
        this.mimdb = mimdb;
        this.envFolder = folder;
        this.ioList = io;
        this.bindAddr = bindAddr == null ? "0.0.0.0" : bindAddr;
        this.bindPort = bindPort;
        this.backlog = backlog;
        this.compress = compress;
    }

    public void startThread() throws Exception {
        this.stopFlag.set(1);
        this.setDaemon(true);
        this.start();
        int len = this.ioList.length;
        for (int i = 0; i < len; ++i) {
            this.ioList[i].startThread();
        }
    }

    public void stopThread() {
        this.stopFlag.set(0);
    }

    public boolean isStop() {
        return this.stopFlag.get() == 0;
    }

    public String getEnvFolder() {
        return this.envFolder;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public int getBackLog() {
        return this.backlog;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public Mimdb getMimdb() {
        return this.mimdb;
    }

    @Override
    public void run() {
        ThreadDeath tdObject = null;
        boolean endFlag = false;
        SelectionKey key = null;
        int no = 0;
        int threadLen = this.ioList.length;
        MimdbServer.println("****** mimdbServer [\u958b\u59cb] *****");
        NioSelector s = this.selector;
        while (this.stopFlag.get() == 1) {
            try {
                if (endFlag) break;
                if (s.select(1000) == 0) continue;
                Iterator<SelectionKey> it = s.iterator();
                while (it != null && it.hasNext() && this.stopFlag.get() == 1 && !endFlag) {
                    SocketChannel ch;
                    key = it.next();
                    it.remove();
                    if (key == null || !key.isAcceptable() || (ch = this.channel.accept()) == null) continue;
                    no = no >= threadLen ? 0 : no;
                    this.ioList[no++].register(ch);
                }
            }
            catch (ThreadDeath td) {
                tdObject = td;
                endFlag = true;
            }
            catch (Throwable t) {
            }
        }
        this.stopFlag.set(0);
        MimdbServer.println("****** mimdbServer [\u505c\u6b62] *****");
        s.close();
        this.selector = null;
        try {
            this.channel.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.channel = null;
        try {
            for (int i = 0; i < threadLen; ++i) {
                try {
                    this.ioList[i].stopThread();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (tdObject != null) {
            throw tdObject;
        }
    }
}

