/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.lang.ref.SoftReference;
import java.nio.channels.SocketChannel;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.util.ByteArrayIO;
import org.maachang.mimdb.core.util.NumberKeyValue;

public final class MimdbConnectElement {
    protected SocketChannel channel = null;
    protected long lastAccess = System.currentTimeMillis();
    protected ByteArrayIO recvBuffer = new ByteArrayIO(1024);
    protected int recvType = 0;
    protected int nowRecvLength = 0;
    protected byte[] sendHeader = null;
    protected int nowSendHeaderOffset = 0;
    protected byte[] sendBuffer = null;
    protected int nowSendLength = 0;
    protected int nowSendOffset = 0;
    protected int preparedSeqId = 0;
    protected NumberKeyValue<SoftReference<QueryCompileInfo>> preparedList = new NumberKeyValue();
    protected int resultSeqId = 0;
    protected NumberKeyValue<MimdbResult> resultList = new NumberKeyValue();

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public final void destroy() {
        if (this.channel != null) {
            try {
                this.channel.socket().close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.channel = null;
        }
        if (this.recvBuffer != null) {
            this.recvBuffer.clear();
            this.recvBuffer = null;
        }
        this.sendBuffer = null;
        this.sendHeader = null;
        if (this.preparedList != null) {
            this.preparedList.clear();
            this.preparedList = null;
        }
        if (this.resultList != null) {
            if (this.resultList.size() > 0) {
                NumberKeyValue<MimdbResult> it = this.resultList.reset();
                while (it.hasNext()) {
                    this.resultList.get(it.next()).clear();
                }
                this.resultList.clear();
            }
            this.resultList = null;
        }
    }

    public final void clear() {
        if (this.preparedList != null) {
            this.preparedList.clear();
        }
        if (this.resultList != null && this.resultList.size() > 0) {
            NumberKeyValue<MimdbResult> it = this.resultList.reset();
            while (it.hasNext()) {
                this.resultList.get(it.next()).clear();
            }
            this.resultList.clear();
        }
        this.preparedSeqId = 0;
        this.resultSeqId = 0;
    }

    public final int getPreparedSequenceId() {
        if (this.preparedList.size() > 999999999) {
            throw new MimdbException("\u7ba1\u7406\u53ef\u80fd\u306a\u30b3\u30f3\u30d1\u30a4\u30eb\u6e08\u307f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u6570\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059");
        }
        do {
            ++this.preparedSeqId;
            if (this.preparedSeqId <= 999999999) continue;
            this.preparedSeqId = 0;
        } while (this.preparedList.containsKey(this.preparedSeqId));
        return this.preparedSeqId;
    }

    public final int getResultSetSequenceId() {
        if (this.resultList.size() > 999999999) {
            throw new MimdbException("\u7ba1\u7406\u53ef\u80fd\u306a\u7d50\u679c\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u6570\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059");
        }
        do {
            ++this.resultSeqId;
            if (this.resultSeqId <= 999999999) continue;
            this.resultSeqId = 0;
        } while (this.resultList.containsKey(this.resultSeqId));
        return this.resultSeqId;
    }
}

