/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.jdbc.MimdbJdbcPreparedStatement;
import org.maachang.mimdb.jdbc.MimdbJdbcStatement;

public final class MimdbJdbcConnection
implements Connection {
    protected MimdbConnection connection = null;

    private MimdbJdbcConnection() {
    }

    public MimdbJdbcConnection(MimdbConnection conn) {
        this.connection = conn;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    protected final void check() {
        if (this.connection == null || this.connection.isClose()) {
            throw new MimdbException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public void commit() throws SQLException {
        this.check();
    }

    @Override
    public void rollback() throws SQLException {
        this.check();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.check();
        return new MimdbJdbcStatement(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.check();
        return new MimdbJdbcPreparedStatement(this, this.connection, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.check();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.check();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.check();
        return true;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.check();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.check();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.check();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.check();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.check();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.check();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.check();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.check();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.check();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.check();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.check();
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.check();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.check();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.check();
        return false;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.check();
    }

    @Override
    public String getSchema() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.check();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.check();
        this.connection.setTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.check();
        return this.connection.getTimeout();
    }
}

