/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

public class ObjectList<T> {
    private static final int DEF_LENGTH = 8;
    private Object[] list;
    private int length;
    private int max;

    public ObjectList() {
        this(8);
    }

    public ObjectList(int buf) {
        if (buf < 8) {
            buf = 8;
        }
        this.max = buf;
        this.list = new Object[buf];
        this.length = 0;
    }

    public void clear() {
        if (this.list.length != this.max) {
            this.list = new Object[this.max];
        }
        this.length = 0;
    }

    public void add(T n) {
        if (this.length + 1 >= this.list.length) {
            Object[] tmp = new Object[this.length << 1];
            System.arraycopy(this.list, 0, tmp, 0, this.length);
            this.list = tmp;
        }
        this.list[this.length++] = n;
    }

    public void set(int no, T o) {
        this.list[no] = o;
    }

    public T get(int no) {
        return (T)this.list[no];
    }

    public void remove(int no) {
        if (this.length > 1) {
            --this.length;
            while (no < this.length) {
                this.list[no++] = this.list[no];
            }
            this.list[this.length] = null;
        } else {
            this.length = 0;
            this.list[0] = null;
        }
    }

    public int size() {
        return this.length;
    }

    public int search(T n) {
        int len = this.length;
        if (n == null) {
            for (int i = 0; i < len; ++i) {
                if (this.list[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!n.equals(this.list[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object[] getArray() {
        Object[] ret = new Object[this.length];
        System.arraycopy(this.list, 0, ret, 0, this.length);
        return ret;
    }
}

