/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberKeySet;

public final class ObjectKeySet<T> {
    private static final int DEF_LENGTH = 32;
    private ObjectKeyChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private boolean nullFlag;
    private int pos = 0;
    private ObjectKeyChild cPos = null;
    private int count = 0;
    private boolean nullOutFlag = false;

    public ObjectKeySet() {
        this(32);
    }

    public ObjectKeySet(int size) {
        size = size <= 32 ? 32 : NumberKeySet.bitMask(size);
        this.list = new ObjectKeyChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
        this.nullFlag = false;
    }

    public void clear() {
        this.list = new ObjectKeyChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
        this.nullFlag = false;
    }

    public void add(T b) {
        int bh;
        int h;
        if (b == null) {
            this.nullFlag = true;
            return;
        }
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            ObjectKeyChild[] nList = new ObjectKeyChild[nLen];
            for (int i = 0; i < this.limit; ++i) {
                ObjectKeyChild n = this.list[i];
                while (n != null) {
                    ObjectKeyChild t;
                    h = n.b.hashCode() & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = (bh = b.hashCode()) & this.mask] == null) {
            this.list[h] = new ObjectKeyChild(b);
            ++this.length;
        } else {
            ObjectKeyChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                    return;
                }
                nn = nn.n;
            }
            if (nn.b.hashCode() != bh || nn.b != b || !nn.b.equals(b)) {
                nn.n = new ObjectKeyChild(b);
                ++this.length;
            }
        }
    }

    public boolean contains(T b) {
        if (b == null) {
            return this.nullFlag;
        }
        int bh = b.hashCode();
        ObjectKeyChild n = this.list[bh & this.mask];
        while (n != null) {
            if (n.b.hashCode() == bh && (n.b == b || n.b.equals(b))) {
                return true;
            }
            n = n.n;
        }
        return false;
    }

    public void remove(Object b) {
        if (b == null) {
            this.nullFlag = false;
            return;
        }
        int bh = b.hashCode();
        ObjectKeyChild bf = null;
        ObjectKeyChild n = this.list[bh & this.mask];
        while (n != null) {
            if (n.b.hashCode() == bh && (n.b == b || n.b.equals(b))) {
                if (bf == null) {
                    this.list[bh & this.mask] = n.n == null ? null : n.n;
                } else {
                    bf.n = n.n == null ? null : n.n;
                }
                --this.length;
                break;
            }
            bf = n;
            n = n.n;
        }
    }

    public int size() {
        return this.nullFlag ? this.length + 1 : this.length;
    }

    public Object[] array() {
        int cnt;
        Object[] ret;
        if (this.size() == 0) {
            return null;
        }
        if (this.nullFlag) {
            ret = new Object[this.length + 1];
            cnt = 1;
        } else {
            ret = new Object[this.length];
            cnt = 0;
        }
        for (int i = 0; i < this.limit; ++i) {
            if (this.list[i] == null) continue;
            ObjectKeyChild n = this.list[i];
            while (n != null) {
                ret[cnt++] = n.b;
                n = n.n;
            }
        }
        return ret;
    }

    public ObjectKeySet<T> reset() {
        this.pos = 0;
        this.cPos = null;
        this.count = 0;
        this.nullOutFlag = false;
        return this;
    }

    public boolean hasNext() {
        if (this.count == 0) {
            if (this.nullFlag) {
                ++this.count;
                return true;
            }
            this.nullOutFlag = true;
        }
        if (this.cPos != null && (this.cPos = this.cPos.n) != null) {
            ++this.count;
            return true;
        }
        while (this.pos < this.limit) {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            ++this.count;
            return true;
        }
        return false;
    }

    public T next() {
        if (!this.nullOutFlag) {
            this.nullOutFlag = true;
            return null;
        }
        if (this.cPos == null) {
            return null;
        }
        return (T)this.cPos.b;
    }

    public int count() {
        return this.count;
    }

    private static final class ObjectKeyChild {
        Object b;
        ObjectKeyChild n;

        ObjectKeyChild(Object v) {
            this.b = v;
        }
    }
}

