/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.impl.AbstractSmallFlags;
import org.maachang.mimdb.core.impl.Flags;

public final class SmallFlagsBase
extends AbstractSmallFlags {
    public SmallFlagsBase() {
    }

    public SmallFlagsBase(int len) {
        this.create(len);
    }

    public SmallFlagsBase(Flags f) {
        this.create(f);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public final void create(int len) {
        int n = (len >> 10) + ((len & 0x3FF) == 0 ? 0 : 1);
        this.max = len;
        this.flags = new int[n][];
    }

    public final void create(Flags f) {
        AbstractSmallFlags sf = (AbstractSmallFlags)f;
        int[][] ff = sf.flags;
        int m = sf.max;
        f.destroy();
        this.flags = ff;
        this.max = m;
    }

    @Override
    public final boolean isAnd() {
        return false;
    }

    @Override
    public final void add(int no) {
        int n = no >> 10;
        int nn = no & 0x3FF;
        int[] ff = this.flags[n];
        if (ff == null) {
            ff = new int[32];
            this.flags[n] = ff;
        }
        int n2 = nn >> 5;
        ff[n2] = ff[n2] | 1 << (nn & 0x1F);
    }

    @Override
    public final void addArray(int[] array) {
        int[] ff = null;
        int len = array.length;
        int b = -1;
        for (int i = 0; i < len; ++i) {
            int a = array[i];
            int n = a >> 10;
            int nn = a & 0x3FF;
            if (b != n) {
                ff = this.flags[n];
                if (ff == null) {
                    ff = new int[32];
                    this.flags[n] = ff;
                }
                b = n;
            }
            int n2 = nn >> 5;
            ff[n2] = ff[n2] | 1 << (nn & 0x1F);
        }
    }

    @Override
    public final void set(int no, int f) {
        int n = no >> 10;
        int nn = no & 0x3FF;
        int[] ff = this.flags[n];
        if (ff == null) {
            ff = new int[32];
            this.flags[n] = ff;
        }
        ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
    }

    @Override
    public final void setArray(int[] array, int f) {
        int[] ff = null;
        int len = array.length;
        int b = -1;
        for (int i = 0; i < len; ++i) {
            int a = array[i];
            int n = a >> 10;
            int nn = a & 0x3FF;
            if (b != n) {
                ff = this.flags[n];
                if (ff == null) {
                    ff = new int[32];
                    this.flags[n] = ff;
                }
                b = n;
            }
            ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
        }
    }

    @Override
    public final void all() {
        int len = this.flags.length;
        for (int i = 0; i < len; ++i) {
            if (this.flags[i] == null) {
                this.flags[i] = new int[32];
            }
            Arrays.fill(this.flags[i], -1);
        }
    }

    @Override
    public final void marge(Flags f) {
        AbstractSmallFlags sf = (AbstractSmallFlags)f;
        if (sf.max() != this.max) {
            throw new MimdbException("\u9577\u3055\u304c\u4e0d\u4e00\u81f4:" + sf.max + " " + this.max);
        }
        int[][] bff = sf.flags;
        int len = bff.length;
        for (int i = 0; i < len; ++i) {
            int[] bf = bff[i];
            if (bf == null) continue;
            int[] ff = this.flags[i];
            if (ff == null) {
                ff = new int[32];
                this.flags[i] = ff;
            }
            for (int j = 0; j < 32; ++j) {
                int n = j;
                ff[n] = ff[n] | bf[j];
            }
        }
    }
}

