/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.Arrays;
import org.maachang.mimdb.core.impl.MStringIndexKey;
import org.maachang.mimdb.core.impl.NGramLineList;
import org.maachang.mimdb.core.impl.NGramResult;
import org.maachang.mimdb.core.util.NumberKeyValue;
import org.maachang.mimdb.core.util.ObjectList;

public class NGram {
    private NGram() {
    }

    public static final Object createIndex(MStringIndexKey[] list) throws Exception {
        NGramWork w;
        int n;
        int j;
        int lenJ;
        int len;
        if (list == null) {
            return null;
        }
        int srcLen = len = list.length;
        NumberKeyValue<NGramWork> work = new NumberKeyValue<NGramWork>(len);
        for (int i = 0; i < len; ++i) {
            if (list[i] == null || list[i].length() <= 0) continue;
            char[] s = list[i].value;
            lenJ = s.length;
            for (j = 0; j < lenJ; ++j) {
                n = s[j] & 0xFFFF;
                w = (NGramWork)work.get(n);
                if (w == null) {
                    w = new NGramWork();
                    w.element = n;
                    work.put(n, w);
                }
                w.info.add(new NGramInfo(j, j + 1 == lenJ, i));
            }
        }
        int cnt = 0;
        int allLength = 0;
        len = work.size();
        NumberKeyValue it = work.reset();
        Object[] emList = new NGramElement[len];
        while (it.hasNext()) {
            n = it.next();
            w = (NGramWork)it.nextValue();
            ObjectList<NGramInfo> tmp = w.info;
            lenJ = tmp.size();
            Object[] info = new NGramInfo[lenJ];
            for (j = 0; j < lenJ; ++j) {
                info[j] = tmp.get(j);
            }
            allLength += lenJ;
            Arrays.sort(info);
            NGramElement em = new NGramElement();
            em.element = n;
            em.info = info;
            emList[cnt++] = em;
        }
        Arrays.sort(emList);
        NGramIndex ret = new NGramIndex();
        ret.list = emList;
        ret.srcLength = srcLen;
        ret.src = list;
        ret.allLength = allLength;
        return ret;
    }

    private static final int searchNGramElements(NGramElement[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid].element;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static final int searchNGramInfo(NGramInfo[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid].lineNo;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            while (--mid >= 0 && a[mid].lineNo == key) {
            }
            if (mid < 0) {
                return 0;
            }
            return mid + 1;
        }
        return -1;
    }

    private static final int nextEq(MStringIndexKey[] list, int no, MStringIndexKey value, int off) {
        int p;
        char[] src = list[no].value;
        char[] chk = value.value;
        int len = chk.length;
        if (src.length < off + len) {
            return -1;
        }
        int i = off + 1;
        for (p = 1; p < len && src[i] == chk[p]; ++p) {
            ++i;
        }
        if (p == len) {
            return off;
        }
        return -1;
    }

    private static final int lastEq(MStringIndexKey[] list, int no, MStringIndexKey value, int off) {
        int p;
        char[] src = list[no].value;
        char[] chk = value.value;
        if (src.length < off + chk.length) {
            return -1;
        }
        int i = off;
        int len = chk.length - 1;
        for (p = 0; p < len && src[i] == chk[p]; ++p) {
            ++i;
        }
        if (p == len) {
            return off;
        }
        return -1;
    }

    public static final NGramResult startsWith(Object ngram, MStringIndexKey value) {
        NGramIndex index = (NGramIndex)ngram;
        int p = NGram.searchNGramElements(index.list, value.value[0]);
        if (p == -1) {
            return null;
        }
        NGramLineList res = new NGramLineList(false, index.srcLength);
        NGramInfo[] info = index.list[p].info;
        int len = info.length;
        int strLen = value.length;
        if (strLen == 1) {
            for (int i = 0; i < len; ++i) {
                if (info[i].position != 0) continue;
                res.add(info[i].lineNo, 1);
            }
        } else {
            MStringIndexKey[] src = index.src;
            for (int i = 0; i < len; ++i) {
                NGramInfo in = info[i];
                if (in.position != 0 || NGram.nextEq(src, in.lineNo, value, 0) != 0) continue;
                res.add(in.lineNo, strLen);
            }
        }
        return res;
    }

    public static final NGramResult endsWith(NGramResult and, Object ngram, MStringIndexKey value) {
        NGramResult res;
        NGramIndex index = (NGramIndex)ngram;
        int strLen = value.length;
        int p = NGram.searchNGramElements(index.list, value.value[strLen - 1]);
        if (p == -1) {
            return null;
        }
        int strLenM = strLen - 1;
        NGramInfo[] info = index.list[p].info;
        if (and != null) {
            res = and.newList();
            int len = and.length();
            MStringIndexKey[] src = index.src;
            if (strLen == 1) {
                block0: for (int i = 0; i < len; ++i) {
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i);
                    MStringIndexKey nowSrc = src[n];
                    while (j < lenJ) {
                        NGramInfo in = info[j];
                        if (n != in.lineNo) continue block0;
                        if (in.end && in.position - strLenM >= o && nowSrc.length == o + strLen + 1) {
                            res.add(in.lineNo, in.position);
                        }
                        ++j;
                    }
                }
            } else {
                block2: for (int i = 0; i < len; ++i) {
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i);
                    MStringIndexKey nowSrc = src[n];
                    while (j < lenJ) {
                        int oLen;
                        NGramInfo in = info[j];
                        if (n != in.lineNo) continue block2;
                        if (in.end && in.position - strLenM >= o && nowSrc.length == o + strLen + 1 && NGram.lastEq(src, in.lineNo, value, oLen = in.position - strLenM) == oLen) {
                            res.add(in.lineNo, in.position);
                        }
                        ++j;
                    }
                }
            }
        } else {
            res = new NGramLineList(false, index.srcLength);
            int len = info.length;
            if (strLen == 1) {
                for (int i = 0; i < len; ++i) {
                    if (!info[i].end) continue;
                    res.add(info[i].lineNo, info[i].position);
                }
            } else {
                MStringIndexKey[] src = index.src;
                for (int i = 0; i < len; ++i) {
                    int oLen;
                    NGramInfo in = info[i];
                    if (!in.end || NGram.lastEq(src, in.lineNo, value, oLen = in.position - strLenM) != oLen) continue;
                    res.add(in.lineNo, in.position);
                }
            }
        }
        return res;
    }

    public static final NGramResult indexOf(NGramResult and, Object ngram, MStringIndexKey value) {
        NGramResult res;
        NGramIndex index = (NGramIndex)ngram;
        int strLen = value.length;
        int p = NGram.searchNGramElements(index.list, value.value[0]);
        if (p == -1) {
            return null;
        }
        NGramInfo[] info = index.list[p].info;
        MStringIndexKey[] src = index.src;
        if (and != null) {
            res = and.newList();
            int len = and.length();
            if (strLen == 1) {
                block0: for (int i = 0; i < len; ++i) {
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i);
                    while (j < lenJ) {
                        NGramInfo in = info[j];
                        if (n != in.lineNo) continue block0;
                        if (in.position >= o) {
                            res.add(in.lineNo, in.position + strLen);
                            continue block0;
                        }
                        ++j;
                    }
                }
            } else {
                block2: for (int i = 0; i < len; ++i) {
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i);
                    while (j < lenJ) {
                        NGramInfo in = info[j];
                        if (n != in.lineNo) continue block2;
                        if (in.position >= o && NGram.nextEq(src, n, value, in.position) == in.position) {
                            res.add(in.lineNo, in.position + strLen);
                            continue block2;
                        }
                        ++j;
                    }
                }
            }
        } else {
            res = new NGramLineList(false, index.srcLength);
            int len = info.length;
            if (strLen == 1) {
                block4: for (int i = 0; i < len; ++i) {
                    int j = info[i].lineNo;
                    res.add(info[i].lineNo, info[i].position + strLen);
                    ++i;
                    while (i < len) {
                        if (info[i].lineNo != j) {
                            --i;
                            continue block4;
                        }
                        ++i;
                    }
                }
            } else {
                block6: for (int i = 0; i < len; ++i) {
                    NGramInfo in = info[i];
                    if (NGram.nextEq(src, in.lineNo, value, in.position) != in.position) continue;
                    res.add(in.lineNo, in.position + strLen);
                    ++i;
                    while (i < len) {
                        if (info[i].lineNo != in.lineNo) {
                            --i;
                            continue block6;
                        }
                        ++i;
                    }
                }
            }
        }
        return res;
    }

    public static final NGramResult eqaulsPosition(boolean last, NGramResult and, Object ngram, MStringIndexKey value, int addOff, MStringIndexKey beforeIndexOf) {
        NGramResult res;
        NGramIndex index = (NGramIndex)ngram;
        int strLen = value.length;
        int p = NGram.searchNGramElements(index.list, value.value[0]);
        if (p == -1) {
            return null;
        }
        NGramInfo[] info = index.list[p].info;
        MStringIndexKey[] src = index.src;
        int bwLen = beforeIndexOf != null ? beforeIndexOf.length : 0;
        if (last) {
            if (and != null) {
                res = and.newList();
                int len = and.length();
                if (strLen == 1) {
                    block0: for (int i = 0; i < len; ++i) {
                        NGramInfo in;
                        int j = NGram.searchNGramInfo(info, and.position(i));
                        if (j == -1) continue;
                        int lenJ = info.length;
                        int n = and.position(i);
                        int o = and.offset(i) + addOff;
                        MStringIndexKey nowSrc = src[n];
                        if (beforeIndexOf == null) {
                            while (j < lenJ) {
                                in = info[j];
                                if (n != in.lineNo) continue block0;
                                if (in.position == o && nowSrc.length() == o + strLen) {
                                    res.add(in.lineNo, o + strLen);
                                    continue block0;
                                }
                                ++j;
                            }
                            continue;
                        }
                        int oo = and.offset(i) - bwLen;
                        while (j < lenJ) {
                            in = info[j];
                            if (n != in.lineNo) continue block0;
                            if (in.position == o && nowSrc.length() == o + strLen) {
                                res.add(in.lineNo, o + strLen);
                                continue block0;
                            }
                            int ooo = oo + 1;
                            while ((ooo = nowSrc.indexOf(beforeIndexOf, ooo)) != -1) {
                                int op = ooo + bwLen;
                                if (in.position == op + addOff && nowSrc.length == op + addOff + strLen) {
                                    res.add(in.lineNo, op + addOff + strLen);
                                    continue block0;
                                }
                                ++ooo;
                            }
                            ++j;
                        }
                    }
                } else {
                    block4: for (int i = 0; i < len; ++i) {
                        NGramInfo in;
                        int j = NGram.searchNGramInfo(info, and.position(i));
                        if (j == -1) continue;
                        int lenJ = info.length;
                        int n = and.position(i);
                        int o = and.offset(i) + addOff;
                        MStringIndexKey nowSrc = src[n];
                        if (beforeIndexOf == null) {
                            while (j < lenJ) {
                                in = info[j];
                                if (n != in.lineNo) continue block4;
                                if (in.position == o && nowSrc.length() == o + strLen && NGram.nextEq(src, n, value, o) == o) {
                                    res.add(in.lineNo, o + strLen);
                                    continue block4;
                                }
                                ++j;
                            }
                            continue;
                        }
                        int oo = and.offset(i) - bwLen;
                        while (j < lenJ) {
                            in = info[j];
                            if (n != in.lineNo) continue block4;
                            if (in.position == o && nowSrc.length() == o + strLen && NGram.nextEq(src, n, value, o) == o) {
                                res.add(in.lineNo, o + strLen);
                                continue block4;
                            }
                            int ooo = oo + 1;
                            while ((ooo = nowSrc.indexOf(beforeIndexOf, ooo)) != -1) {
                                int op = ooo + bwLen;
                                if (in.position == op + addOff && nowSrc.length == op + addOff + strLen && NGram.nextEq(src, n, value, op + addOff) == op + addOff) {
                                    res.add(in.lineNo, op + addOff + strLen);
                                    continue block4;
                                }
                                ++ooo;
                            }
                            ++j;
                        }
                    }
                }
            } else {
                res = new NGramLineList(false, index.srcLength);
                int len = info.length;
                if (strLen == 1) {
                    block8: for (int i = 0; i < len; ++i) {
                        NGramInfo in = info[i];
                        int j = in.lineNo;
                        if (in.position == addOff) {
                            if (src[in.lineNo].length() != strLen + addOff) continue;
                            res.add(in.lineNo, strLen + addOff);
                            ++i;
                            while (i < len) {
                                if (info[i].lineNo != j) {
                                    --i;
                                    continue block8;
                                }
                                ++i;
                            }
                            continue;
                        }
                        ++i;
                        while (i < len) {
                            if (info[i].lineNo != j) {
                                --i;
                                continue block8;
                            }
                            ++i;
                        }
                    }
                } else {
                    block11: for (int i = 0; i < len; ++i) {
                        NGramInfo in = info[i];
                        int j = in.lineNo;
                        if (in.position == addOff) {
                            if (src[in.lineNo].length() != strLen + addOff || NGram.nextEq(src, in.lineNo, value, addOff) != addOff) continue;
                            res.add(in.lineNo, strLen + addOff);
                            ++i;
                            while (i < len) {
                                if (info[i].lineNo != j) {
                                    --i;
                                    continue block11;
                                }
                                ++i;
                            }
                            continue;
                        }
                        ++i;
                        while (i < len) {
                            if (info[i].lineNo != j) {
                                --i;
                                continue block11;
                            }
                            ++i;
                        }
                    }
                }
            }
        } else if (and != null) {
            res = and.newList();
            int len = and.length();
            if (strLen == 1) {
                block14: for (int i = 0; i < len; ++i) {
                    NGramInfo in;
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i) + addOff;
                    if (beforeIndexOf == null) {
                        while (j < lenJ) {
                            in = info[j];
                            if (n != in.lineNo) continue block14;
                            if (in.position == o) {
                                res.add(in.lineNo, o + strLen);
                                continue block14;
                            }
                            ++j;
                        }
                        continue;
                    }
                    int oo = and.offset(i) - bwLen;
                    MStringIndexKey nowSrc = src[n];
                    while (j < lenJ) {
                        in = info[j];
                        if (n != in.lineNo) continue block14;
                        if (in.position == o) {
                            res.add(in.lineNo, o + strLen);
                            continue block14;
                        }
                        int ooo = oo + 1;
                        while ((ooo = nowSrc.indexOf(beforeIndexOf, ooo)) != -1) {
                            int op = ooo + bwLen;
                            if (in.position == op + addOff) {
                                res.add(in.lineNo, op + addOff + strLen);
                                continue block14;
                            }
                            ++ooo;
                        }
                        ++j;
                    }
                }
            } else {
                block18: for (int i = 0; i < len; ++i) {
                    NGramInfo in;
                    int j = NGram.searchNGramInfo(info, and.position(i));
                    if (j == -1) continue;
                    int lenJ = info.length;
                    int n = and.position(i);
                    int o = and.offset(i) + addOff;
                    if (beforeIndexOf == null) {
                        while (j < lenJ) {
                            in = info[j];
                            if (n != in.lineNo) continue block18;
                            if (in.position == o && NGram.nextEq(src, n, value, o) == o) {
                                res.add(in.lineNo, o + strLen);
                                continue block18;
                            }
                            ++j;
                        }
                        continue;
                    }
                    int oo = and.offset(i) - bwLen;
                    MStringIndexKey nowSrc = src[n];
                    while (j < lenJ) {
                        in = info[j];
                        if (n != in.lineNo) continue block18;
                        if (in.position == o && NGram.nextEq(src, n, value, o) == o) {
                            res.add(in.lineNo, o + strLen);
                            continue block18;
                        }
                        int ooo = oo + 1;
                        while ((ooo = nowSrc.indexOf(beforeIndexOf, ooo)) != -1) {
                            int op = ooo + bwLen;
                            if (in.position == op + addOff && NGram.nextEq(src, n, value, op + addOff) == op + addOff) {
                                res.add(in.lineNo, op + addOff + strLen);
                                continue block18;
                            }
                            ++ooo;
                        }
                        ++j;
                    }
                }
            }
        } else {
            res = new NGramLineList(false, index.srcLength);
            int len = info.length;
            if (strLen == 1) {
                block22: for (int i = 0; i < len; ++i) {
                    int j = info[i].lineNo;
                    if (info[i].position == addOff) {
                        res.add(info[i].lineNo, strLen + addOff);
                        ++i;
                        while (i < len) {
                            if (info[i].lineNo != j) {
                                --i;
                                continue block22;
                            }
                            ++i;
                        }
                        continue;
                    }
                    ++i;
                    while (i < len) {
                        if (info[i].lineNo != j) {
                            --i;
                            continue block22;
                        }
                        ++i;
                    }
                }
            } else {
                block25: for (int i = 0; i < len; ++i) {
                    int j = info[i].lineNo;
                    if (info[i].position == addOff) {
                        if (NGram.nextEq(src, info[i].lineNo, value, addOff) != addOff) continue;
                        res.add(info[i].lineNo, strLen + addOff);
                        ++i;
                        while (i < len) {
                            if (info[i].lineNo != j) {
                                --i;
                                continue block25;
                            }
                            ++i;
                        }
                        continue;
                    }
                    ++i;
                    while (i < len) {
                        if (info[i].lineNo != j) {
                            --i;
                            continue block25;
                        }
                        ++i;
                    }
                }
            }
        }
        return res;
    }

    private static final class NGramIndex {
        NGramElement[] list;
        MStringIndexKey[] src;
        int srcLength;
        int allLength;

        private NGramIndex() {
        }
    }

    private static final class NGramElement
    implements Comparable<NGramElement> {
        int element;
        NGramInfo[] info;

        private NGramElement() {
        }

        @Override
        public int compareTo(NGramElement n) {
            return this.element - n.element;
        }
    }

    private static final class NGramWork {
        int element;
        ObjectList<NGramInfo> info = new ObjectList();

        private NGramWork() {
        }
    }

    private static final class NGramInfo
    implements Comparable<NGramInfo> {
        int position;
        boolean end;
        int lineNo;

        public NGramInfo(int p, boolean e, int l) {
            this.position = p;
            this.end = e;
            this.lineNo = l;
        }

        @Override
        public int compareTo(NGramInfo n) {
            if (this.lineNo == n.lineNo) {
                return this.position - n.position;
            }
            return this.lineNo - n.lineNo;
        }
    }
}

