/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.maachang.mimdb.core.util.Stack;
import org.maachang.mimdb.core.util.StringUtils;

public final class MimdbUtils {
    private static final ThreadLocal<SoftReference<Object[]>> sqlDateFormatLocal = new ThreadLocal();
    private static final ThreadLocal<SoftReference<Object[]>> sqlTimeFormatLocal = new ThreadLocal();
    private static final ThreadLocal<SoftReference<Object[]>> sqlTimestampFormatLocal = new ThreadLocal();

    private MimdbUtils() {
    }

    private static final Object[] getDateFormat() {
        Object[] ret;
        SoftReference<Object[]> o = sqlDateFormatLocal.get();
        if (o == null || (ret = o.get()) == null) {
            SimpleDateFormat[] fmt = new SimpleDateFormat[2];
            int[] len = new int[2];
            try {
                fmt[0] = new SimpleDateFormat("yyyy-MM-dd");
                fmt[1] = new SimpleDateFormat("yyyy/MM/dd");
                len[0] = 10;
                len[1] = 10;
            }
            catch (Exception e) {
                fmt = null;
                len = null;
            }
            ret = new Object[]{fmt, len};
            sqlDateFormatLocal.set(new SoftReference<Object[]>(ret));
        }
        return ret;
    }

    private static final Object[] getTimeFormat() {
        Object[] ret;
        SoftReference<Object[]> o = sqlTimeFormatLocal.get();
        if (o == null || (ret = o.get()) == null) {
            SimpleDateFormat[] fmt = new SimpleDateFormat[2];
            int[] len = new int[2];
            try {
                fmt[0] = new SimpleDateFormat("hh:mm:ss");
                fmt[1] = new SimpleDateFormat("hh:mm");
                len[0] = 8;
                len[1] = 5;
            }
            catch (Exception e) {
                fmt = null;
                len = null;
            }
            ret = new Object[]{fmt, len};
            sqlTimeFormatLocal.set(new SoftReference<Object[]>(ret));
        }
        return ret;
    }

    private static final Object[] getTimestampFormat() {
        Object[] ret;
        SoftReference<Object[]> o = sqlTimestampFormatLocal.get();
        if (o == null || (ret = o.get()) == null) {
            SimpleDateFormat[] fmt = new SimpleDateFormat[4];
            int[] len = new int[4];
            try {
                fmt[0] = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                fmt[1] = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                fmt[2] = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
                fmt[3] = new SimpleDateFormat("yyyy/MM/dd hh:mm");
                len[0] = 19;
                len[1] = 16;
                len[2] = 19;
                len[3] = 16;
            }
            catch (Exception e) {
                fmt = null;
                len = null;
            }
            ret = new Object[]{fmt, len};
            sqlTimestampFormatLocal.set(new SoftReference<Object[]>(ret));
        }
        return ret;
    }

    public static final boolean isNumeric(String num) {
        if (num == null || (num = num.trim()).length() <= 0) {
            return false;
        }
        int start = 0;
        if (num.charAt(0) == '-') {
            start = 1;
        }
        boolean dt = false;
        int len = num.length();
        if (start < len) {
            for (int i = start; i < len; ++i) {
                char c = num.charAt(i);
                if (c == '.') {
                    if (dt) {
                        return false;
                    }
                    dt = true;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static final Boolean convertBool(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof String) {
            String s = ((String)o).trim().toLowerCase();
            if ("true".equals(s) || "t".equals(s)) {
                return true;
            }
            if ("false".equals(s) || "f".equals(s)) {
                return false;
            }
        }
        throw new IOException("BOOL\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Integer convertInt(Object o) throws Exception {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String && MimdbUtils.isNumeric(s = ((String)o).trim())) {
            return StringUtils.parseInt(s);
        }
        throw new IOException("Int\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Long convertLong(Object o) throws Exception {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String && MimdbUtils.isNumeric(s = ((String)o).trim())) {
            return StringUtils.parseLong(s.trim());
        }
        throw new IOException("Long\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Double convertDouble(Object o) throws Exception {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String && MimdbUtils.isNumeric(s = ((String)o).trim())) {
            return StringUtils.parseDouble(s.trim());
        }
        throw new IOException("Double\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final String convertString(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    private static final Date _cDate(long d) {
        return MimdbUtils._cDate(new java.util.Date(d));
    }

    private static final Date _cDate(java.util.Date n) {
        return new Date(n.getYear(), n.getMonth(), n.getDate());
    }

    public static final Date convertSqlDate(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof java.util.Date) {
            return MimdbUtils._cDate((java.util.Date)o);
        }
        if (o instanceof Long) {
            return MimdbUtils._cDate((Long)o);
        }
        if (o instanceof Number) {
            return MimdbUtils._cDate(((Number)o).longValue());
        }
        if (o instanceof String) {
            String s = ((String)o).trim();
            if (MimdbUtils.isNumeric(s)) {
                return MimdbUtils._cDate(StringUtils.parseLong(s));
            }
            if (s.length() == 10) {
                Object[] n = MimdbUtils.getDateFormat();
                SimpleDateFormat[] fmt = (SimpleDateFormat[])n[0];
                int[] fmtLen = (int[])n[1];
                int len = fmt.length;
                for (int i = 0; i < len; ++i) {
                    if (fmtLen[i] != s.length()) continue;
                    try {
                        java.util.Date d = fmt[i].parse(s);
                        return MimdbUtils._cDate(d.getTime());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IOException("java.sql.Date\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    private static final Time _cTime(long d) {
        return MimdbUtils._cTime(new java.util.Date(d));
    }

    private static final Time _cTime(java.util.Date n) {
        return new Time(n.getHours(), n.getMinutes(), n.getSeconds());
    }

    public static final Time convertSqlTime(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof java.util.Date) {
            return MimdbUtils._cTime((java.util.Date)o);
        }
        if (o instanceof Long) {
            return MimdbUtils._cTime((Long)o);
        }
        if (o instanceof Number) {
            return MimdbUtils._cTime(((Number)o).longValue());
        }
        if (o instanceof String) {
            String s = ((String)o).trim();
            int sLen = s.length();
            if (MimdbUtils.isNumeric(s)) {
                return MimdbUtils._cTime(StringUtils.parseLong(s));
            }
            if (sLen == 8 || sLen == 5) {
                Object[] n = MimdbUtils.getTimeFormat();
                SimpleDateFormat[] fmt = (SimpleDateFormat[])n[0];
                int[] fmtLen = (int[])n[1];
                int len = fmt.length;
                for (int i = 0; i < len; ++i) {
                    if (fmtLen[i] != s.length()) continue;
                    try {
                        java.util.Date d = fmt[i].parse(s);
                        return MimdbUtils._cTime(d.getTime());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IOException("java.sql.Time\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Timestamp convertSqlTimestamp(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof java.util.Date) {
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            return new Timestamp(((java.util.Date)o).getTime());
        }
        if (o instanceof Long) {
            return new Timestamp((Long)o);
        }
        if (o instanceof Number) {
            return new Timestamp(((Number)o).longValue());
        }
        if (o instanceof String) {
            String s = ((String)o).trim();
            int sLen = s.length();
            if (MimdbUtils.isNumeric(s)) {
                return new Timestamp(StringUtils.parseLong(s));
            }
            if (sLen == 19 || sLen == 16) {
                Object[] n = MimdbUtils.getTimestampFormat();
                SimpleDateFormat[] fmt = (SimpleDateFormat[])n[0];
                int[] fmtLen = (int[])n[1];
                int len = fmt.length;
                for (int i = 0; i < len; ++i) {
                    if (fmtLen[i] != s.length()) continue;
                    try {
                        java.util.Date d = fmt[i].parse(s);
                        return new Timestamp(d.getTime());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IOException("java.sql.Timestamp\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final java.util.Date convertDate(Object o) throws Exception {
        block16: {
            int sLen;
            int len;
            int[] fmtLen;
            SimpleDateFormat[] fmt;
            java.util.Date d;
            String s;
            block18: {
                block17: {
                    if (o == null) {
                        return null;
                    }
                    if (o instanceof java.util.Date) {
                        return (java.util.Date)o;
                    }
                    if (o instanceof Long) {
                        return new java.util.Date((Long)o);
                    }
                    if (o instanceof Number) {
                        return new java.util.Date(((Number)o).longValue());
                    }
                    if (!(o instanceof String)) break block16;
                    s = ((String)o).trim();
                    if (MimdbUtils.isNumeric(s)) {
                        return new java.util.Date(StringUtils.parseLong(s));
                    }
                    d = null;
                    fmt = null;
                    fmtLen = null;
                    len = -1;
                    sLen = s.length();
                    if (sLen != 19 && sLen != 16) break block17;
                    Object[] n = MimdbUtils.getTimestampFormat();
                    fmt = (SimpleDateFormat[])n[0];
                    fmtLen = (int[])n[1];
                    len = fmt.length;
                    if (fmt == null) break block16;
                    for (int i = 0; i < len; ++i) {
                        if (fmtLen[i] != s.length()) continue;
                        try {
                            d = fmt[i].parse(s);
                            return new Timestamp(d.getTime());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    break block16;
                }
                if (sLen != 10) break block18;
                Object[] n = MimdbUtils.getDateFormat();
                fmt = (SimpleDateFormat[])n[0];
                fmtLen = (int[])n[1];
                len = fmt.length;
                if (fmt == null) break block16;
                for (int i = 0; i < len; ++i) {
                    if (fmtLen[i] != s.length()) continue;
                    try {
                        d = fmt[i].parse(s);
                        return MimdbUtils._cDate(d.getTime());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                break block16;
            }
            if (sLen == 8 || sLen == 5) {
                Object[] n = MimdbUtils.getTimeFormat();
                fmt = (SimpleDateFormat[])n[0];
                fmtLen = (int[])n[1];
                len = fmt.length;
                if (fmt != null) {
                    for (int i = 0; i < len; ++i) {
                        if (fmtLen[i] != s.length()) continue;
                        try {
                            d = fmt[i].parse(s);
                            return MimdbUtils._cTime(d.getTime());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        throw new IOException("java.util.Date\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final int searchInt(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchLong(long[] a, long key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchDouble(double[] a, double key) {
        int low = 0;
        int high = a.length - 1;
        long keyBits = Double.doubleToLongBits(key);
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == keyBits ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchObject(Object[] a, Object key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = ((Comparable)a[mid]).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchIntBS(boolean big, int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid] > key) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid] > key) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    public static final int searchLongBS(boolean big, long[] a, long key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid] > key) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid] > key) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    public static final int searchDoubleBS(boolean big, double[] a, double key) {
        int low = 0;
        int high = a.length - 1;
        long keyBits = Double.doubleToLongBits(key);
        int mid = 0;
        while (low <= high) {
            int cmp;
            mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == keyBits ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid] > key) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid] > key) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    public static final int searchObjectBS(boolean big, Object[] a, Object key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int cmp = ((Comparable)a[mid]).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (((Comparable)a[mid]).compareTo(key) > 0) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (((Comparable)a[mid]).compareTo(key) > 0) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getList(String name, String charset) throws Exception {
        if (charset == null || (charset = charset.trim()).length() <= 0) {
            charset = "UTF8";
        }
        ArrayList<String> ret = null;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), charset));
        try {
            String n;
            ret = new ArrayList<String>();
            while ((n = r.readLine()) != null) {
                if ((n = n.trim()).length() <= 0) continue;
                ret.add(n);
            }
            r.close();
            r = null;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception e) {}
            }
        }
        return ret;
    }

    public static final String indentCote(String string, int off, boolean dc) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        char cote = '\"';
        if (!dc) {
            cote = '\'';
        }
        if (string.indexOf(cote) != -1) {
            int yenCount = 0;
            int indNo = off;
            int len = string.length();
            StringBuilder buf = new StringBuilder();
            Stack<Integer> stack = new Stack<Integer>();
            for (int i = 0; i < len; ++i) {
                char c = string.charAt(i);
                if (c == cote) {
                    int yenLen;
                    boolean decFlag = false;
                    if (stack.size() > 0 && (Integer)stack.peek() >= yenCount) {
                        if ((Integer)stack.peek() > yenCount) {
                            stack.pop();
                            decFlag = false;
                            if (--indNo < 0) {
                                indNo = 0;
                            }
                        } else {
                            stack.pop();
                            decFlag = true;
                        }
                    } else {
                        stack.push(yenCount);
                        ++indNo;
                    }
                    yenLen = off < 0 ? ((yenLen = yenCount + off) > 0 ? (2 << yenLen - 1) - 1 : 0) : (2 << indNo - 1) - 1;
                    for (int j = 0; j < yenLen; ++j) {
                        buf.append("\\");
                    }
                    buf.append(cote);
                    yenCount = 0;
                    if (!decFlag) continue;
                    --indNo;
                    continue;
                }
                if (c == '\\') {
                    ++yenCount;
                    continue;
                }
                if (yenCount > 0) {
                    for (int j = 0; j < yenCount; ++j) {
                        buf.append("\\");
                    }
                    yenCount = 0;
                }
                buf.append(c);
            }
            return buf.toString();
        }
        return string;
    }

    public static final String upIndentDoubleCote(String string) {
        return MimdbUtils.indentCote(string, 0, true);
    }

    public static final String upIndentSingleCote(String string) {
        return MimdbUtils.indentCote(string, 0, false);
    }

    public static final String downIndentDoubleCote(String string) {
        boolean exec = false;
        int len = string.length();
        char b = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                if (b != '\\') break;
                exec = true;
                break;
            }
            b = c;
        }
        if (exec) {
            return MimdbUtils.indentCote(string, -1, true);
        }
        return string;
    }

    public static final String downIndentSingleCote(String string) {
        boolean exec = false;
        int len = string.length();
        char b = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                if (b != '\\') break;
                exec = true;
                break;
            }
            b = c;
        }
        if (exec) {
            return MimdbUtils.indentCote(string, -1, false);
        }
        return string;
    }

    public static final boolean isFile(String name) {
        File file = new File(name);
        return file.exists() ? (!file.isDirectory() ? file.canRead() : false) : false;
    }

    public static final String getFullPath(String name) throws Exception {
        String s = new File(name).getCanonicalPath();
        if (s.indexOf("\\") != -1) {
            s = StringUtils.changeString(s, "\\", "/");
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getFile(String name) throws Exception {
        InputStream buf = null;
        ByteArrayOutputStream bo = null;
        byte[] b = new byte[1024];
        try {
            bo = new ByteArrayOutputStream();
            buf = new BufferedInputStream(new FileInputStream(name));
            while (true) {
                int len;
                if ((len = buf.read(b)) <= 0) {
                    if (len > -1) continue;
                    break;
                }
                bo.write(b, 0, len);
            }
            buf.close();
            buf = null;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception t) {}
            }
            buf = null;
        }
        return bo.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setFile(String name, byte[] value) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(name));
        try {
            ((OutputStream)out).write(value);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            out = null;
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final int bitMask(int x) {
        if (x <= 0) {
            return 0;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return 1 << (x & 0xFFFF) + (x >> 16 & 0xFFFF) - 1;
    }

    protected static final int nlzs(int x) {
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        return (x & 0xFFFF) + (x >> 16 & 0xFFFF);
    }

    public static final String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

