/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.AbstractNumberIndex;
import org.maachang.mimdb.core.impl.HashIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.NumberList;
import org.maachang.mimdb.core.util.ObjectList;

public class MFloatIndex
extends AbstractNumberIndex<Double> {
    private ObjectList<MFloatColumnWorkChild> work = null;
    private int workLength = -1;
    private double[] indexList = null;
    private boolean useHashFlag = false;

    private MFloatIndex() {
    }

    public MFloatIndex(long id, String n, boolean h) {
        this(id, n, 0, h);
    }

    public MFloatIndex(long id, String n, int size, boolean h) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
        this.useHashFlag = h;
    }

    @Override
    public void clear() {
        super.clear();
        this.work = null;
        this.indexList = null;
    }

    public void add(Double value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        if (value == null) {
            this.work.add(new MFloatColumnWorkChild(value, -1, true));
        } else {
            this.work.add(new MFloatColumnWorkChild(value, lineNo, false));
        }
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertDouble(value), lineNo);
    }

    @Override
    public void createIndex() throws Exception {
        Object n;
        MFloatColumnWorkChild k;
        int len;
        if (this.work == null) {
            this.clear();
            return;
        }
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
        NumberList nullList = new NumberList(32);
        int _allLength = len = this.work.size();
        NNObjectKeyValue<Double, MFloatColumnIndexChild> map = new NNObjectKeyValue<Double, MFloatColumnIndexChild>(len * 2);
        for (int i = 0; i < len; ++i) {
            k = this.work.get(i);
            if (k.nullFlag) {
                nullList.add(k.lineNo);
                continue;
            }
            n = (MFloatColumnIndexChild)map.get(k.value);
            if (n != null) {
                ((MFloatColumnIndexChild)n).lineNo.add(k.lineNo);
                continue;
            }
            map.put(k.value, new MFloatColumnIndexChild(k.value, k.lineNo));
        }
        k = null;
        n = null;
        this.work = null;
        len = map.size();
        if (len > 0) {
            Object[] lst = new MFloatColumnIndexChild[len];
            NNObjectKeyValue it = map.reset();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt++] = (MFloatColumnIndexChild)map.get((Double)it.next());
            }
            it = null;
            map = null;
            Arrays.sort(lst);
            double[] _indexList = new double[len];
            int[][] _lineList = new int[len][];
            HashIndex _hashIndex = null;
            int[] _sortNoList = new int[_allLength];
            Arrays.fill(_sortNoList, -1);
            for (int i = 0; i < len; ++i) {
                n = lst[i];
                _indexList[i] = ((MFloatColumnIndexChild)n).value;
                int[] nlst = ((MFloatColumnIndexChild)n).getLineNo();
                _lineList[i] = nlst;
                int lenJ = nlst.length;
                for (int j = 0; j < lenJ; ++j) {
                    _sortNoList[nlst[j]] = i;
                }
            }
            lst = null;
            if (this.useHashFlag) {
                _hashIndex = new HashIndex(_indexList);
            }
            this.indexList = _indexList;
            this.lineList = _lineList;
            this.hashIndex = _hashIndex;
            this.sortNoList = _sortNoList;
        }
        if ((len = nullList.size()) > 0) {
            int[] _nullLineList = new int[len];
            for (int i = 0; i < len; ++i) {
                _nullLineList[i] = nullList.get(i);
            }
            nullList = null;
            this.nullLineList = _nullLineList;
        }
        this.allLength = _allLength;
        this.indexFlag = true;
    }

    @Override
    public int getIndexSize() {
        return this.indexList.length;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getDBType() {
        return 6;
    }

    @Override
    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7 || info.getType() == 9) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Double> lst = new ArrayList<Double>(1);
                lst.add(MimdbUtils.convertDouble(o));
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Double> lst = new ArrayList<Double>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(MimdbUtils.convertDouble(n.get(i)));
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertDouble(info.getValue()));
        return info;
    }

    @Override
    protected final int _numberBinarySearch(Object target) {
        if (this.indexList == null) {
            return -1;
        }
        if (this.useHashFlag) {
            return this.hashIndex.eq((Double)target);
        }
        return MimdbUtils.searchDouble(this.indexList, (Double)target);
    }

    @Override
    public boolean isNGram() {
        return false;
    }

    @Override
    protected int _numberBinarySearchBM(boolean big, boolean eq, Object target) {
        if (this.indexList == null) {
            return -1;
        }
        double t = (Double)target;
        int p = MimdbUtils.searchDoubleBS(big, this.indexList, t);
        if (eq && this.indexList[p] == t) {
            return p;
        }
        if (big) {
            if (this.indexList.length <= p + 1) {
                return -1;
            }
            return p + 1;
        }
        if (p <= 0) {
            return -1;
        }
        return p - 1;
    }

    private static final class MFloatColumnIndexChild
    implements Comparable<MFloatColumnIndexChild> {
        double value;
        NumberList lineNo = new NumberList();

        public MFloatColumnIndexChild(double v, int n) {
            this.value = v;
            this.lineNo.add(n);
        }

        @Override
        public int compareTo(MFloatColumnIndexChild n) {
            return (int)(this.value - n.value);
        }

        public int[] getLineNo() {
            int len = this.lineNo.size();
            int[] ret = new int[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = this.lineNo.get(i);
            }
            return ret;
        }
    }

    private static final class MFloatColumnWorkChild {
        double value;
        int lineNo;
        boolean nullFlag;

        public MFloatColumnWorkChild(double v, int n, boolean nf) {
            this.value = v;
            this.lineNo = n;
            this.nullFlag = nf;
        }
    }
}

