/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.impl.AbstractLargeFlags;
import org.maachang.mimdb.core.impl.Flags;
import org.maachang.mimdb.core.util.NumberKeyValue;

public final class LargeFlagsBase
extends AbstractLargeFlags {
    public LargeFlagsBase() {
    }

    public LargeFlagsBase(int len) {
        this.create(len);
    }

    public LargeFlagsBase(Flags f) {
        this.create(f);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public final void create(int len) {
        this.blockLength = (len >> 10) + ((len & 0x3FF) == 0 ? 0 : 1);
        this.max = len;
        this.list = new NumberKeyValue(4);
    }

    public final void create(Flags f) {
        AbstractLargeFlags lf = (AbstractLargeFlags)f;
        NumberKeyValue<int[]> ff = lf.list;
        int b = lf.blockLength;
        int m = lf.max;
        f.destroy();
        this.list = ff;
        this.blockLength = b;
        this.max = m;
    }

    @Override
    public final boolean isAnd() {
        return false;
    }

    @Override
    public final void add(int no) {
        int n = no >> 10;
        int nn = no & 0x3FF;
        int[] ff = (int[])this.list.get(n);
        if (ff == null) {
            ff = new int[32];
            this.list.put(n, ff);
        }
        int n2 = nn >> 5;
        ff[n2] = ff[n2] | 1 << (nn & 0x1F);
    }

    @Override
    public final void addArray(int[] array) {
        int b = -1;
        int[] ff = null;
        for (int a : array) {
            int nn = a & 0x3FF;
            int n = a >> 10;
            if (b != n) {
                ff = (int[])this.list.get(n);
                if (ff == null) {
                    ff = new int[32];
                    this.list.put(n, ff);
                }
                b = n;
            }
            int n2 = nn >> 5;
            ff[n2] = ff[n2] | 1 << (nn & 0x1F);
        }
    }

    @Override
    public final void set(int no, int f) {
        int n = no >> 10;
        int nn = no & 0x3FF;
        int[] ff = (int[])this.list.get(n);
        if (ff == null) {
            ff = new int[32];
            this.list.put(n, ff);
        }
        ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
    }

    @Override
    public final void setArray(int[] array, int f) {
        int b = -1;
        int[] ff = null;
        for (int a : array) {
            int nn = a & 0x3FF;
            int n = a >> 10;
            if (b != n) {
                ff = (int[])this.list.get(n);
                if (ff == null) {
                    ff = new int[32];
                    this.list.put(n, ff);
                }
                b = n;
            }
            ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
        }
    }

    @Override
    public final void all() {
        int len = this.blockLength;
        for (int i = 0; i < len; ++i) {
            int[] ff = (int[])this.list.get(i);
            if (ff == null) {
                ff = new int[32];
                this.list.put(i, ff);
            }
            Arrays.fill(ff, -1);
        }
    }

    @Override
    public final void marge(Flags f) {
        if (f.max() != this.max) {
            throw new MimdbException("\u9577\u3055\u304c\u4e0d\u4e00\u81f4:" + f.max() + " " + this.max);
        }
        AbstractLargeFlags lf = (AbstractLargeFlags)f;
        NumberKeyValue<int[]> src = lf.list;
        src.reset();
        while (src.hasNext()) {
            int n = src.next();
            int[] bf = src.nextValue();
            int[] ff = (int[])this.list.get(n);
            if (ff == null) {
                ff = new int[32];
                this.list.put(n, ff);
            }
            for (int i = 0; i < 32; ++i) {
                int n2 = i;
                ff[n2] = ff[n2] | bf[i];
            }
        }
    }
}

