/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.ResultArray;
import org.maachang.mimdb.core.impl.Flags;
import org.maachang.mimdb.core.impl.LargeFlagsAnd;
import org.maachang.mimdb.core.impl.LargeFlagsBase;
import org.maachang.mimdb.core.impl.SmallFlagsAnd;
import org.maachang.mimdb.core.impl.SmallFlagsBase;

public final class FlagsMiddleSearch
implements MimdbMiddleSearch {
    protected long dbId = -1L;
    protected Flags noList = null;
    protected int max = -1;
    protected int useSize = -1;

    public FlagsMiddleSearch() {
    }

    public FlagsMiddleSearch(long id, int len) {
        this.create(id, len);
    }

    public final void create(long id, int len) {
        this.max = len;
        this.dbId = id;
        this.noList = len > 32768 ? new LargeFlagsBase(len) : new SmallFlagsBase(len);
    }

    public final void create(long id, Flags f) {
        this.useSize = -1;
        this.dbId = id;
        if (f.isAnd()) {
            this.noList = f;
            if (f.max() > 32768) {
                ((LargeFlagsAnd)f).create(f);
            } else {
                ((SmallFlagsAnd)f).create(f);
            }
        } else {
            this.noList = f.max() > 32768 ? new LargeFlagsAnd(f) : new SmallFlagsAnd(f);
        }
        this.max = this.noList.max();
    }

    @Override
    public final void clear() {
        this.dbId = -1L;
        this.noList = null;
        this.max = -1;
        this.useSize = -1;
    }

    @Override
    public final long getDbId() {
        return this.dbId;
    }

    @Override
    public final void add(int no) {
        this.noList.add(no);
    }

    @Override
    public final void addArray(int[] no) {
        this.noList.addArray(no);
    }

    @Override
    public final void off(int no) {
        this.noList.set(no, 0);
    }

    @Override
    public final void offArray(int[] no) {
        this.noList.setArray(no, 0);
    }

    @Override
    public final void all() {
        this.noList.all();
    }

    @Override
    public final void or(MimdbMiddleSearch search) {
        if (this.noList.isAnd()) {
            this.noList = this.noList.max() > 32768 ? new LargeFlagsBase(this.noList) : new SmallFlagsBase(this.noList);
        }
        this.noList.marge(((FlagsMiddleSearch)search).noList);
    }

    @Override
    public final void and(MimdbMiddleSearch search) {
        if (!this.noList.isAnd()) {
            this.noList = this.noList.max() > 32768 ? new LargeFlagsAnd(this.noList) : new SmallFlagsAnd(this.noList);
        }
        this.noList.marge(((FlagsMiddleSearch)search).noList);
    }

    @Override
    public final int getResultArray(ResultArray[] out) {
        return this.noList.getResultArray(out);
    }

    @Override
    public final int getResultArray(ResultArray[] out, int off) {
        return this.noList.getResultArray(out, off);
    }

    public void clearCache() {
        this.useSize = -1;
    }

    @Override
    public final int size() {
        if (this.useSize == -1) {
            this.useSize = this.noList.size();
        }
        return this.useSize;
    }

    @Override
    public final boolean isAnd() {
        return this.noList.isAnd();
    }

    public final String toString() {
        return (this.noList.isAnd() ? "and" : "or") + " size:" + this.size();
    }
}

