/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.io.OutputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbRawRow;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbRow;
import org.maachang.mimdb.core.MimdbSnappyRow;
import org.maachang.mimdb.core.PrimaryResultRowImpl;
import org.maachang.mimdb.core.impl.MBoolIndex;
import org.maachang.mimdb.core.impl.MDateIndex;
import org.maachang.mimdb.core.impl.MFloatIndex;
import org.maachang.mimdb.core.impl.MIntIndex;
import org.maachang.mimdb.core.impl.MLongIndex;
import org.maachang.mimdb.core.impl.MStringIndex;
import org.maachang.mimdb.core.impl.MTimeIndex;
import org.maachang.mimdb.core.impl.MTimestampIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.ObjectBinary;
import org.maachang.mimdb.core.util.ObjectKeySet;
import org.maachang.mimdb.core.util.ObjectList;

public class MimdbTable
implements BaseTable {
    protected long dbId = -1L;
    protected String name = null;
    protected MimdbRow[] mainTable = null;
    private ObjectList<Object[]> workTable = null;
    protected String[] columns = null;
    protected int primaryIndexKeyNo = -1;
    private int[] sqlColumnTypes = null;
    protected int[] columnTypes = null;
    protected NNObjectKeyValue<String, Integer> columnsMap = null;
    protected NNObjectKeyValue<String, MimdbIndex> keyMap = null;
    private int bufferLength = -1;
    protected int columnLength = -1;
    protected boolean compressFlag = false;
    protected int compressLength = 1;
    protected int allBinaryLength = 0;
    protected int allCompressLength = 0;

    private MimdbTable() {
    }

    public MimdbTable(long dbId, String name, int length, String[] columns, int[] columnTypes, String primaryIndexKey, String[] keyNames, String[] ngramKeys, String[] hashKeys, boolean compressFlag, int compressLength) throws Exception {
        this.init(dbId, name, length, columns, columnTypes, primaryIndexKey, keyNames, ngramKeys, hashKeys, compressFlag, compressLength);
    }

    public MimdbTable(long dbId, String name, int length, String primaryIndexKey, String[] keyNames, String[] ngramKeys, String[] hashKeys, boolean compressFlag, int compressLength, ResultSet rs) throws Exception {
        if (rs == null) {
            throw new MimdbException("\u5bfe\u8c61\u306eResultSet\u304cNULL");
        }
        this.init(dbId, name, length, primaryIndexKey, keyNames, ngramKeys, hashKeys, compressFlag, compressLength, rs.getMetaData());
        this.addAllByJDBC(rs);
    }

    public MimdbTable(long dbId, String name, int length, String primaryIndexKey, String[] keyNames, String[] ngramKeys, String[] hashKeys, boolean compressFlag, int compressLength, ResultSetMetaData meta) throws Exception {
        this.init(dbId, name, length, primaryIndexKey, keyNames, ngramKeys, hashKeys, compressFlag, compressLength, meta);
    }

    private final NNObjectKeyValue<String, MimdbIndex> createKeyMap(String[] keyNames, String[] ngramKeys, String[] hashKeys, NNObjectKeyValue<String, Integer> columnsMap, int[] columnTypes, int length) throws Exception {
        ObjectKeySet<String> hashIndexKeySet;
        int i;
        int len;
        ObjectKeySet<String> ngramKeySet;
        if (ngramKeys == null || ngramKeys.length <= 0) {
            ngramKeySet = null;
        } else {
            ngramKeySet = new ObjectKeySet<String>();
            len = ngramKeys.length;
            for (i = 0; i < len; ++i) {
                ngramKeys[i] = ngramKeys[i].trim();
                if (ngramKeys[i].length() <= 0) continue;
                ngramKeySet.add(ngramKeys[i].toLowerCase());
            }
            if (ngramKeySet.size() <= 0) {
                ngramKeySet = null;
            }
        }
        if (hashKeys == null || hashKeys.length <= 0) {
            hashIndexKeySet = null;
        } else {
            hashIndexKeySet = new ObjectKeySet<String>();
            len = hashKeys.length;
            for (i = 0; i < len; ++i) {
                hashKeys[i] = hashKeys[i].trim();
                if (hashKeys[i].length() <= 0) continue;
                hashIndexKeySet.add(hashKeys[i].toLowerCase());
            }
            if (hashIndexKeySet.size() <= 0) {
                hashIndexKeySet = null;
            }
        }
        int len2 = keyNames.length;
        NNObjectKeyValue<String, MimdbIndex> ret = new NNObjectKeyValue<String, MimdbIndex>(len2 * 2);
        block12: for (int i2 = 0; i2 < len2; ++i2) {
            if (keyNames[i2] == null || (keyNames[i2] = keyNames[i2].trim()).length() <= 0) {
                throw new MimdbException("\u30ad\u30fc\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093[" + (i2 + 1) + "]");
            }
            keyNames[i2] = keyNames[i2].toLowerCase();
            if (!columnsMap.containsKey(keyNames[i2])) {
                throw new MimdbException("\u30ad\u30fc\u540d[" + keyNames[i2] + "]\u306f\u30ab\u30e9\u30e0\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            boolean hashIndexFlag = hashIndexKeySet != null && hashIndexKeySet.contains(keyNames[i2]);
            switch (columnTypes[columnsMap.get(keyNames[i2])]) {
                case 1: {
                    ret.put(keyNames[i2], new MBoolIndex(this.dbId, keyNames[i2], length));
                    continue block12;
                }
                case 2: {
                    ret.put(keyNames[i2], new MIntIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                    continue block12;
                }
                case 3: {
                    ret.put(keyNames[i2], new MLongIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                    continue block12;
                }
                case 4: {
                    ret.put(keyNames[i2], new MFloatIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                    continue block12;
                }
                case 5: {
                    if (ngramKeySet != null && ngramKeySet.contains(keyNames[i2])) {
                        ret.put(keyNames[i2], new MStringIndex(this.dbId, keyNames[i2], length, true, hashIndexFlag));
                        continue block12;
                    }
                    ret.put(keyNames[i2], new MStringIndex(this.dbId, keyNames[i2], length, false, hashIndexFlag));
                    continue block12;
                }
                case 7: {
                    ret.put(keyNames[i2], new MDateIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                    continue block12;
                }
                case 8: {
                    ret.put(keyNames[i2], new MTimeIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                    continue block12;
                }
                case 6: {
                    ret.put(keyNames[i2], new MTimestampIndex(this.dbId, keyNames[i2], length, hashIndexFlag));
                }
            }
        }
        return ret;
    }

    private final void init(long dbId, String name, int length, String[] columns, int[] columnTypes, String primaryIndexKey, String[] keyNames, String[] ngramKeys, String[] hashKeys, boolean compressFlag, int compressLength) throws Exception {
        if (dbId < 0L) {
            throw new MimdbException("\u66f4\u65b0ID\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (columns == null || columnTypes == null || keyNames == null) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (columns.length != columnTypes.length) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u6761\u4ef6\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        int len = columns.length;
        int[] sqlColumnTypes = new int[len];
        NNObjectKeyValue<String, Integer> m = new NNObjectKeyValue<String, Integer>(len * 2);
        for (int i = 0; i < len; ++i) {
            if (columns[i] == null || (columns[i] = columns[i].trim()).length() <= 0) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u306f\u7121\u52b9\u304b\u3001\u5b58\u5728\u3057\u307e\u305b\u3093[" + (i + 1) + "]");
            }
            columns[i] = columns[i].toLowerCase();
            if (m.containsKey(columns[i])) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d[" + columns[i] + "]\u306f\u8907\u6570\u5b58\u5728\u3057\u307e\u3059");
            }
            switch (columnTypes[i]) {
                case 1: {
                    sqlColumnTypes[i] = 16;
                    break;
                }
                case 2: {
                    sqlColumnTypes[i] = 4;
                    break;
                }
                case 3: {
                    sqlColumnTypes[i] = -5;
                    break;
                }
                case 4: {
                    sqlColumnTypes[i] = 6;
                    break;
                }
                case 5: {
                    sqlColumnTypes[i] = 12;
                    break;
                }
                case 7: {
                    sqlColumnTypes[i] = 91;
                    break;
                }
                case 8: {
                    sqlColumnTypes[i] = 92;
                    break;
                }
                case 6: {
                    sqlColumnTypes[i] = 93;
                    break;
                }
                default: {
                    throw new MimdbException("\u5bfe\u8c61\u30ab\u30e9\u30e0[" + columns[i] + "]\u306e\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093[" + columnTypes[i] + "]");
                }
            }
            m.put(columns[i], i);
        }
        NNObjectKeyValue<String, MimdbIndex> k = this.createKeyMap(keyNames, ngramKeys, hashKeys, m, columnTypes, length);
        int primaryIndexKeyNo = -1;
        if (primaryIndexKey != null && (primaryIndexKey = primaryIndexKey.trim()).length() > 0) {
            primaryIndexKeyNo = m.containsKey(primaryIndexKey = primaryIndexKey.toLowerCase()) ? m.get(primaryIndexKey) : -1;
        }
        this.mainTable = null;
        this.workTable = new ObjectList(length);
        this.columns = columns;
        this.primaryIndexKeyNo = primaryIndexKeyNo;
        this.columnTypes = columnTypes;
        this.sqlColumnTypes = sqlColumnTypes;
        this.columnsMap = m;
        this.keyMap = k;
        this.dbId = dbId;
        this.name = name;
        this.bufferLength = length;
        this.columnLength = columns.length;
        this.compressFlag = compressFlag;
        this.compressLength = compressFlag ? MimdbTable.compressLength(compressLength) : 1;
    }

    private final void init(long dbId, String name, int length, String primaryIndexKey, String[] keyNames, String[] ngramKeys, String[] hashKeys, boolean compressFlag, int compressLength, ResultSetMetaData meta) throws Exception {
        if (dbId < 0L) {
            throw new MimdbException("\u66f4\u65b0ID\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (meta == null || keyNames == null) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = meta.getColumnCount();
        String[] columns = new String[len];
        int[] columnTypes = new int[len];
        int[] sqlColumnTypes = new int[len];
        NNObjectKeyValue<String, Integer> m = new NNObjectKeyValue<String, Integer>(len * 2);
        for (int i = 0; i < len; ++i) {
            columns[i] = meta.getColumnName(i).trim().toLowerCase();
            sqlColumnTypes[i] = meta.getColumnType(i);
            switch (sqlColumnTypes[i]) {
                case -7: 
                case -6: 
                case 16: {
                    columnTypes[i] = 1;
                    break;
                }
                case 4: 
                case 5: {
                    columnTypes[i] = 2;
                    break;
                }
                case -5: {
                    columnTypes[i] = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    columnTypes[i] = 4;
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 70: {
                    columnTypes[i] = 5;
                    break;
                }
                case 91: {
                    columnTypes[i] = 7;
                    break;
                }
                case 92: {
                    columnTypes[i] = 8;
                    break;
                }
                case 93: {
                    columnTypes[i] = 6;
                    break;
                }
                default: {
                    throw new MimdbException("\u5bfe\u8c61\u30ab\u30e9\u30e0[" + columns[i] + "]\u306e\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093[" + columnTypes[i] + "]");
                }
            }
            m.put(columns[i], i);
        }
        NNObjectKeyValue<String, MimdbIndex> k = this.createKeyMap(keyNames, ngramKeys, hashKeys, m, columnTypes, length);
        int primaryIndexKeyNo = -1;
        if (primaryIndexKey != null && (primaryIndexKey = primaryIndexKey.trim()).length() > 0) {
            primaryIndexKeyNo = m.containsKey(primaryIndexKey = primaryIndexKey.toLowerCase()) ? m.get(primaryIndexKey) : -1;
        }
        this.mainTable = null;
        this.workTable = new ObjectList(length);
        this.columns = columns;
        this.primaryIndexKeyNo = primaryIndexKeyNo;
        this.columnTypes = columnTypes;
        this.sqlColumnTypes = sqlColumnTypes;
        this.columnsMap = m;
        this.keyMap = k;
        this.dbId = dbId;
        this.name = name;
        this.bufferLength = length;
        this.columnLength = columns.length;
        this.compressFlag = compressFlag;
        this.compressLength = compressFlag ? MimdbTable.compressLength(compressLength) : 1;
    }

    public void clear() {
        NNObjectKeyValue<String, MimdbIndex> it = this.keyMap.reset();
        while (it.hasNext()) {
            MimdbIndex index = this.keyMap.get(it.next());
            index.clear();
        }
        this.mainTable = null;
        this.workTable = new ObjectList(this.bufferLength);
        this.allBinaryLength = 0;
        this.allCompressLength = 0;
    }

    @Override
    public long getDbId() {
        return this.dbId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private final void indexToValue(Object o, int line, int no) throws Exception {
        switch (this.columnTypes[no]) {
            case 1: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MBoolIndex)index).add((Boolean)o, line);
                break;
            }
            case 2: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MIntIndex)index).add((Integer)o, line);
                break;
            }
            case 3: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MLongIndex)index).add((Long)o, line);
                break;
            }
            case 4: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MFloatIndex)index).add((Double)o, line);
                break;
            }
            case 5: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MStringIndex)index).add((String)o, line);
                break;
            }
            case 7: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MDateIndex)index).add((Date)o, line);
                break;
            }
            case 8: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MTimeIndex)index).add((Time)o, line);
                break;
            }
            case 6: {
                MimdbIndex index = this.keyMap.get(this.columns[no]);
                if (index == null) break;
                ((MTimestampIndex)index).add((Timestamp)o, line);
            }
        }
    }

    private static final Object getJDBCColumnData(int[] sqlColumnTypes, int no, ResultSet result) throws Exception {
        int columnNo = no + 1;
        if (result.getObject(columnNo) == null) {
            return null;
        }
        Object ret = null;
        switch (sqlColumnTypes[no]) {
            case -7: 
            case 16: {
                ret = result.getBoolean(columnNo);
                break;
            }
            case -6: {
                ret = result.getByte(columnNo);
                byte b = (Byte)ret;
                if (b == 0) {
                    ret = Boolean.FALSE;
                    break;
                }
                ret = Boolean.TRUE;
                break;
            }
            case 4: 
            case 5: {
                ret = result.getInt(columnNo);
                break;
            }
            case -5: {
                ret = result.getLong(columnNo);
                break;
            }
            case 6: 
            case 7: {
                ret = MimdbUtils.convertDouble(Float.valueOf(result.getFloat(columnNo)));
                break;
            }
            case 8: {
                ret = MimdbUtils.convertDouble(result.getDouble(columnNo));
                break;
            }
            case 2: 
            case 3: {
                ret = MimdbUtils.convertDouble(result.getBigDecimal(columnNo));
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                ret = result.getString(columnNo);
                break;
            }
            case 91: {
                ret = MimdbUtils.convertSqlDate(result.getDate(columnNo));
                break;
            }
            case 92: {
                ret = MimdbUtils.convertSqlTime(result.getTime(columnNo));
                break;
            }
            case 93: {
                ret = MimdbUtils.convertSqlTimestamp(result.getTimestamp(columnNo));
            }
        }
        return ret;
    }

    public void add(Object[] oneLine) throws Exception {
        if (oneLine == null) {
            throw new MimdbException("\u8ffd\u52a0\u5bfe\u8c61\u306e\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.workTable == null) {
            throw new MimdbException("\u3053\u306e\u30c6\u30fc\u30d6\u30eb\u306f\u30c7\u30fc\u30bf\u8ffd\u52a0\u304cFix\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int len = oneLine.length;
        block10: for (int i = 0; i < len; ++i) {
            switch (this.columnTypes[i]) {
                case 1: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertBool(oneLine[i]);
                    continue block10;
                }
                case 2: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertInt(oneLine[i]);
                    continue block10;
                }
                case 3: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertLong(oneLine[i]);
                    continue block10;
                }
                case 4: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertDouble(oneLine[i]);
                    continue block10;
                }
                case 5: {
                    oneLine[i] = MimdbUtils.convertString(oneLine[i]);
                    continue block10;
                }
                case 7: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertSqlDate(oneLine[i]);
                    continue block10;
                }
                case 8: {
                    if (oneLine[i] == null || ((String)oneLine[i]).length() == 0) {
                        oneLine[i] = null;
                        continue block10;
                    }
                    oneLine[i] = MimdbUtils.convertSqlTime(oneLine[i]);
                    continue block10;
                }
                case 6: {
                    oneLine[i] = oneLine[i] == null || ((String)oneLine[i]).length() == 0 ? null : MimdbUtils.convertSqlTimestamp(oneLine[i]);
                }
            }
        }
        this.workTable.add(oneLine);
    }

    public int addAll(List<Object[]> allLine) throws Exception {
        if (allLine == null) {
            throw new MimdbException("\u8ffd\u52a0\u5bfe\u8c61\u306e\u8907\u6570\u30c7\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.workTable == null) {
            throw new MimdbException("\u3053\u306e\u30c6\u30fc\u30d6\u30eb\u306f\u30c7\u30fc\u30bf\u8ffd\u52a0\u304cFix\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int len = allLine.size();
        for (int i = 0; i < len; ++i) {
            this.add(allLine.get(i));
        }
        return len;
    }

    public int addAllByJDBC(ResultSet result) throws Exception {
        if (result == null) {
            throw new MimdbException("\u8ffd\u52a0\u5bfe\u8c61\u306eResultSet\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.workTable == null) {
            throw new MimdbException("\u3053\u306e\u30c6\u30fc\u30d6\u30eb\u306f\u30c7\u30fc\u30bf\u8ffd\u52a0\u304cFix\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int ret = 0;
        int lineNo = this.workTable.size();
        int len = this.columnLength;
        while (result.next()) {
            Object[] oneLine = new Object[len];
            for (int i = 0; i < len; ++i) {
                Object o;
                oneLine[i] = o = MimdbTable.getJDBCColumnData(this.sqlColumnTypes, i, result);
            }
            this.workTable.add(oneLine);
            ++ret;
            ++lineNo;
        }
        return ret;
    }

    public void fix() throws Exception {
        int i;
        if (this.mainTable != null) {
            return;
        }
        if (this.workTable == null || this.workTable.size() == 0) {
            throw new MimdbException("Fix\u5bfe\u8c61\u306e\u30c7\u30fc\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int len = this.workTable.size();
        int allLen = 0;
        int compressLen = 0;
        Object[] list = new MimdbRow[len];
        if (this.compressFlag) {
            int rawLen;
            if (this.compressLength == 1) {
                for (i = 0; i < len; ++i) {
                    list[i] = new MimdbSnappyRow(this, i, this.workTable.get(i), (rawLen = MimdbSnappyRow.byteLength(this.columnTypes, this.workTable.get(i))) > 64, rawLen);
                    allLen += rawLen;
                    compressLen += ((MimdbRow)list[i]).compressLength();
                }
            } else {
                int i2;
                int parentLen = len / this.compressLength;
                int etcLen = len - this.compressLength * parentLen;
                Object[] cList = new Object[this.compressLength];
                for (i2 = 0; i2 < parentLen; ++i2) {
                    int j;
                    int b = i2 * this.compressLength;
                    int parentBinLen = 0;
                    for (j = 0; j < this.compressLength; ++j) {
                        cList[j] = this.workTable.get(b + j);
                        parentBinLen += MimdbSnappyRow.byteLength(this.columnTypes, (Object[])cList[j]);
                    }
                    MimdbSnappyRow parent = new MimdbSnappyRow(this, b, cList, parentBinLen);
                    allLen += parentBinLen;
                    compressLen += parent.compressLength();
                    list[b] = parent;
                    j = 1;
                    int k = b + 1;
                    while (j < this.compressLength) {
                        list[k] = new MimdbSnappyRow(parent, this, k, this.workTable.get(k));
                        ++j;
                        ++k;
                    }
                }
                cList = null;
                if (etcLen > 0) {
                    for (i2 = len - etcLen; i2 < len; ++i2) {
                        list[i2] = new MimdbSnappyRow(this, i2, this.workTable.get(i2), (rawLen = MimdbSnappyRow.byteLength(this.columnTypes, this.workTable.get(i2))) > 64, rawLen);
                        allLen += rawLen;
                        compressLen += ((MimdbRow)list[i2]).compressLength();
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < len; ++i3) {
                list[i3] = new MimdbRawRow(this, i3, this.workTable.get(i3));
            }
        }
        if (this.primaryIndexKeyNo != -1) {
            Arrays.sort(list);
            Object b = null;
            for (i = 0; i < len; ++i) {
                if (i != 0 && b.equals(((MimdbRow)list[i]).getValue(this.primaryIndexKeyNo))) {
                    throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + this.name + "]\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u4e3b\u30ad\u30fc[" + this.columns[this.primaryIndexKeyNo] + "]\u306f\u91cd\u8907\u6761\u4ef6\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059");
                }
                ((MimdbRow)list[i]).lineNo = i;
                b = ((MimdbRow)list[i]).getValue(this.primaryIndexKeyNo);
            }
        }
        this.workTable = null;
        this.mainTable = list;
        len = list.length;
        int lenJ = this.columns.length;
        for (int i4 = 0; i4 < len; ++i4) {
            Object[] values = ((MimdbRow)list[i4]).getValues();
            for (int j = 0; j < lenJ; ++j) {
                this.indexToValue(values[j], i4, j);
            }
        }
        NNObjectKeyValue<String, MimdbIndex> it = this.keyMap.reset();
        while (it.hasNext()) {
            MimdbIndex index = this.keyMap.get(it.next());
            index.createIndex();
        }
        this.allBinaryLength = allLen;
        this.allCompressLength = compressLen;
    }

    public MimdbRow get(int no) throws Exception {
        if (!this.isFix()) {
            throw new MimdbException("\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb[" + this.name + "]\u306fFix\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.mainTable.length <= no || no < 0) {
            return null;
        }
        return this.mainTable[no];
    }

    public boolean isFix() {
        return this.mainTable != null;
    }

    public int size() {
        return this.mainTable != null ? this.mainTable.length : -1;
    }

    public MimdbRow[] getMainTable() {
        return this.mainTable;
    }

    @Override
    public int getColumnSize() {
        return this.columnLength;
    }

    @Override
    public String getColumnName(int no) {
        if (no < 0 || no >= this.columnLength) {
            return null;
        }
        return this.columns[no];
    }

    @Override
    public int getColumnNameByNo(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return -1;
        }
        Integer ret = this.columnsMap.get(name);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    @Override
    public int getColumnType(int no) {
        if (no < 0 || no >= this.columnLength) {
            return -1;
        }
        return this.columnTypes[no];
    }

    @Override
    public int getColumnType(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return -1;
        }
        Integer no = this.columnsMap.get(name);
        if (no == null) {
            return -1;
        }
        return this.columnTypes[no];
    }

    @Override
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public boolean isIndex(int no) {
        if (no < 0 || no >= this.columnLength) {
            return false;
        }
        return this.keyMap.containsKey(this.columns[no]);
    }

    @Override
    public boolean isIndex(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return false;
        }
        return this.keyMap.containsKey(name);
    }

    public MimdbIndex getIndex(int no) {
        if (no < 0 || no >= this.columnLength) {
            return null;
        }
        return this.keyMap.get(this.columns[no]);
    }

    public MimdbIndex getIndex(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return null;
        }
        return this.keyMap.get(name);
    }

    public String getPrimaryIndexKey() {
        if (this.primaryIndexKeyNo == -1) {
            return null;
        }
        return this.columns[this.primaryIndexKeyNo];
    }

    public int getPrimaryIndexKeyNo() {
        return this.primaryIndexKeyNo;
    }

    public boolean isPrimaryIndexKey() {
        return this.primaryIndexKeyNo != -1;
    }

    public MimdbResultRow searchPrimaryKey(Object value) throws Exception {
        if (!this.isFix()) {
            throw new MimdbException("\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb[" + this.name + "]\u306fFix\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.primaryIndexKeyNo == -1 || value == null) {
            return null;
        }
        switch (this.columnTypes[this.primaryIndexKeyNo]) {
            case 1: {
                value = MimdbUtils.convertBool(value);
                break;
            }
            case 2: {
                value = MimdbUtils.convertInt(value);
                break;
            }
            case 3: {
                value = MimdbUtils.convertLong(value);
                break;
            }
            case 4: {
                value = MimdbUtils.convertDouble(value);
                break;
            }
            case 5: {
                value = MimdbUtils.convertString(value);
                break;
            }
            case 7: {
                value = MimdbUtils.convertSqlDate(value);
                break;
            }
            case 8: {
                value = MimdbUtils.convertSqlTime(value);
                break;
            }
            case 6: {
                value = MimdbUtils.convertSqlTimestamp(value);
            }
        }
        int res = MimdbTable.searchPrimaryKey(this.mainTable, value);
        if (res == -1) {
            return null;
        }
        return new PrimaryResultRowImpl(this.mainTable[res]);
    }

    public boolean isComress() {
        return this.compressFlag;
    }

    public int getCompressByLine() {
        return this.compressLength;
    }

    public int getBinaryLength() {
        return this.allBinaryLength;
    }

    public int getCompressLength() {
        return this.allCompressLength;
    }

    public void getBinary(OutputStream out) throws Exception {
        ObjectBinary.encode(out, this.name);
        ObjectBinary.encode(out, this.dbId);
        ObjectBinary.encode(out, this.columns);
        ObjectBinary.encode(out, this.columnTypes);
        int cnt = 0;
        int len = this.keyMap.size();
        int[] indexs = new int[len];
        NNObjectKeyValue<String, MimdbIndex> it = this.keyMap.reset();
        while (it.hasNext()) {
            indexs[cnt++] = this.columnsMap.get(it.next());
        }
        ObjectBinary.encode(out, indexs);
    }

    private static final int searchPrimaryKey(MimdbRow[] a, Object key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = ((Comparable)a[mid].getPrimaryKey()).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    protected static final int compressLength(int x) {
        if (x < 1) {
            return 1;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return 1 << (x & 0xFFFF) + (x >> 16 & 0xFFFF) - 1;
    }
}

