/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbTable;

public abstract class MimdbRow
implements MimdbBase {
    protected long dbId;
    protected MimdbTable baseTable;
    protected int lineNo;

    @Override
    public long getDbId() {
        return this.dbId;
    }

    public String getTableName() {
        return this.baseTable.name;
    }

    public MimdbTable getTable() {
        return this.baseTable;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnSize() {
        return this.baseTable.columnLength;
    }

    public String getColumnName(int no) {
        return this.baseTable.getColumnName(no);
    }

    public int getColumnNameByNo(String name) {
        return this.baseTable.getColumnNameByNo(name);
    }

    public int getColumnType(int no) {
        return this.baseTable.getColumnType(no);
    }

    public int getColumnType(String name) {
        return this.baseTable.getColumnType(name);
    }

    public boolean isIndex(int no) {
        return this.baseTable.isIndex(no);
    }

    public boolean isIndex(String name) {
        return this.baseTable.isIndex(name);
    }

    public String getPrimaryIndexKey() {
        return this.baseTable.getPrimaryIndexKey();
    }

    public boolean isPrimaryIndexKey() {
        return this.baseTable.isPrimaryIndexKey();
    }

    public int getSortNo(int no) {
        MimdbIndex idx = this.baseTable.getIndex(no);
        if (idx != null) {
            return idx.getSortNoList()[this.lineNo];
        }
        return -1;
    }

    public int getSortNo(String name) {
        MimdbIndex idx = this.baseTable.getIndex(name);
        if (idx != null) {
            return idx.getSortNoList()[this.lineNo];
        }
        return -1;
    }

    public abstract Object getValue(int var1);

    public abstract Object getValue(String var1);

    public abstract Object getPrimaryKey();

    public abstract Object[] getValues();

    public abstract int compressLength();
}

