/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableInstance;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.util.Config;

final class MimdbJdbcTable {
    private static final int FETCH_SIZE = 100;

    private MimdbJdbcTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String create(Config conf) throws Exception {
        String driver = conf.getString("jdbc", "driver", 0);
        String url = conf.getString("jdbc", "url", 0);
        String user = conf.getString("jdbc", "user", 0);
        String passwd = conf.getString("jdbc", "passwd", 0);
        String sql = conf.getString("jdbc", "sql", 0);
        if (driver == null || (driver = driver.trim()).length() <= 0) {
            throw new MimdbException("JDBC\u30c9\u30e9\u30a4\u30d0\u30fc\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (url == null || (url = driver.trim()).length() <= 0) {
            throw new MimdbException("JDBC\u63a5\u7d9a\u5148\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new MimdbException("JDBC\u63a5\u7d9aSQL\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        String tableName = MimdbTableInstance.getTableName(conf);
        String primary = MimdbTableInstance.getPrimaryKey(conf);
        String[] index = MimdbTableInstance.getIndexNames(conf);
        String[] ngram = MimdbTableInstance.getNGramIndexNames(conf);
        String[] hash = MimdbTableInstance.getHashIndexNames(conf);
        boolean compress = MimdbTableInstance.getCompressFlag(conf);
        int compressLength = MimdbTableInstance.getCompressLength(conf);
        Statement st = null;
        ResultSet rs = null;
        Connection conn = MimdbJdbcTable.driverConnection(driver, url, user, passwd);
        try {
            st = conn.createStatement(1004, 1007);
            st.setFetchSize(100);
            rs = st.executeQuery(sql);
            try {
                long id = MimdbTableInstance.begin(tableName);
                MimdbTable table = new MimdbTable(id, tableName, 4096, primary, index, ngram, hash, compress, compressLength, rs);
                conn.commit();
                rs.close();
                rs = null;
                st.close();
                st = null;
                conn.close();
                conn = null;
                table.fix();
                MimdbTableManager.getInstance().put(table);
            }
            finally {
                MimdbTableInstance.end(tableName);
            }
        }
        catch (Exception e) {
            throw new MimdbException("[" + tableName + "]\u306eJDBC\u8aad\u307f\u8fbc\u307f\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return tableName;
    }

    private static final Connection driverConnection(String driver, String url, String user, String passwd) throws Exception {
        Connection ret;
        Class.forName(driver);
        Properties p = new Properties();
        if (user == null || user.length() <= 0) {
            p.put("user", "");
            p.put("password", "");
            ret = DriverManager.getConnection(url, p);
        } else {
            p.put("user", user);
            p.put("password", passwd);
            ret = DriverManager.getConnection(url, p);
        }
        ret.setReadOnly(true);
        ret.setAutoCommit(false);
        return ret;
    }
}

