/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.EmbeddedConnection;
import org.maachang.mimdb.core.MimdbQuery;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbStatement;

final class EmbeddedStatement
implements MimdbStatement {
    private EmbeddedConnection connection = null;
    private int offset = -1;
    private int limit = -1;

    protected EmbeddedStatement(EmbeddedConnection conn) {
        this.connection = conn;
    }

    @Override
    public void close() {
        this.connection = null;
    }

    @Override
    public boolean isClose() {
        return this.connection == null || this.connection.isClose();
    }

    protected void check() {
        if (this.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public MimdbStatement setOffset(int off) {
        this.check();
        this.offset = off;
        return this;
    }

    @Override
    public MimdbStatement setLimit(int limit) {
        this.check();
        this.limit = limit;
        return this;
    }

    protected void clearOffLimit() {
        this.offset = -1;
        this.limit = -1;
    }

    @Override
    public MimdbStatement setFetchSize(int size) {
        this.check();
        return this;
    }

    @Override
    public int getFetchSize() {
        this.check();
        return -1;
    }

    @Override
    public MimdbResult executeQuery(String sql) throws Exception {
        MimdbQuery query = MimdbQuery.create(sql);
        query.setOffset(this.offset);
        query.setLimit(this.limit);
        this.offset = -1;
        this.limit = -1;
        MimdbResult ret = query.executeQuery();
        query.clear();
        return ret;
    }
}

