/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.EmbeddedConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbQueryPrepared;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.QueryCompileInfo;

final class EmbeddedPreparedStatement
implements MimdbPreparedStatement {
    private EmbeddedConnection connection = null;
    private final MimdbQueryPrepared prepared = new MimdbQueryPrepared();

    private EmbeddedPreparedStatement() {
    }

    protected EmbeddedPreparedStatement(EmbeddedConnection conn, QueryCompileInfo p) {
        this.connection = conn;
        this.prepared.create(p);
    }

    @Override
    public void close() {
        this.connection = null;
        this.prepared.clear();
    }

    @Override
    public boolean isClose() {
        return this.connection == null || this.connection.isClose();
    }

    protected void check() {
        if (this.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    protected QueryCompileInfo getInfo() {
        this.check();
        return this.prepared.getInfo();
    }

    @Override
    public long getDbId() {
        this.check();
        return this.prepared.getDbId();
    }

    @Override
    public String getName() {
        this.check();
        return this.prepared.getName();
    }

    @Override
    public int length() {
        this.check();
        return this.prepared.paramsLength();
    }

    @Override
    public MimdbPreparedStatement clearParams() {
        this.check();
        this.prepared.clearParams();
        return this;
    }

    @Override
    public MimdbPreparedStatement setParams(int index, Object value) {
        this.check();
        this.prepared.setParams(index, value);
        return this;
    }

    @Override
    public String getColumnName(int index) {
        this.check();
        return this.prepared.paramNoByColumnName(index);
    }

    @Override
    public int getType(int index) {
        this.check();
        return this.prepared.paramNoByColumnType(index);
    }

    @Override
    public MimdbPreparedStatement setOffset(int off) {
        this.check();
        this.prepared.setOffset(off);
        return this;
    }

    @Override
    public MimdbPreparedStatement setLimit(int limit) {
        this.check();
        this.prepared.setLimit(limit);
        return this;
    }

    protected void clearOffLimit() {
        this.prepared.setOffset(-1);
        this.prepared.setLimit(-1);
    }

    @Override
    public MimdbPreparedStatement setFetchSize(int size) {
        this.check();
        return this;
    }

    @Override
    public int getFetchSize() {
        this.check();
        return -1;
    }

    @Override
    public MimdbResult executeQuery() throws Exception {
        this.check();
        return this.prepared.executeQuery();
    }
}

