package org.maachang.mimdb.core.util ;

/**
 * オブジェクトKeySet.
 * 
 * @version 2013/10/29
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
public final class ObjectKeySet<T> {
    private static final int DEF_LENGTH = 32 ;
    
    private static final class ObjectKeyChild {
        Object b ;
        ObjectKeyChild n ;
        ObjectKeyChild( Object v ) {
            b = v ;
        }
    }
    
    private ObjectKeyChild[] list ;
    private int mask ;
    private int length ;
    private int limit ;
    private int base ;
    
    private boolean nullFlag ;
    
    /**
     * コンストラクタ.
     */
    public ObjectKeySet() {
        this( DEF_LENGTH ) ;
    }
    
    /**
     * コンストラクタ.
     * @param size 初期サイズを設定します.この条件は２の倍数である必要があります.
     */
    public ObjectKeySet( int size ) {
        if( size <= DEF_LENGTH ) {
            size = DEF_LENGTH ;
        }
        else {
            size = NumberKeySet.bitMask( size ) ;
        }
        list = new ObjectKeyChild[ size ] ;
        length = 0 ;
        mask = size - 1 ;
        limit = size ;
        base = size ;
        nullFlag = false ;
    }
    
    /**
     * クリア.
     */
    public void clear() {
        list = new ObjectKeyChild[ base ] ;
        length = 0 ;
        mask = base - 1 ;
        limit = base ;
        nullFlag = false ;
    }
    
    /**
     * 数値追加.
     * @param b 対象の数値を設定します.
     */
    public void add( T b ) {
        if( b == null ) {
            nullFlag = true ;
            return ;
        }
        int h,bh ;
        if( length + 1 >= limit ) {
            int nLen = limit << 1 ;
            int msk = nLen - 1 ;
            ObjectKeyChild[] nList = new ObjectKeyChild[ nLen ] ;
            ObjectKeyChild n,t ;
            for( int i = 0 ; i < limit ; i ++ ) {
                n = list[ i ] ;
                while( n != null ) {
                    if( nList[ ( h = n.b.hashCode() & msk ) ] == null ) {
                        t = n.n ;
                        n.n = null ;
                    }
                    else {
                        t = n.n ;
                        n.n = nList[ h ] ;
                    }
                    nList[ h ] = n ;
                    n = t ;
                }
            }
            list = nList ;
            limit = nLen ;
            mask = msk ;
        }
        bh = b.hashCode() ;
        if( list[ ( h = bh & mask ) ] == null ) {
            list[ h ] = new ObjectKeyChild( b ) ;
            length ++ ;
        }
        else {
            ObjectKeyChild nn = list[ h ] ;
            while( nn.n != null ) {
                if( nn.b.hashCode() == bh && ( nn.b == b || nn.b.equals( b ) ) ) {
                    return ;
                }
                nn = nn.n ;
            }
            if( nn.b.hashCode() != bh || nn.b != b || !nn.b.equals( b ) ) {
                nn.n = new ObjectKeyChild( b ) ;
                length ++ ;
            }
        }
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象の数値を設定します.
     * @return boolean [true]の場合、数値は存在します.
     */
    public boolean contains( T b ) {
        if( b == null ) {
            return nullFlag ;
        }
        int bh = b.hashCode() ;
        ObjectKeyChild n = list[ bh & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == bh && ( n.b == b || n.b.equals( b ) ) ) {
                return true ;
            }
            n = n.n ;
        }
        return false ;
    }
    
    /**
     * 削除処理.
     * @param b 対象のキーを設定します.
     */
    public void remove( Object b ) {
        if( b == null ) {
            nullFlag = false ;
            return ;
        }
        int bh = b.hashCode() ;
        ObjectKeyChild bf = null ;
        ObjectKeyChild n = list[ bh & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == bh && ( n.b == b || n.b.equals( b ) ) ) {
                if( bf == null ) {
                    if( n.n == null ) {
                        list[ bh & mask ] = null ;
                    }
                    else {
                        list[ bh & mask ] = n.n ;
                    }
                }
                else {
                    if( n.n == null ) {
                        bf.n = null ;
                    }
                    else {
                        bf.n = n.n ;
                    }
                }
                length -- ;
                break ;
            }
            bf = n ;
            n = n.n ;
        }
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return ( nullFlag ) ? length + 1 : length ;
    }
    
    /**
     * 配列として返却.
     * @return Object[] 配列として返却します.
     */
    public Object[] array() {
        if( size() == 0 ) {
            return null ;
        }
        ObjectKeyChild n ;
        int cnt ;
        Object[] ret ;
        if( nullFlag ) {
            ret = new Object[ length + 1 ] ;
            cnt = 1 ;
        }
        else {
            ret = new Object[ length ] ;
            cnt = 0 ;
        }
        for( int i = 0 ; i < limit ; i ++ ) {
            if( list[ i ] != null ) {
                n = list[ i ] ;
                while( n != null ) {
                    ret[ cnt ++ ] = n.b ;
                    n = n.n ;
                }
            }
        }
        return ret ;
    }
    
    /** 位置読み込み条件. **/
    private int pos = 0 ;
    private ObjectKeyChild cPos = null ;
    private int count = 0 ;
    private boolean nullOutFlag = false ;
    
    /**
     * 読み込み中の位置をリセット.
     * @return ObjectKeySet このオブジェクトが返却されます.
     */
    public ObjectKeySet<T> reset() {
        pos = 0 ;
        cPos = null ;
        count = 0 ;
        nullOutFlag = false ;
        return this ;
    }
    
    /**
     * 次の読み込み条件を取得.
     * @return boolean [true]が返却された場合、情報は存在します.
     */
    public boolean hasNext() {
        if( count == 0 ) {
            if( nullFlag ) {
                count ++ ;
                return true ;
            }
            else {
                nullOutFlag = true ;
            }
        }
        if( cPos != null ) {
            if( ( cPos = cPos.n ) != null ) {
                count ++ ;
                return true ;
            }
        }
        while( pos < limit ) {
            if( ( cPos = list[ pos ++ ] ) != null ) {
                count ++ ;
                return true ;
            }
        }
        return false ;
    }
    
    /**
     * 現在の読み込み位置の情報を取得.
     * @return Object 現在の読み込み位置の内容が返却されます.
     *                 [null]の場合は、情報は存在しません.
     */
    public T next() {
        if( !nullOutFlag ) {
            nullOutFlag = true ;
            return null ;
        }
        if( cPos == null ) {
            return null ;
        }
        return (T)cPos.b ;
    }
    
    /**
     * カウントを取得.
     * @return int 現在読み込み中の位置が返却されます.
     */
    public int count() {
        return count ;
    }
}
