package org.maachang.mimdb.core.util ;

/**
 * 数字リスト.
 * 
 * @version 2013/10/26
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class NumberList {
    protected int[] list ;
    protected int length ;
    private int max ;
    
    public NumberList() {
        this( 16 ) ;
    }
    
    public NumberList( int buf ) {
        if( buf < 16 ) {
            buf = 16 ;
        }
        max = buf ;
        list = new int[ buf ] ;
        length = 0 ;
    }
    
    public void clear() {
        list = new int[ max ] ;
        length = 0 ;
    }
    
    public void add( int n ) {
        if( length + 1 >= list.length ) {
            int[] tmp = new int[ length << 1 ] ;
            System.arraycopy( list,0,tmp,0,length ) ;
            list = tmp ;
        }
        list[ length ++ ] = n ;
    }
    
    public void set( int no,int n ) {
        list[ no ] = n ;
    }
    
    public int get( int no ) {
        return list[ no ] ;
    }
    
    public void remove( int no ) {
        if( length > 1 ) {
            for( length -- ; no < length ; list[ no ] = list[ ++ no ] ) ;
        }
        else {
            length = 0 ;
        }
    }
    
    public int size() {
        return length ;
    }
    
    public int[] getArray() {
        int[] ret = new int[ length ] ;
        System.arraycopy( list,0,ret,0,length ) ;
        return ret ;
    }
}

