package org.maachang.mimdb.test ;

import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbStatement;

/**
 * [サーバー接続型]郵便番号呼び出しサンプル.
 * 
 * @version 2014/01/20
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public class ReadPostalClient {
    
    /** main. **/
    public static final void main( String[] args ) throws Exception {
        
        MimdbResult rs ;
        MimdbResultRow row ;
        
        // コネクションオブジェクト.
        MimdbConnection connection = MimdbConnection.create( "127.0.0.1" ) ;
        
        // 郵便番号.
        // 東京都千代田区=100-0000
        String zip = "1000000" ;
        
        // SQL実行.
        {
            
            // statemetモード.
            String sql = "select * from postal_master where id='"+zip+"';" ;
            
            MimdbStatement stmt = connection.getStatement() ;
            rs = stmt.executeQuery( sql ) ;
            
            // 結果表示.
            while( rs.next() ) {
                row = rs.get() ;
                System.out.println( "結果:" + row ) ;
            }
            
        }
        {
            // Preparedモード.
            String sql = "select * from postal_master where id=? ;" ;
            
            MimdbPreparedStatement ps = connection.getPreparedStatement( sql ) ;
            
            // パラメータセット.
            ps.setParams( 0, zip ) ;
            
            // 実行処理.
            rs = ps.executeQuery() ;
            
            // 結果表示.
            while( rs.next() ) {
                row = rs.get() ;
                System.out.println( "結果:" + row ) ;
            }
        }
    }
    
}
