/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.io.OutputStream;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.util.ObjectBinary;

public final class MSearchElement
implements MimdbSearchElement {
    protected int type;
    protected String column;
    protected Object value;
    protected int columnNo;
    protected boolean preparedType;

    public MSearchElement() {
    }

    public MSearchElement(int type) throws Exception {
        this.create(type);
    }

    public MSearchElement(String type) throws Exception {
        this.create(type);
    }

    public MSearchElement(String column, String type) throws Exception {
        this.create(column, type);
    }

    public MSearchElement(String column, int type) throws Exception {
        this.create(column, type);
    }

    public MSearchElement(String column, String type, Object value) throws Exception {
        this.create(column, type, value);
    }

    public MSearchElement(String column, int type, Object value) throws Exception {
        this.create(column, type, value);
    }

    public void create(String column, String type) throws Exception {
        this.create(column, type, null, true);
    }

    public void create(String column, int type) throws Exception {
        this.create(column, type, null, true);
    }

    public void create(String column, String type, Object value) throws Exception {
        this.create(column, type, value, false);
    }

    public void create(String column, int type, Object value) throws Exception {
        this.create(column, type, value, false);
    }

    public void create(String type) throws Exception {
        if (type == null || (type = type.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int t = -1;
        if ("(".equals(type)) {
            t = 10;
        } else if (")".equals(type)) {
            t = 11;
        } else if ("and".equals(type)) {
            t = 20;
        } else if ("or".equals(type)) {
            t = 21;
        } else {
            throw new MimdbException("\u5229\u7528\u3067\u304d\u306a\u3044\u691c\u7d22\u6761\u4ef6[" + type + "]\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.create(t);
    }

    public void create(int type) throws Exception {
        switch (type) {
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                throw new MimdbException("\u4e0d\u660e\u306a\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059[" + type + "]");
            }
        }
        this.column = null;
        this.type = type;
        this.value = null;
        this.columnNo = -1;
        this.preparedType = false;
    }

    protected void create(String column, String type, Object value, boolean preparedType) throws Exception {
        if (type == null || (type = type.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int t = -1;
        if ("=".equals(type)) {
            t = 1;
        } else if ("!=".equals(type) || "<>".equals(type)) {
            t = 2;
        } else if (">".equals(type)) {
            t = 3;
        } else if (">=".equals(type)) {
            t = 4;
        } else if ("<".equals(type)) {
            t = 5;
        } else if ("<=".equals(type)) {
            t = 6;
        } else if ("in".equals(type)) {
            t = 7;
        } else if ("like".equals(type)) {
            t = 8;
        } else if ("between".equals(type)) {
            t = 9;
        } else if ("offset".equals(column) || "limit".equals(column)) {
            t = 30;
        } else {
            throw new MimdbException("\u5229\u7528\u3067\u304d\u306a\u3044\u691c\u7d22\u6761\u4ef6[" + type + "]\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.create(column, t, value, preparedType);
    }

    protected void create(String column, int type, Object value, boolean preparedType) throws Exception {
        block8: {
            block7: {
                if (column == null || (column = column.trim().toLowerCase()).length() <= 0) {
                    throw new MimdbException("\u6bd4\u8f03\u5bfe\u8c61\u306e\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                if (value != null) break block7;
                switch (type) {
                    case 1: 
                    case 2: {
                        break block8;
                    }
                    default: {
                        throw new MimdbException("NULL\u691c\u7d22\u3067\u5229\u7528\u3067\u304d\u306a\u3044\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059[" + type + "]");
                    }
                }
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 30: {
                    break;
                }
                default: {
                    throw new MimdbException("\u4e0d\u660e\u306a\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059[" + type + "]");
                }
            }
        }
        this.column = column;
        this.type = type;
        this.value = value;
        this.columnNo = -1;
        this.preparedType = preparedType;
    }

    public void clear() {
        this.type = -1;
        this.columnNo = -1;
        this.column = null;
        this.value = null;
        this.preparedType = false;
    }

    public String getColumn() {
        return this.column;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isPrepared() {
        return this.preparedType;
    }

    public boolean isWhere() {
        switch (this.type) {
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                return false;
            }
        }
        return true;
    }

    public boolean isAndOr() {
        switch (this.type) {
            case 20: 
            case 21: {
                return true;
            }
        }
        return true;
    }

    public boolean isOffLimit() {
        return this.type == 30;
    }

    public int columnNameByNo(BaseTable table) throws Exception {
        if (this.column != null) {
            this.columnNo = table.getColumnNameByNo(this.column);
            if (this.columnNo == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + this.column + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            return this.columnNo;
        }
        throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return MSearchElement.toStringStatic(this.type, this.column, this.value, this.preparedType);
    }

    protected static final String toStringStatic(int type, String column, Object value, boolean preparedType) {
        switch (type) {
            case 10: {
                return "(";
            }
            case 11: {
                return ")";
            }
            case 20: {
                return "and";
            }
            case 21: {
                return "or";
            }
        }
        StringBuilder buf = new StringBuilder();
        switch (type) {
            case 1: {
                return buf.append(column).append(" = ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 2: {
                return buf.append(column).append(" != ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 3: {
                return buf.append(column).append(" > ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 4: {
                return buf.append(column).append(" >= ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 5: {
                return buf.append(column).append(" <= ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 6: {
                return buf.append(column).append(" <= ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 7: {
                if (!preparedType && value instanceof List) {
                    buf.append(column).append(" IN ( ");
                    List n = (List)value;
                    int len = n.size();
                    int i = 0;
                    while (i < len) {
                        if (i != 0) {
                            buf.append(" , ");
                        }
                        buf.append(MSearchElement.valueString(n.get(i), preparedType));
                        ++i;
                    }
                    return buf.append(" )").toString();
                }
                return buf.append(column).append(" IN ( ").append(MSearchElement.valueString(value, preparedType)).append(" )").toString();
            }
            case 8: {
                return buf.append(column).append(" LIKE ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
            case 9: {
                if (!preparedType && value instanceof List) {
                    buf.append(column).append(" BETWEEN ( ");
                    List n = (List)value;
                    int len = n.size();
                    int i = 0;
                    while (i < len) {
                        if (i != 0) {
                            buf.append(" , ");
                        }
                        buf.append(MSearchElement.valueString(n.get(i), preparedType));
                        ++i;
                    }
                    return buf.append(" )").toString();
                }
                return buf.append(column).append(" BETWEEN ( ").append(MSearchElement.valueString(value, preparedType)).append(" )").toString();
            }
            case 30: {
                return buf.append(column).append(" ").append(MSearchElement.valueString(value, preparedType)).toString();
            }
        }
        return "";
    }

    private static final String valueString(Object o, boolean preparedType) {
        if (preparedType) {
            return "?";
        }
        if (o instanceof String) {
            return "'" + o + "'";
        }
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }

    public void getOutput(OutputStream out) throws Exception {
        ObjectBinary.encode(out, this.type);
        ObjectBinary.encode(out, this.column);
        ObjectBinary.encode(out, this.value);
        ObjectBinary.encode(out, this.columnNo);
        ObjectBinary.encode(out, this.preparedType);
    }
}

