/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.lang.reflect.Array;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.ObjectLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashIndex<T> {
    protected final HashElement<T>[][] hash;
    protected final int mask;

    private HashIndex() {
        this.hash = null;
        this.mask = -1;
    }

    public HashIndex(Object index) {
        ObjectLinkedList ary;
        int no;
        int len = Array.getLength(index);
        int bitLen = MimdbUtils.bitMask(len) << 1;
        int msk = bitLen - 1;
        ObjectLinkedList[] work = new ObjectLinkedList[bitLen];
        int i = 0;
        while (i < len) {
            Object n = Array.get(index, i);
            int hash = n.hashCode();
            no = hash & msk;
            ary = work[no];
            if (ary == null) {
                work[no] = ary = new ObjectLinkedList();
            }
            ary.offer(i);
            ++i;
        }
        HashElement[][] hman = new HashElement[bitLen][];
        int i2 = 0;
        while (i2 < bitLen) {
            ary = work[i2];
            if (ary == null) {
                hman[i2] = new HashElement[0];
            } else {
                int lenJ = ary.size();
                HashElement[] ha = new HashElement[lenJ];
                hman[i2] = ha;
                int j = 0;
                while (j < lenJ) {
                    no = (Integer)ary.poll();
                    HashElement h = new HashElement();
                    h.value = Array.get(index, no);
                    h.no = no;
                    ha[j] = h;
                    ++j;
                }
            }
            ++i2;
        }
        work = null;
        this.hash = hman;
        this.mask = msk;
    }

    public int eq(T value) {
        HashElement<T>[] ary = this.hash[value.hashCode() & this.mask];
        int len = ary.length;
        int i = 0;
        while (i < len) {
            if (value.equals(ary[i].value)) {
                return ary[i].no;
            }
            ++i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashElement<T> {
        T value;
        int no;

        HashElement() {
        }
    }
}

