/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbMetaData;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.ResultCache;
import org.maachang.mimdb.core.ResultPointer;
import org.maachang.mimdb.core.util.AtomicNumber32;

class ResultImpl
implements MimdbResult {
    long dbId;
    MimdbTable table;
    ResultCache cache;
    MimdbMetaData meta;
    MimdbResultRow row;
    ResultPointer pointer;
    int length;
    int maxLength;
    int cursor;
    protected final AtomicNumber32 clearFlag = new AtomicNumber32(1);

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(long id, MimdbTable table, ResultCache cache, MimdbMetaData meta, MimdbResultRow row, ResultPointer pointer, int length, int maxLength) {
        this.dbId = id;
        this.table = table;
        this.meta = meta;
        this.row = row;
        this.pointer = pointer;
        this.length = length;
        this.maxLength = maxLength;
        this.cache = cache;
        this.clearFlag.set(0);
    }

    public void clear() {
        long res = this.clearFlag.setToBeforeReturn(1);
        if (res != 1L) {
            this.cache.clear();
            this.dbId = -1L;
            this.table = null;
            this.meta = null;
            this.row = null;
            this.pointer = null;
            this.length = 0;
            this.maxLength = 0;
            this.cursor = 0;
            ResultCache.put(this.cache);
        }
    }

    public boolean isClear() {
        return this.clearFlag.get() == 1;
    }

    protected void check() {
        if (this.clearFlag.get() == 1) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30af\u30ea\u30a2\u30fc\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public long getDbId() {
        this.check();
        return this.dbId;
    }

    public MimdbMetaData getMetaData() {
        this.check();
        return this.meta;
    }

    public boolean first() throws Exception {
        this.check();
        this.cursor = 0;
        return true;
    }

    public boolean last() throws Exception {
        this.check();
        this.cursor = this.length - 1;
        return true;
    }

    public boolean next() {
        this.check();
        return this.cursor < this.length;
    }

    public boolean absolute(int no) throws Exception {
        this.check();
        if (no >= 0 && no < this.length) {
            this.cursor = no;
            return true;
        }
        this.cursor = no;
        return false;
    }

    public int getRow() {
        this.check();
        return this.cursor;
    }

    public MimdbResult setFetchSize(int size) {
        return this;
    }

    public int getFetchSize() {
        return -1;
    }

    public MimdbResultRow get() throws Exception {
        this.check();
        if (this.cursor < this.length) {
            if (this.pointer != null) {
                this.pointer.cursor = this.cursor;
            }
            ++this.cursor;
            return this.row;
        }
        throw new MimdbException("\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
    }

    public MimdbResultRow get(int no) throws Exception {
        this.check();
        if (no < 0 || no >= this.length) {
            throw new MimdbException("\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.cursor = no;
        return this.get();
    }

    public int length() {
        this.check();
        return this.length;
    }

    public int maxLength() {
        this.check();
        return this.maxLength;
    }
}

