/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.RemoteTable;
import org.maachang.mimdb.core.TableManager;

public class RemoteTableManager
implements TableManager {
    private static final RemoteTableManager SNGL = new RemoteTableManager();
    private final Map<String, RemoteTable> tables = new ConcurrentHashMap<String, RemoteTable>();

    private RemoteTableManager() {
    }

    public static final RemoteTableManager getInstance() {
        return SNGL;
    }

    public void destroy() {
        this.tables.clear();
    }

    private static final String tableNameNoError(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return null;
        }
        return name;
    }

    public boolean isTable(String name) {
        if ((name = RemoteTableManager.tableNameNoError(name)) == null) {
            return false;
        }
        return this.tables.containsKey(name);
    }

    public void put(RemoteTable table) {
        if (table == null) {
            throw new IllegalArgumentException("\u30c6\u30fc\u30d6\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String name = table.name;
        this.tables.put(name, table);
    }

    public BaseTable get(String name) {
        return this.tables.get(name);
    }

    public boolean remove(String name) {
        this.tables.remove(name);
        return true;
    }

    public int size() {
        return this.tables.size();
    }

    public String[] getTables() {
        int len = this.tables.size();
        if (len == 0) {
            return null;
        }
        int cnt = 0;
        String[] ret = new String[len];
        Iterator<String> n = this.tables.keySet().iterator();
        if (n.hasNext()) {
            ret[cnt++] = n.next();
        }
        return ret;
    }
}

