/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.RemoteConnection;
import org.maachang.mimdb.core.RemoteMetaDataImpl;
import org.maachang.mimdb.core.RemoteResultImpl;

final class RemoteStatement
implements MimdbStatement {
    protected RemoteConnection connection = null;
    protected int fetchSize = 10;
    protected int offset = -1;
    protected int limit = -1;
    protected int[] out = new int[3];
    protected RemoteResultImpl result = null;
    protected final RemoteMetaDataImpl meta = new RemoteMetaDataImpl();

    protected RemoteStatement() {
    }

    protected RemoteStatement(RemoteConnection conn) {
        this.open(conn);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    protected void open(RemoteConnection conn) {
        this.connection = conn;
    }

    public void close() {
        this.connection = null;
    }

    public boolean isClose() {
        return this.connection == null || this.connection.isClose();
    }

    protected void check() {
        if (this.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    public MimdbStatement setOffset(int off) {
        this.check();
        this.offset = off;
        return this;
    }

    public MimdbStatement setLimit(int limit) {
        this.check();
        this.limit = limit;
        return this;
    }

    protected void clearOffLimit() {
        this.offset = -1;
        this.limit = -1;
    }

    public MimdbStatement setFetchSize(int size) {
        this.check();
        this.fetchSize = size;
        return this;
    }

    public int getFetchSize() {
        this.check();
        return this.fetchSize;
    }

    public MimdbResult executeQuery(String sql) throws Exception {
        this.check();
        QueryCompileInfo compile = null;
        try {
            compile = RemoteConnection.compile(this.connection, sql);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
        if (compile.preparedParamsSize > 0) {
            throw new MimdbException("\u30d1\u30e9\u30e1\u30fc\u30bf\u4ed8\u304d\u306eSQL\u6587\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093");
        }
        int off = compile.defOffset;
        int lmt = compile.defLimit;
        if (this.offset >= 0) {
            off = this.offset;
            this.offset = -1;
        }
        if (this.limit >= 0) {
            lmt = this.limit;
            this.limit = -1;
        }
        this.out[0] = -1;
        this.out[1] = -1;
        this.out[2] = -1;
        this.connection.client.statement(this.out, compile, off, lmt);
        return this.getResult(this.connection, compile, this.getMeta(this.connection, compile), this.fetchSize, this.out[0], this.out[1], this.out[2]);
    }

    private final RemoteResultImpl getResult(RemoteConnection conn, QueryCompileInfo cmp, RemoteMetaDataImpl mt, int fetch, int resId, int len, int max) {
        if (this.connection.result.isClearData()) {
            this.connection.result.create(conn, cmp, mt, fetch, resId, len, max);
            return this.connection.result;
        }
        if (this.result == null) {
            this.result = new RemoteResultImpl(conn, cmp, mt, fetch, resId, len, max);
            return this.result;
        }
        if (this.result.isClearData()) {
            this.result.create(conn, cmp, mt, fetch, resId, len, max);
            return this.result;
        }
        return new RemoteResultImpl(conn, cmp, mt, fetch, resId, len, max);
    }

    private final RemoteMetaDataImpl getMeta(RemoteConnection conn, QueryCompileInfo cmp) {
        if (this.meta.isClearData()) {
            this.meta.create(conn, cmp, true);
            return this.meta;
        }
        return new RemoteMetaDataImpl(conn, cmp, true);
    }
}

