/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.io.OutputStream;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.TableManager;
import org.maachang.mimdb.core.impl.EqualsNoList;
import org.maachang.mimdb.core.impl.WhereBlock;
import org.maachang.mimdb.core.util.ObjectBinary;
import org.maachang.mimdb.core.util.ObjectList;

public final class QueryCompileInfo
implements MimdbBase {
    protected long dbId;
    protected String name;
    protected int preparedId;
    protected EqualsNoList columns;
    protected boolean countFlag;
    protected SortElement sort;
    protected WhereBlock block;
    protected MimdbSearchElement[] preparedParams;
    protected int preparedParamsSize;
    protected int defOffset = -1;
    protected int defLimit = -1;

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.dbId = -1L;
        this.name = null;
        this.preparedId = -1;
        this.columns = null;
        this.countFlag = false;
        this.sort = null;
        this.block = null;
        this.preparedParams = null;
        this.preparedParamsSize = 0;
        this.defOffset = -1;
        this.defLimit = -1;
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.name;
    }

    public void setPreparedId(int id) {
        this.preparedId = id;
    }

    public int getPreparedId() {
        return this.preparedId;
    }

    public String getSql(TableManager manager) throws Exception {
        if (this.name == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        BaseTable table = manager.get(this.name);
        if (table == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d[" + this.name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("SELECT ");
        if (this.countFlag) {
            buf.append("COUNT(*) ");
        } else {
            int len = this.columns.size();
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(table.getColumnName(this.columns.src(i))).append(" ");
                ++i;
            }
        }
        buf.append("FROM ").append(this.name).append(" ");
        if (this.block != null) {
            buf.append("WHERE ");
            buf.append(this.block.toString(false));
        }
        if (this.sort != null) {
            buf.append("ORDER BY ");
            int[] lst = this.sort.sortNoList;
            boolean[] desc = this.sort.desc;
            int len = lst.length;
            int i = 0;
            while (i < len) {
                buf.append(table.getColumnName(lst[i])).append(" ");
                if (desc[i]) {
                    buf.append("DESC ");
                } else {
                    buf.append("ASC ");
                }
                ++i;
            }
        }
        return buf.append(";").toString();
    }

    public void getBinary(OutputStream out) throws Exception {
        ObjectBinary.encode(out, this.dbId);
        ObjectBinary.encode(out, this.name);
        if (this.columns == null) {
            ObjectBinary.encode(out, false);
        } else {
            ObjectBinary.encode(out, true);
            this.columns.getOutput(out);
        }
        ObjectBinary.encode(out, this.countFlag);
        if (this.sort == null) {
            ObjectBinary.encode(out, false);
        } else {
            ObjectBinary.encode(out, true);
            this.sort.getOutput(out);
        }
        if (this.block == null) {
            ObjectBinary.encode(out, false);
        } else {
            ObjectBinary.encode(out, true);
            this.block.getOutput(out);
        }
        ObjectBinary.encode(out, this.defOffset);
        ObjectBinary.encode(out, this.defLimit);
    }

    public int toObject(byte[] b, int off, int len) throws Exception {
        int[] p = new int[]{off};
        this.clear();
        this.dbId = (Long)ObjectBinary.decodeBinary(p, b, len);
        this.name = (String)ObjectBinary.decodeBinary(p, b, len);
        if (((Boolean)ObjectBinary.decodeBinary(p, b, len)).booleanValue()) {
            int[] src = (int[])ObjectBinary.decodeBinary(p, b, len);
            this.columns = new EqualsNoList(src);
        } else {
            this.columns = null;
        }
        this.countFlag = (Boolean)ObjectBinary.decodeBinary(p, b, len);
        if (((Boolean)ObjectBinary.decodeBinary(p, b, len)).booleanValue()) {
            int[] sortListNo = (int[])ObjectBinary.decodeBinary(p, b, len);
            boolean[] desc = (boolean[])ObjectBinary.decodeBinary(p, b, len);
            this.sort = new SortElement();
            this.sort.sortNoList = sortListNo;
            this.sort.desc = desc;
        } else {
            this.sort = null;
        }
        if (((Boolean)ObjectBinary.decodeBinary(p, b, len)).booleanValue()) {
            this.block = new WhereBlock();
            ObjectList<MimdbSearchElement> list = new ObjectList<MimdbSearchElement>();
            this.block.toObject(p, list, b, len);
            this.preparedParamsSize = list.size();
            this.preparedParams = new MimdbSearchElement[this.preparedParamsSize];
            int i = 0;
            while (i < this.preparedParamsSize) {
                this.preparedParams[i] = list.get(i);
                ++i;
            }
        } else {
            this.block = null;
            this.preparedParamsSize = 0;
        }
        this.defOffset = (Integer)ObjectBinary.decodeBinary(p, b, len);
        this.defLimit = (Integer)ObjectBinary.decodeBinary(p, b, len);
        this.preparedId = -1;
        return p[0];
    }
}

