/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.QueryInfo;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.TableManager;
import org.maachang.mimdb.core.impl.EqualsNoList;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.impl.WhereBlock;
import org.maachang.mimdb.core.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryCompile {
    private QueryCompile() {
    }

    public static final void compile(QueryCompileInfo out, QueryInfo info, TableManager manager) throws Exception {
        out.clear();
        QueryCompile.checkCompile(info);
        BaseTable table = manager.get(info.name);
        if (table == null) {
            throw new MimdbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + info.name + "]\u306e\u30c6\u30fc\u30d6\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (!info.allColumn && !info.countFlag) {
            QueryCompile.setViewColumns(out, table, info.columns);
        } else if (info.countFlag) {
            out.columns = null;
            out.countFlag = true;
        } else if (info.allColumn) {
            out.columns = null;
            out.countFlag = false;
        }
        if (info.sortList.size() > 0) {
            QueryCompile.setSortColumns(out, table, info.sortList, info.descList);
        } else {
            out.sort = null;
        }
        if (info.where.size() > 0) {
            QueryCompile.setWhere(out, table, info.where);
        } else {
            out.block = null;
            out.preparedParams = null;
        }
        out.name = table.getName();
        out.dbId = table.getDbId();
    }

    private static final void checkCompile(QueryInfo info) throws Exception {
        if (info.name == null || info.name.length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!info.allColumn && !info.countFlag && info.columns.size() <= 0) {
            throw new MimdbException("\u8868\u793a\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private static final void setViewColumns(QueryCompileInfo out, BaseTable table, ObjectList<String> columns) throws Exception {
        int len = columns.size();
        int[] columnArray = new int[len];
        int i = 0;
        while (i < len) {
            String s = columns.get(i);
            if (s == null || s.length() <= 0) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304cNULL\u3067\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int p = table.getColumnNameByNo(s);
            if (p == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + s + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            columnArray[i] = p;
            ++i;
        }
        out.columns = new EqualsNoList(columnArray);
        out.countFlag = false;
    }

    private static final void setSortColumns(QueryCompileInfo out, BaseTable table, ObjectList<String> sortList, ObjectList<Boolean> descList) throws Exception {
        int len = sortList.size();
        int[] sort = new int[len];
        boolean[] desc = new boolean[len];
        int i = 0;
        while (i < len) {
            String s = sortList.get(i);
            if (s == null || s.length() <= 0) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304cNULL\u3067\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int p = table.getColumnNameByNo(s);
            if (p == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + s + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            sort[i] = p;
            desc[i] = descList.get(i);
            ++i;
        }
        out.sort = new SortElement();
        out.sort.sortNoList = sort;
        out.sort.desc = desc;
    }

    private static final void setWhere(QueryCompileInfo out, BaseTable table, ObjectList<MimdbSearchElement> list) throws Exception {
        WhereBlock block;
        int par = 0;
        int andor = -1;
        WhereBlock top = block = new WhereBlock();
        ObjectList<MimdbSearchElement> params = new ObjectList<MimdbSearchElement>();
        int len = list.size();
        int i = 0;
        while (i < len) {
            MimdbSearchElement n = list.get(i);
            switch (n.getType()) {
                case 10: {
                    ++par;
                    block = block.add(new WhereBlock());
                    break;
                }
                case 11: {
                    block = block.getTop();
                    if (block == null) {
                        throw new MimdbException("\u62ec\u5f27\u306e\u69cb\u6210\u304c\u4e0d\u6b63\u3067\u3059");
                    }
                    --par;
                    break;
                }
                case 20: {
                    if (andor != -1) {
                        throw new MimdbException("and\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                    andor = 0;
                    block.add(n);
                    break;
                }
                case 21: {
                    if (andor != -1) {
                        throw new MimdbException("or\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                    andor = 1;
                    block.add(n);
                    break;
                }
                case 30: {
                    if (n.isPrepared()) {
                        params.add(n);
                        break;
                    }
                    if ("offset".equals(n.getColumn())) {
                        out.defOffset = MimdbUtils.convertInt(n.getValue());
                        break;
                    }
                    out.defLimit = MimdbUtils.convertInt(n.getValue());
                    break;
                }
                default: {
                    andor = -1;
                    int p = n.columnNameByNo(table);
                    if (!table.isIndex(p)) {
                        throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u306a\u3044\u30ab\u30e9\u30e0[" + n.getColumn() + "]\u306f\u3001where\u6761\u4ef6\u306b\u5b9a\u7fa9\u3067\u304d\u307e\u305b\u3093");
                    }
                    if (n.isPrepared()) {
                        params.add(n);
                    }
                    block.add(n);
                }
            }
            ++i;
        }
        if (par != 0) {
            throw new MimdbException("\u62ec\u5f27\u306e\u6574\u5408\u6027\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (andor != -1) {
            throw new MimdbException("And,Or\u306e\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059");
        }
        out.block = top;
        if (params.size() > 0) {
            len = params.size();
            MimdbSearchElement[] pms = new MimdbSearchElement[len];
            int i2 = 0;
            while (i2 < len) {
                pms[i2] = (MimdbSearchElement)params.get(i2);
                ++i2;
            }
            out.preparedParams = pms;
            out.preparedParamsSize = len;
        } else {
            out.preparedParams = null;
            out.preparedParamsSize = 0;
        }
    }
}

