/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbUpdateLock;
import org.maachang.mimdb.core.TableManager;

public class MimdbTableManager
implements TableManager {
    private static final MimdbTableManager SNGL = new MimdbTableManager();
    private final Map<String, MimdbUpdateLock> tablesManager = new ConcurrentHashMap<String, MimdbUpdateLock>(64);
    private final Map<String, MimdbTable> tables = new ConcurrentHashMap<String, MimdbTable>(64);

    private MimdbTableManager() {
    }

    public static final MimdbTableManager getInstance() {
        return SNGL;
    }

    public void destroy() {
        this.tables.clear();
        this.tablesManager.clear();
    }

    private static final String tableName(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new IllegalArgumentException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u4e0d\u660e\u3067\u3059");
        }
        return name;
    }

    private static final String tableNameNoError(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return null;
        }
        return name;
    }

    public boolean isTable(String name) {
        if ((name = MimdbTableManager.tableNameNoError(name)) == null) {
            return false;
        }
        return this.tables.containsKey(name);
    }

    protected boolean begin(String name) {
        return this.begin(name, false);
    }

    protected boolean begin(String name, boolean notCreate) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            if (notCreate) {
                lock = new MimdbUpdateLock();
                this.tablesManager.put(name, lock);
            } else {
                return false;
            }
        }
        lock.writeBegin();
        return true;
    }

    protected boolean end(String name) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return false;
        }
        if (!this.tables.containsKey(name)) {
            this.tablesManager.remove(name);
        }
        lock.writeEnd();
        return true;
    }

    protected long updateId(String name) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return -1L;
        }
        return lock.update();
    }

    protected void rollbackId(String name, long id) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return;
        }
        lock.setDbId(id);
    }

    public long getId(String name) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return -1L;
        }
        return lock.getDbId();
    }

    public void put(MimdbTable table) {
        if (table == null) {
            throw new IllegalArgumentException("\u30c6\u30fc\u30d6\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String name = table.name;
        this.begin(name, true);
        try {
            this.tables.put(name, table);
        }
        finally {
            this.end(name);
        }
    }

    public BaseTable get(String name) {
        MimdbTable ret;
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return null;
        }
        lock.readBegin();
        try {
            ret = this.tables.get(name);
        }
        finally {
            lock.readEnd();
        }
        return ret;
    }

    public boolean remove(String name) {
        MimdbUpdateLock lock = this.tablesManager.get(name = MimdbTableManager.tableName(name));
        if (lock == null) {
            return false;
        }
        lock.writeBegin();
        try {
            this.tables.remove(name);
            this.tablesManager.remove(name);
        }
        finally {
            lock.writeEnd();
        }
        return true;
    }

    public int size() {
        return this.tables.size();
    }

    public String[] getTables() {
        int len = this.tables.size();
        if (len == 0) {
            return null;
        }
        int cnt = 0;
        String[] ret = new String[len];
        Iterator<String> n = this.tables.keySet().iterator();
        if (n.hasNext()) {
            ret[cnt++] = n.next();
        }
        return ret;
    }
}

