/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbQueryPrepared;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.QueryCompile;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.QueryInfo;
import org.maachang.mimdb.core.impl.SqlAnalyzer;

public class MimdbQuery {
    private QueryInfo info = null;
    private MimdbQueryPrepared compile = null;
    private int offset = -1;
    private int limit = -1;

    public MimdbQuery() {
    }

    public MimdbQuery(QueryInfo info) throws Exception {
        this.create(info);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public static final MimdbQuery create(String sql) throws Exception {
        MimdbQuery ret = new MimdbQuery();
        MimdbQuery.create(ret, sql);
        return ret;
    }

    public static final void create(MimdbQuery out, String sql) throws Exception {
        QueryInfo info = new QueryInfo();
        SqlAnalyzer.analysis(info, sql);
        out.create(info);
    }

    public static final MimdbQueryPrepared createPrepared(String sql) throws Exception {
        MimdbQueryPrepared ret = new MimdbQueryPrepared();
        MimdbQuery.createPrepared(ret, sql);
        return ret;
    }

    public static final void createPrepared(MimdbQueryPrepared out, String sql) throws Exception {
        out.create(MimdbQuery.createCompile(sql));
    }

    protected static final QueryCompileInfo createCompile(String sql) throws Exception {
        QueryInfo info = new QueryInfo();
        QueryCompileInfo ret = new QueryCompileInfo();
        SqlAnalyzer.analysis(info, sql);
        QueryCompile.compile(ret, info, MimdbTableManager.getInstance());
        return ret;
    }

    public void create(QueryInfo info) throws Exception {
        if (info == null) {
            throw new MimdbException("QueryInfo\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.clear();
        this.info = info;
    }

    public void clear() {
        if (this.info != null) {
            this.info.clear();
            this.info = null;
        }
        this.compile = null;
        this.offset = -1;
        this.limit = -1;
    }

    public boolean isClear() {
        return this.info == null;
    }

    protected final void check() {
        if (this.info == null) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public String getName() {
        this.check();
        return this.info.name;
    }

    public QueryInfo getInfo() {
        this.check();
        return this.info;
    }

    public MimdbResult executeQuery() throws Exception {
        this.check();
        if (this.compile == null || this.compile.isClear()) {
            MimdbQueryPrepared c = new MimdbQueryPrepared();
            this.compile(c);
            if (c.getInfo().preparedParamsSize > 0) {
                throw new MimdbException("\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5fc5\u8981\u306a\u6761\u4ef6\u306a\u306e\u3067\u3001\u3053\u306e\u51e6\u7406\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093");
            }
            this.compile = c;
        }
        this.compile.setOffset(this.offset);
        this.compile.setLimit(this.limit);
        this.offset = -1;
        this.limit = -1;
        return this.compile.executeQuery();
    }

    public void clearOffset() {
        this.check();
        this.offset = -1;
        this.limit = -1;
    }

    public MimdbQuery setOffset(int off) {
        this.check();
        this.offset = off;
        return this;
    }

    public MimdbQuery setLimit(int limit) {
        this.check();
        this.limit = limit;
        return this;
    }

    public void compile(MimdbQueryPrepared out) throws Exception {
        this.check();
        QueryCompileInfo cinfo = new QueryCompileInfo();
        QueryCompile.compile(cinfo, this.info, MimdbTableManager.getInstance());
        out.create(cinfo);
    }

    public MimdbQueryPrepared compile() throws Exception {
        this.check();
        MimdbQueryPrepared ret = new MimdbQueryPrepared();
        this.compile(ret);
        return ret;
    }

    public MimdbQueryPrepared getCompile() {
        this.check();
        return this.compile;
    }
}

