/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.jdbc.MimdbJdbcConnection;

public class Driver
implements java.sql.Driver {
    private static final String HEAD_URL = "jdbc:mimdb:";
    private static final int HEAD_URL_LENGTH = "jdbc:mimdb:".length();
    private static final String EMBEDDED = "embedded";
    private static final String MEMORY = ":memory:";
    private static final String MEM = "memory";
    private static final Driver INSTANCE = new Driver();
    private static final AtomicNumber32 regFlag = new AtomicNumber32(0);

    static {
        try {
            Driver.load();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Driver() {
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String base = url;
        if (!this.acceptsURL(url)) {
            throw new SQLException("URL\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059:" + url);
        }
        url = url.substring(HEAD_URL_LENGTH).trim();
        try {
            return new MimdbJdbcConnection(Driver.getConnection(url, info));
        }
        catch (Exception e) {
            throw new SQLException("URL\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557:" + base, e);
        }
    }

    private static final MimdbConnection getConnection(String url, Properties info) throws Exception {
        String s = url.toLowerCase();
        if (EMBEDDED.equals(s) || MEMORY.equals(s) || MEM.equals(s)) {
            return MimdbConnection.create();
        }
        String addr = null;
        int port = -1;
        int p = url.indexOf(":");
        if (p == -1) {
            addr = url;
            port = -1;
        } else {
            addr = url.substring(0, p).trim();
            port = MimdbUtils.convertInt(url.substring(p + 1).trim());
        }
        int timeout = -1;
        if (info.get("timeout") != null) {
            timeout = MimdbUtils.convertInt(info.get("timeout"));
        }
        return MimdbConnection.create(timeout, addr, port);
    }

    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith(HEAD_URL);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static final void load() throws SQLException {
        int old = regFlag.setToBeforeReturn(1);
        if (old == 0) {
            try {
                DriverManager.registerDriver(INSTANCE);
            }
            catch (SQLException e) {
                regFlag.set(old);
                throw e;
            }
        }
    }

    public static final void unload() throws SQLException {
        int old = regFlag.setToBeforeReturn(0);
        if (old == 1) {
            try {
                DriverManager.deregisterDriver(INSTANCE);
                regFlag.set(0);
            }
            catch (SQLException e) {
                regFlag.set(old);
                throw e;
            }
        }
    }

    public static final boolean isRegister() {
        return regFlag.get() == 1;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

