package org.maachang.mimdb.core ;


/**
 * 非圧縮テーブル行データ.
 * 
 * @version 2013/10/14
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
public class MimdbRawRow extends MimdbRow implements Comparable<MimdbRawRow> {
    protected Object[] values ;
    
    /**
     * コンストラクタ.
     */
    private MimdbRawRow(){}
    
    /**
     * コンストラクタ.
     * @param table 対象テーブルを取得します.
     * @param no 行番号を設定します.
     * @param val １行データを設定します.
     */
    protected MimdbRawRow( MimdbTable table,int no,Object[] val ) {
        this.dbId = table.dbId ;
        this.baseTable = table ;
        this.lineNo = no ;
        this.values = val ;
    }
    
    /**
     * カラム項番で情報を取得.
     * @param n 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( int n ) {
        return values[ n ] ;
    }
    
    /**
     * カラム名で情報を取得.
     * @param name 対象の名前を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( String name ) {
        Integer n = baseTable.columnsMap.get( ((String)name).trim().toLowerCase() ) ;
        if( n == null ) {
            return null ;
        }
        return values[ n ] ;
    }
    
    /**
     * カラムオブジェクト一覧を取得.
     * @return Object[] カラムオブジェクト一覧が返却されます.
     */
    public Object[] getValues() {
        return values ;
    }
    
    /**
     * プライマリーキーオブジェクトを取得.
     * @return Object プライマリーキーオブジェクトが返却されます.
     */
    public Object getPrimaryKey() {
        return values[ baseTable.primaryIndexKeyNo ] ;
    }
    
    /**
     * 圧縮長を取得.
     * @return int 圧縮されたバイナリ長が返却されます.
     */
    public int compressLength() {
        return 0 ;
    }
    
    /**
     * 比較処理.
     * @param n 比較条件を設定します.
     * @return int 比較結果が返却されます.
     *            マイナスの場合、第一引数の方が大きい.
     *            プラスの場合、第一引数の方が小さい.
     *            0の場合、第一引数と同じ.
     */
    public int compareTo( MimdbRawRow n ) {
        if( baseTable.primaryIndexKeyNo == -1 ) {
            return 0 ;
        }
        // 主キーでは、NULL条件は有り得ないので、この条件でOK.
        return ((Comparable)values[ baseTable.primaryIndexKeyNo ]).
            compareTo( n.values[ baseTable.primaryIndexKeyNo ] ) ;
    }
}
