/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumberKeyValue<V> {
    private static final int DEF_LENGTH = 32;
    private NumberKeyValueChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private int pos = 0;
    private NumberKeyValueChild cPos = null;

    public NumberKeyValue() {
        this(32);
    }

    public NumberKeyValue(int size) {
        size = size <= 32 ? 32 : NumberKeySet.bitMask(size);
        this.list = new NumberKeyValueChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
    }

    public void clear() {
        this.list = new NumberKeyValueChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
    }

    public void put(int b, V o) {
        int h;
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            NumberKeyValueChild[] nList = new NumberKeyValueChild[nLen];
            int i = 0;
            while (i < this.limit) {
                NumberKeyValueChild n = this.list[i];
                while (n != null) {
                    NumberKeyValueChild t;
                    h = n.b & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
                ++i;
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = b & this.mask] == null) {
            this.list[h] = new NumberKeyValueChild(b, o);
            ++this.length;
        } else {
            NumberKeyValueChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b == b) {
                    nn.o = o;
                    return;
                }
                nn = nn.n;
            }
            if (nn.b == b) {
                nn.o = o;
            } else {
                nn.n = new NumberKeyValueChild(b, o);
                ++this.length;
            }
        }
    }

    public boolean containsKey(int b) {
        if (this.list[b & this.mask] != null) {
            NumberKeyValueChild n = this.list[b & this.mask];
            while (n != null) {
                if (n.b == b) {
                    return true;
                }
                n = n.n;
            }
        }
        return false;
    }

    public V get(int b) {
        if (this.list[b & this.mask] != null) {
            NumberKeyValueChild n = this.list[b & this.mask];
            while (n != null) {
                if (n.b == b) {
                    return (V)n.o;
                }
                n = n.n;
            }
        }
        return null;
    }

    public void remove(int b) {
        if (this.list[b & this.mask] != null) {
            NumberKeyValueChild bf = null;
            NumberKeyValueChild n = this.list[b & this.mask];
            while (n != null) {
                if (n.b == b) {
                    if (bf == null) {
                        this.list[b & this.mask] = n.n == null ? null : n.n;
                    } else {
                        bf.n = n.n == null ? null : n.n;
                    }
                    --this.length;
                    break;
                }
                bf = n;
                n = n.n;
            }
        }
    }

    public int size() {
        return this.length;
    }

    public int[] keyArray() {
        if (this.length <= 0) {
            return null;
        }
        int cnt = 0;
        int[] ret = new int[this.length];
        int i = 0;
        while (i < this.limit) {
            if (this.list[i] != null) {
                NumberKeyValueChild n = this.list[i];
                while (n != null) {
                    ret[cnt++] = n.b;
                    n = n.n;
                }
            }
            ++i;
        }
        return ret;
    }

    public NumberKeyValue<V> reset() {
        this.pos = 0;
        this.cPos = null;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (this.cPos == null || (this.cPos = this.cPos.n) == null) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            return true;
lbl5:
            // 2 sources

            ** while (this.pos < this.limit)
        }
lbl6:
        // 1 sources

        return false;
    }

    public int next() {
        if (this.cPos == null) {
            return -1;
        }
        return this.cPos.b;
    }

    private static final class NumberKeyValueChild {
        int b;
        Object o;
        NumberKeyValueChild n;

        NumberKeyValueChild(int k, Object v) {
            this.b = k;
            this.o = v;
        }
    }
}

