package org.maachang.mimdb.core.util ;

/**
 * Stack情報.
 * 
 * @version 2013/10/13
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class Stack<T> {
    private StackInfoChild<T> cell = null ;
    private int count = 0 ;
    
    private static final class StackInfoChild<T> {
        T object = null ;
        StackInfoChild<T> next = null ;
    }
    
    public Stack() {}
    
    public void clear() {
        this.cell = null ;
    }
    
    public void push(T object) {
        StackInfoChild<T> nw = new StackInfoChild<T>();
        nw.object = object;
        nw.next = this.cell;
        this.cell = nw;
        count ++ ;
    }
    
    public T pop() {
        if( this.cell == null ) {
            return null ;
        }
        T ret = cell.object ;
        this.cell = this.cell.next ;
        count -- ;
        return ret ;
    }
    
    public T peek() {
        if( this.cell == null ) {
            return null ;
        }
        return this.cell.object ;
    }
    
    public int size() {
        return count ;
    }
}
