package org.maachang.mimdb.core.util ;

/**
 * 数字KeyValue.
 * 
 * @version 2013/10/29
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
public final class NumberKeyValue<V> {
    private static final int DEF_LENGTH = 32 ;
    
    private static final class NumberKeyValueChild {
        int b ;
        Object o ;
        NumberKeyValueChild n ;
        NumberKeyValueChild( int k,Object v ) {
            b = k ; o = v ;
        }
    }
    
    private NumberKeyValueChild[] list ;
    private int mask ;
    private int length ;
    private int limit ;
    private int base ;
    
    /**
     * コンストラクタ.
     */
    public NumberKeyValue() {
        this( DEF_LENGTH ) ;
    }
    
    /**
     * コンストラクタ.
     * @param size 初期サイズを設定します.この条件は２の倍数である必要があります.
     */
    public NumberKeyValue( int size ) {
        if( size <= DEF_LENGTH ) {
            size = DEF_LENGTH ;
        }
        else {
            size = NumberKeySet.bitMask( size ) ;
        }
        list = new NumberKeyValueChild[ size ] ;
        length = 0 ;
        mask = size - 1 ;
        limit = size ;
        base = size ;
    }
    
    /**
     * クリア.
     */
    public void clear() {
        list = new NumberKeyValueChild[ base ] ;
        length = 0 ;
        mask = base - 1 ;
        limit = base ;
    }
    
    /**
     * 数値追加.
     * @param b 対象の数値を設定します.
     * @param o 対象の要素を設定します.
     */
    public void put( int b,V o ) {
        int h ;
        if( length + 1 >= limit ) {
            int nLen = limit << 1 ;
            int msk = nLen - 1 ;
            NumberKeyValueChild[] nList = new NumberKeyValueChild[ nLen ] ;
            NumberKeyValueChild n,t ;
            for( int i = 0 ; i < limit ; i ++ ) {
                n = list[ i ] ;
                while( n != null ) {
                    if( nList[ ( h = n.b & msk ) ] == null ) {
                        t = n.n ;
                        n.n = null ;
                    }
                    else {
                        t = n.n ;
                        n.n = nList[ h ] ;
                    }
                    nList[ h ] = n ;
                    n = t ;
                }
            }
            list = nList ;
            limit = nLen ;
            mask = msk ;
        }
        if( list[ ( h = b & mask ) ] == null ) {
            list[ h ] = new NumberKeyValueChild( b,o ) ;
            length ++ ;
        }
        else {
            NumberKeyValueChild nn = list[ h ] ;
            while( nn.n != null ) {
                if( nn.b == b ) {
                    nn.o = o ;
                    return ;
                }
                nn = nn.n ;
            }
            if( nn.b == b ) {
                nn.o = o ;
            }
            else {
                nn.n = new NumberKeyValueChild( b,o ) ;
                length ++ ;
            }
        }
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象の数値を設定します.
     * @return boolean [true]の場合、数値は存在します.
     */
    public boolean containsKey( int b ) {
        if( list[ b & mask ] != null ) {
            NumberKeyValueChild n = list[ b & mask ] ;
            while( n != null ) {
                if( n.b == b ) {
                    return true ;
                }
                n = n.n ;
            }
        }
        return false ;
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象の数値を設定します.
     * @return V 要素情報が返却されます.
     */
    public V get( int b ) {
        if( list[ b & mask ] != null ) {
            NumberKeyValueChild n = list[ b & mask ] ;
            while( n != null ) {
                if( n.b == b ) {
                    return (V)n.o ;
                }
                n = n.n ;
            }
        }
        return null ;
    }
    
    /**
     * 削除処理.
     * @param b 対象の数値を設定します.
     */
    public void remove( int b ) {
        if( list[ b & mask ] != null ) {
            NumberKeyValueChild bf = null ;
            NumberKeyValueChild n = list[ b & mask ] ;
            while( n != null ) {
                if( n.b == b ) {
                    if( bf == null ) {
                        if( n.n == null ) {
                            list[ b & mask ] = null ;
                        }
                        else {
                            list[ b & mask ] = n.n ;
                        }
                    }
                    else {
                        if( n.n == null ) {
                            bf.n = null ;
                        }
                        else {
                            bf.n = n.n ;
                        }
                    }
                    length -- ;
                    break ;
                }
                bf = n ;
                n = n.n ;
            }
        }
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return length ;
    }
    
    /**
     * 数値配列として返却.
     * @return int[] 数値配列として返却します.
     */
    public int[] keyArray() {
        if( length <= 0 ) {
            return null ;
        }
        NumberKeyValueChild n ;
        int cnt = 0 ;
        int[] ret = new int[ length ] ;
        for( int i = 0 ; i < limit ; i ++ ) {
            if( list[ i ] != null ) {
                n = list[ i ] ;
                while( n != null ) {
                    ret[ cnt ++ ] = n.b ;
                    n = n.n ;
                }
            }
        }
        return ret ;
    }
    
    /** 位置読み込み条件. **/
    private int pos = 0 ;
    private NumberKeyValueChild cPos = null ;
    
    /**
     * 読み込み中の位置をリセット.
     * @return NumberKeyValue このオブジェクトが返却されます.
     */
    public NumberKeyValue<V> reset() {
        pos = 0 ;
        cPos = null ;
        return this ;
    }
    
    /**
     * 次の読み込み条件を取得.
     * @return boolean [true]が返却された場合、情報は存在します.
     */
    public boolean hasNext() {
        if( cPos != null ) {
            if( ( cPos = cPos.n ) != null ) {
                return true ;
            }
        }
        while( pos < limit ) {
            if( ( cPos = list[ pos ++ ] ) != null ) {
                return true ;
            }
        }
        return false ;
    }
    
    /**
     * 現在の読み込み位置の情報を取得.
     * @return int 現在の読み込み位置の内容が返却されます.
     *             [-1]の場合は、情報は存在しません.
     */
    public int next() {
        if( cPos == null ) {
            return -1 ;
        }
        return cPos.b ;
    }
}
