package org.maachang.mimdb.core.util ;

/**
 * オブジェクトKeySet.
 * このオブジェクトはNULL禁止です.
 * 
 * @version 2013/10/29
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
public final class NNObjectKeySet<T> {
    private static final int DEF_LENGTH = 32 ;
    
    private static final class NNObjectKeyChild {
        Object b ;
        NNObjectKeyChild n ;
        NNObjectKeyChild( Object v ) {
            b = v ;
        }
    }
    
    private NNObjectKeyChild[] list ;
    private int mask ;
    private int length ;
    private int limit ;
    private int base ;
    
    /**
     * コンストラクタ.
     */
    public NNObjectKeySet() {
        this( DEF_LENGTH ) ;
    }
    
    /**
     * コンストラクタ.
     * @param size 初期サイズを設定します.この条件は２の倍数である必要があります.
     */
    public NNObjectKeySet( int size ) {
        if( size <= DEF_LENGTH ) {
            size = DEF_LENGTH ;
        }
        else {
            size = NumberKeySet.bitMask( size ) ;
        }
        list = new NNObjectKeyChild[ size ] ;
        length = 0 ;
        mask = size - 1 ;
        limit = size ;
        base = size ;
    }
    
    /**
     * クリア.
     */
    public void clear() {
        list = new NNObjectKeyChild[ base ] ;
        length = 0 ;
        mask = base - 1 ;
        limit = base ;
    }
    
    /**
     * 数値追加.
     * @param b 対象の数値を設定します.
     */
    public void add( T b ) {
        if( b == null ) {
            throw new RuntimeException( "このオブジェクトはNULL禁止です" ) ;
        }
        int h,bh ;
        if( length + 1 >= limit ) {
            int nLen = limit << 1 ;
            int msk = nLen - 1 ;
            NNObjectKeyChild[] nList = new NNObjectKeyChild[ nLen ] ;
            NNObjectKeyChild n,t ;
            for( int i = 0 ; i < limit ; i ++ ) {
                n = list[ i ] ;
                while( n != null ) {
                    if( nList[ ( h = n.b.hashCode() & msk ) ] == null ) {
                        t = n.n ;
                        n.n = null ;
                    }
                    else {
                        t = n.n ;
                        n.n = nList[ h ] ;
                    }
                    nList[ h ] = n ;
                    n = t ;
                }
            }
            list = nList ;
            limit = nLen ;
            mask = msk ;
        }
        bh = b.hashCode() ;
        if( list[ ( h = bh & mask ) ] == null ) {
            list[ h ] = new NNObjectKeyChild( b ) ;
            length ++ ;
        }
        else {
            NNObjectKeyChild nn = list[ h ] ;
            while( nn.n != null ) {
                if( nn.b.hashCode() == bh && ( nn.b == b || nn.b.equals( b ) ) ) {
                    return ;
                }
                nn = nn.n ;
            }
            if( nn.b.hashCode() != bh || nn.b != b || !nn.b.equals( b ) ) {
                nn.n = new NNObjectKeyChild( b ) ;
                length ++ ;
            }
        }
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象の数値を設定します.
     * @return boolean [true]の場合、数値は存在します.
     */
    public boolean contains( T b ) {
        if( b == null ) {
            return false ;
        }
        int bh = b.hashCode() ;
        NNObjectKeyChild n = list[ bh & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == bh && ( n.b == b || n.b.equals( b ) ) ) {
                return true ;
            }
            n = n.n ;
        }
        return false ;
    }
    
    /**
     * 削除処理.
     * @param b 対象のキーを設定します.
     */
    public void remove( Object b ) {
        if( b == null ) {
            return ;
        }
        int bh = b.hashCode() ;
        NNObjectKeyChild bf = null ;
        NNObjectKeyChild n = list[ bh & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == bh && ( n.b == b || n.b.equals( b ) ) ) {
                if( bf == null ) {
                    if( n.n == null ) {
                        list[ bh & mask ] = null ;
                    }
                    else {
                        list[ bh & mask ] = n.n ;
                    }
                }
                else {
                    if( n.n == null ) {
                        bf.n = null ;
                    }
                    else {
                        bf.n = n.n ;
                    }
                }
                length -- ;
                break ;
            }
            bf = n ;
            n = n.n ;
        }
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return length ;
    }
    
    /**
     * 配列として返却.
     * @return Object[] 配列として返却します.
     */
    public Object[] array() {
        if( size() == 0 ) {
            return null ;
        }
        NNObjectKeyChild n ;
        int cnt ;
        Object[] ret ;
        ret = new Object[ length ] ;
        cnt = 0 ;
        for( int i = 0 ; i < limit ; i ++ ) {
            if( list[ i ] != null ) {
                n = list[ i ] ;
                while( n != null ) {
                    ret[ cnt ++ ] = n.b ;
                    n = n.n ;
                }
            }
        }
        return ret ;
    }
    
    /** 位置読み込み条件. **/
    private int pos = 0 ;
    private NNObjectKeyChild cPos = null ;
    private int count = 0 ;
    
    /**
     * 読み込み中の位置をリセット.
     * @return NNObjectKeySet このオブジェクトが返却されます.
     */
    public NNObjectKeySet<T> reset() {
        pos = 0 ;
        cPos = null ;
        count = 0 ;
        return this ;
    }
    
    /**
     * 次の読み込み条件を取得.
     * @return boolean [true]が返却された場合、情報は存在します.
     */
    public boolean hasNext() {
        if( cPos != null ) {
            if( ( cPos = cPos.n ) != null ) {
                count ++ ;
                return true ;
            }
        }
        while( pos < limit ) {
            if( ( cPos = list[ pos ++ ] ) != null ) {
                count ++ ;
                return true ;
            }
        }
        return false ;
    }
    
    /**
     * 現在の読み込み位置の情報を取得.
     * @return Object 現在の読み込み位置の内容が返却されます.
     *                 [null]の場合は、情報は存在しません.
     */
    public T next() {
        if( cPos == null ) {
            return null ;
        }
        return (T)cPos.b ;
    }
    
    /**
     * カウントを取得.
     * @return int 現在読み込み中の位置が返却されます.
     */
    public int count() {
        return count ;
    }
}
