package org.maachang.mimdb.core;

/**
 * 検索条件.
 * 
 * @version 2013/10/07
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class MimdbSearchType {
    private MimdbSearchType(){}
    
    /**
     * 検索タイプ : =
     */
    public static final int TYPE_EQ = 1 ;
    
    /**
     * 検索タイプ : !=
     */
    public static final int TYPE_NEQ = 2 ;
    
    /**
     * 検索タイプ : >
     */
    public static final int TYPE_LBIG = 3 ;
    
    /**
     * 検索タイプ : >=
     */
    public static final int TYPE_LEQBIG = 4 ;
    
    /**
     * 検索タイプ : <
     */
    public static final int TYPE_RBIG = 5 ;
    
    /**
     * 検索タイプ : <=
     */
    public static final int TYPE_REQBIG = 6 ;
    
    /**
     * 検索タイプ : IN.
     */
    public static final int TYPE_IN = 7 ;
    
    /**
     * 検索タイプ : LIKE.
     */
    public static final int TYPE_LIKE = 8 ;
    
    /**
     * 検索条件 : ( 
     */
    public static final int PAR_START = 10 ;
    
    /**
     * 検索条件 : ) 
     */
    public static final int PAR_END = 11 ;
    
    /**
     * 検索連結 and.
     */
    public static final int AND = 20 ;
    
    /**
     * 検索連結 or.
     */
    public static final int OR = 21 ;
    
    /**
     * オフセット、リミット条件.
     */
    public static final int OFF_LIMIT = 30 ;
    
    
}
