package org.maachang.mimdb.core;


/**
 * インデックス情報.
 * 
 * @version 2013/10/07
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface MimdbIndex extends MimdbBase {
    
    /**
     * カラム要素型 : BOOLEAN.
     */
    public static final int COLUMN_BOOL = 1 ;
    
    /**
     * カラム要素型 : 数字(32bit).
     */
    public static final int COLUMN_INT = 2 ;
    
    /**
     * カラム要素型 : 数字(64bit).
     */
    public static final int COLUMN_LONG = 3 ;
    
    /**
     * カラム要素型 : 数字(浮動小数点).
     */
    public static final int COLUMN_FLOAT = 4 ;
    
    /**
     * カラム要素型 : 文字.
     */
    public static final int COLUMN_STRING = 5 ;
    
    /**
     * カラム要素型 : Timestamp.
     */
    public static final int COLUMN_TIMESTAMP = 6 ;
    
    /**
     * カラム要素型 : Date.
     */
    public static final int COLUMN_DATE = 7 ;
    
    /**
     * カラム要素型 : Time
     */
    public static final int COLUMN_TIME = 8 ;
    
    /**
     * インデックス化されているかチェック.
     * @return boolean [true]の場合、インデックス化されています.
     */
    public boolean isIndex() ;
    
    /**
     * インデックス化をクリア.
     */
    public void clear() ;
    
    /**
     * インデックスの生成.
     * @exception Exception 例外.
     */
    public void createIndex() throws Exception ;
    
    /**
     * 検索処理.
     * @param info 検索条件を設定します.
     * @return MimdbMiddleSearch 検索結果が返却されます.
     * @exception Exception 例外.
     */
    public MimdbMiddleSearch search( MimdbSearchElement info )
        throws Exception ;
    
    /**
     * AND検索処理.
     * @param info 検索条件を設定します.
     * @param and アンド検索条件元を設定します.
     * @return MimdbMiddleSearch 検索結果が返却されます.
     * @exception Exception 例外.
     */
    public MimdbMiddleSearch and( MimdbSearchElement info,MimdbMiddleSearch and )
        throws Exception ;
    
    /**
     * OR検索処理.
     * @param info 検索条件を設定します.
     * @param or オア検索条件元を設定します.
     * @return MimdbMiddleSearch 検索結果が返却されます.
     * @exception Exception 例外.
     */
    public MimdbMiddleSearch or( MimdbSearchElement info,MimdbMiddleSearch or )
        throws Exception ;
    
    /**
     * ソート順条件を取得.
     * @return int[] ソート順の条件が返却されます.
     */
    public int[] getSortNoList() ;
    
    /**
     * インデックス数を取得.
     * @return int インデックス数が返却されます.
     */
    public int getIndexSize() ;
    
    /**
     * カラム名を取得.
     * @return String カラム名が返却されます.
     */
    public String getName() ;
    
    /**
     * カラムタイプを取得.
     * @return int カラムタイプが返却されます.
     */
    public int getType() ;
    
    /**
     * DBカラムタイプを取得.
     * @return int DBカラムタイプ(java.sql.Types)が返却されます.
     */
    public int getDBType() ;
    
    /**
     * NGramインデックスかチェック.
     * @return boolean [true]の場合、NGramインデックスです.
     */
    public boolean isNGram() ;
    
}

