package org.maachang.mimdb.core ;


/**
 * カウント結果メタデータ.
 * 
 * @version 2013/10/28
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
class CountMetaDataImpl implements MimdbMetaData {
    protected static final String COLUMN_NAME = "count" ;
    
    /** 親オブジェクト. **/
    ResultImpl parent ;
    
    /**
     * コンストラクタ.
     */
    public CountMetaDataImpl() {}
    
    /**
     * コンストラクタ.
     * @param parent ResultImplを設定します.
     */
    public CountMetaDataImpl( ResultImpl parent ) {
        create( parent ) ;
    }
    
    /**
     * 情報生成.
     * @param parent ResultImplを設定します.
     */
    public void create( ResultImpl parent ) {
        this.parent = parent ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.parent = null ;
    }
    
    /**
     * 更新IDを取得.
     * @return long 更新IDが返却されます.
     */
    public long getDbId() {
        return parent.dbId ;
    }
    
    /**
     * テーブル名の取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() {
        return parent.table.name ;
    }
    
    /**
     * テーブル情報の取得.
     * @return MimdbTable テーブル情報が返却されます.
     */
    public MimdbTable getTable() {
        return parent.table ;
    }
    
    /**
     * カラム数の取得.
     * @return int カラム数が返却されます.
     */
    public int getColumnSize() {
        return 1 ;
    }
    
    /**
     * カラム名を取得.
     * @param no カラム項番を設定します.
     * @return String カラム名が返却されます.
     */
    public String getColumnName( int no ) {
        if( no != 0 ) {
            return null ;
        }
        return COLUMN_NAME ;
    }
    
    /**
     * 指定カラム名に対する項番を取得.
     * @param name カラム名を設定します.
     * @return int カラム項番が返却されます.
     *             [-1]の場合は対象カラム名は存在しません.
     */
    public int getColumnNameByNo( String name ) {
        if( COLUMN_NAME.equals( name.trim().toLowerCase() ) ) {
            return 0 ;
        }
        return -1 ;
    }
    
    /**
     * カラムタイプを取得.
     * @param no カラム項番を設定します.
     * @return int カラムタイプが返却されます.
     *             -1が返却された場合は、対象カラムは存在しません.
     * java.lang.Boolean  : MimdbIndex.COLUMN_BOOL
     * java.lang.Integer  : MimdbIndex.COLUMN_INT
     * java.lang.Long     : MimdbIndex.COLUMN_LONG
     * java.lang.Double   : MimdbIndex.COLUMN_FLOAT
     * java.lang.String   : MimdbIndex.COLUMN_STRING
     * java.sql.Date      : MimdbIndex.COLUMN_DATE
     * java.sql.Time      : MimdbIndex.COLUMN_TIME
     * java.sql.Timestamp : MimdbIndex.COLUMN_TIMESTAMP
     * java.util.Date     : MimdbIndex.COLUMN_DATE
     */
    public int getColumnType( int no ) {
        if( no != 0 ) {
            return -1 ;
        }
        return MimdbIndex.COLUMN_INT ;
    }
    
    /**
     * カラムタイプを取得.
     * @param name 対象のカラム名を設定します.
     * @return int カラムタイプが返却されます.
     *             -1が返却された場合は、対象カラムは存在しません.
     * java.lang.Boolean  : MimdbIndex.COLUMN_BOOL
     * java.lang.Integer  : MimdbIndex.COLUMN_INT
     * java.lang.Long     : MimdbIndex.COLUMN_LONG
     * java.lang.Double   : MimdbIndex.COLUMN_FLOAT
     * java.lang.String   : MimdbIndex.COLUMN_STRING
     * java.sql.Date      : MimdbIndex.COLUMN_DATE
     * java.sql.Time      : MimdbIndex.COLUMN_TIME
     * java.sql.Timestamp : MimdbIndex.COLUMN_TIMESTAMP
     * java.util.Date     : MimdbIndex.COLUMN_DATE
     */
    public int getColumnType( String name ) {
        if( COLUMN_NAME.equals( name.trim().toLowerCase() ) ) {
            return MimdbIndex.COLUMN_INT ;
        }
        return -1 ;
    }
}
