/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSetMetaData;
import org.maachang.mimdb.jdbc.MimdbJdbcStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimdbJdbcResultSet
implements ResultSet {
    private MimdbJdbcStatement statement = null;
    private String name;
    private boolean wasNullFlag = false;
    private MimdbResultRow line = null;

    protected MimdbJdbcResultSet(MimdbJdbcStatement st) {
        this.statement = st;
        this.name = st.result.getMetaData().getName();
    }

    @Override
    public void close() throws SQLException {
        this.statement.result = null;
        this.line = null;
        this.wasNullFlag = false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.result == null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.check();
        return new MimdbJdbcResultSetMetaData(this.statement.result);
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (row < 0) {
                if (row < -1) {
                    return this.statement.result.absolute(this.statement.result.length() + (row * -1 - 1));
                }
                row = this.statement.result.length() - 1;
            }
            if (this.statement.result.absolute(row)) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            this.statement.result.absolute(this.statement.result.length());
        }
        catch (Exception e) {
            this.errorsql(e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            this.statement.result.absolute(-1);
        }
        catch (Exception e) {
            this.errorsql(e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (this.statement.result.first()) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (this.statement.result.last()) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (this.statement.result.next()) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (this.statement.result.absolute(this.statement.result.getRow() - 1)) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.check();
        try {
            this.line = null;
            this.wasNullFlag = false;
            if (this.statement.result.absolute(this.statement.result.getRow() + rows)) {
                this.line = this.statement.result.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.errorsql(e);
            return false;
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.check();
        return this.statement.result.getRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.check();
        return this.statement.result.getRow() > this.statement.result.length();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.check();
        return this.statement.result.getRow() < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.check();
        return this.statement.result.getRow() == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.check();
        return this.statement.result.getRow() == this.statement.result.length();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.check();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.check();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.check();
        return -1;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.check();
        Object value = this.getValue(columnIndex - 1);
        return value == null ? null : value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.check();
        Object value = this.getValue(columnLabel);
        return value == null ? null : value;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.check();
        if (this.isBool(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? false : (Boolean)value;
        }
        this.errorsql("Boolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return false;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.check();
        if (this.isBool(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? false : (Boolean)value;
        }
        this.errorsql("Boolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? (byte)0 : ((Number)value).byteValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? (byte)0 : ((Number)value).byteValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? (short)0 : ((Number)value).shortValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? (short)0 : ((Number)value).shortValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? 0 : ((Number)value).intValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? 0 : ((Number)value).intValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? 0L : ((Number)value).longValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0L;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? 0L : ((Number)value).longValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? 0.0f : ((Number)value).floatValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0.0f;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? 0.0f : ((Number)value).floatValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? 0.0 : ((Number)value).doubleValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return 0.0;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? 0.0 : ((Number)value).doubleValue();
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : new BigDecimal(value.toString());
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.check();
        if (this.isNumber(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : new BigDecimal(new BigInteger(String.valueOf(((Number)value).intValue())), scale);
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : new BigDecimal(value.toString());
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.check();
        if (this.isNumber(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : new BigDecimal(new BigInteger(String.valueOf(((Number)value).intValue())), scale);
        }
        this.errorsql("\u6570\u5b57\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Date)MimdbJdbcResultSet.convertDate(7, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Date)MimdbJdbcResultSet.convertDate(7, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Date)MimdbJdbcResultSet.convertDate(7, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Date)MimdbJdbcResultSet.convertDate(7, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Time)MimdbJdbcResultSet.convertDate(8, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Time)MimdbJdbcResultSet.convertDate(8, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Time)MimdbJdbcResultSet.convertDate(8, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Time)MimdbJdbcResultSet.convertDate(8, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Timestamp)MimdbJdbcResultSet.convertDate(6, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (Timestamp)MimdbJdbcResultSet.convertDate(6, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Timestamp)MimdbJdbcResultSet.convertDate(6, (java.util.Date)value, null);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.check();
        if (this.isDate(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (Timestamp)MimdbJdbcResultSet.convertDate(6, (java.util.Date)value, cal);
        }
        this.errorsql("\u65e5\u4ed8/\u6642\u9593\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.check();
        if (this.isString(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (String)value;
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.check();
        if (this.isString(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (String)value;
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.check();
        if (this.isString(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            return value == null ? null : (String)value;
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.check();
        if (this.isString(columnLabel)) {
            Object value = this.getValue(columnLabel);
            return value == null ? null : (String)value;
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.check();
        if (this.isString(columnIndex - 1)) {
            Object value = this.getValue(columnIndex - 1);
            try {
                return value == null ? null : new URL((String)value);
            }
            catch (Exception e) {
                this.errorsql(e);
            }
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnIndex);
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.check();
        if (this.isString(columnLabel)) {
            Object value = this.getValue(columnLabel);
            try {
                return value == null ? null : new URL((String)value);
            }
            catch (Exception e) {
                this.errorsql(e);
            }
        }
        this.errorsql("String\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + columnLabel);
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.check();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.check();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.check();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.check();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.check();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.check();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.check();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.check();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.check();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void updateRow() throws SQLException {
        this.check();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.check();
        return this.wasNullFlag;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private final void errorsql(String msg) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name + " " + msg);
    }

    private final void errorsql(Exception e) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name, e);
    }

    private final void check() throws SQLException {
        if (this.statement.result == null) {
            this.errorsql("ResultSet\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    private final Object getValue(int no) throws SQLException {
        if (this.line == null) {
            this.errorsql("\u60c5\u5831\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.line.getValue(no) == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        return this.line.getValue(no);
    }

    private final Object getValue(String name) throws SQLException {
        if (this.line == null) {
            this.errorsql("\u60c5\u5831\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.line.get(name) == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        return this.line.get(name);
    }

    private final boolean isNumber(int no) {
        switch (this.statement.result.getMetaData().getColumnType(no)) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final boolean isNumber(String column) {
        switch (this.statement.result.getMetaData().getColumnType(column)) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final boolean isString(int no) {
        return this.statement.result.getMetaData().getColumnType(no) == 5;
    }

    private final boolean isString(String column) {
        return this.statement.result.getMetaData().getColumnType(column) == 5;
    }

    private final boolean isBool(int no) {
        return this.statement.result.getMetaData().getColumnType(no) == 1;
    }

    private final boolean isBool(String column) {
        return this.statement.result.getMetaData().getColumnType(column) == 1;
    }

    private final boolean isDate(int no) {
        switch (this.statement.result.getMetaData().getColumnType(no)) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private final boolean isDate(String column) {
        switch (this.statement.result.getMetaData().getColumnType(column)) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected static final java.util.Date convertDate(int mode, java.util.Date date, Calendar calendar) {
        if (calendar == null) {
            switch (mode) {
                case 7: {
                    return new Date(date.getTime());
                }
                case 8: {
                    return new Time(date.getTime());
                }
                case 6: {
                    return new Timestamp(date.getTime());
                }
            }
        }
        calendar.setTimeInMillis(date.getTime());
        switch (mode) {
            case 7: {
                return new Date(calendar.get(1), calendar.get(2), calendar.get(5));
            }
            case 8: {
                return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
            }
            case 6: {
                return new Timestamp(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), 0);
            }
        }
        return null;
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        return null;
    }
}

