/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util.jsnappy;

import java.io.IOException;
import org.maachang.mimdb.core.util.jsnappy.JSnappyBuffer;

public class JSnappy {
    private static final int LIMIT = 64;
    private static final int DEF_SHIFT = 0;
    private static final int HASH = 506832829;
    private static final byte b60 = -16;
    private static final byte b61 = -12;
    private static final byte b62 = -8;
    private static final byte b63 = -4;

    public static final int calcMaxCompressLength(int len) {
        return 32 + len + len / 6;
    }

    public static final int decompressLength(byte[] binary, int off) {
        int ret = 0;
        int i = 0;
        do {
            ret += (binary[off] & 0x7F) << i++ * 7;
        } while ((binary[off++] & 0x80) == 128);
        return ret;
    }

    public static final JSnappyBuffer compress(byte[] in) throws Exception {
        return JSnappy.compress(in, 0, in.length, null, 0);
    }

    public static final JSnappyBuffer compress(byte[] in, JSnappyBuffer out) throws Exception {
        return JSnappy.compress(in, 0, in.length, out, 0);
    }

    public static final JSnappyBuffer compress(byte[] in, int offset, int length) throws Exception {
        return JSnappy.compress(in, offset, length, null, 0);
    }

    public static final JSnappyBuffer compress(JSnappyBuffer in) throws Exception {
        return JSnappy.compress(in.getData(), 0, in.getLength(), null, 0);
    }

    public static final JSnappyBuffer compress(JSnappyBuffer in, JSnappyBuffer out) throws Exception {
        return JSnappy.compress(in.getData(), 0, in.getLength(), out, 0);
    }

    public static final JSnappyBuffer decompress(byte[] in) throws Exception {
        return JSnappy.decompress(in, 0, in.length, null);
    }

    public static final JSnappyBuffer decompress(byte[] in, JSnappyBuffer out) throws Exception {
        return JSnappy.decompress(in, 0, in.length, out);
    }

    public static final JSnappyBuffer decompress(byte[] in, int offset, int length) throws Exception {
        return JSnappy.decompress(in, offset, length, null);
    }

    public static final JSnappyBuffer decompress(JSnappyBuffer in) throws Exception {
        return JSnappy.decompress(in.getData(), 0, in.getLength());
    }

    public static final JSnappyBuffer decompress(JSnappyBuffer in, JSnappyBuffer out) throws Exception {
        return JSnappy.decompress(in.getData(), 0, in.getLength(), out);
    }

    public static final JSnappyBuffer compress(byte[] in, int offset, int length, JSnappyBuffer out, int shift) throws Exception {
        int len;
        int lenM4 = length - 4;
        int offLenM4 = lenM4 + offset;
        int offLen = offset + length;
        int hOff = 0;
        int hLen = 0;
        int hashShift = JSnappy.nlzs(length);
        if (hashShift > 16) {
            hashShift = 31 - hashShift;
        }
        if (out == null) {
            out = new JSnappyBuffer(JSnappy.calcMaxCompressLength(length));
        } else {
            out.clear(JSnappy.calcMaxCompressLength(length));
        }
        byte[] target = out.getData();
        int targetIndex = 0;
        int n = length;
        while (n > 0) {
            target[targetIndex++] = n >= 128 ? (byte)(0x80 | n & 0x7F) : (byte)n;
            n >>= 7;
        }
        int _msk = (JSnappy.bitMask(length / 6) << shift) - 1;
        int[] _cc = new int[_msk + 1];
        int iLen = offLenM4 < offset + 4 ? offLenM4 : offset + 4;
        int i = offset;
        while (i < iLen) {
            _cc[((in[i] & 0xFF) << 24 | (in[i + 1] & 0xFF) << 16 | (in[i + 2] & 0xFF) << 8 | in[i + 3] & 0xFF) * 506832829 >> hashShift & _msk] = i;
            ++i;
        }
        int lastHit = offset;
        int i2 = offset + 4;
        while (i2 < offLenM4) {
            n = (in[i2] & 0xFF) << 24 | (in[i2 + 1] & 0xFF) << 16 | (in[i2 + 2] & 0xFF) << 8 | in[i2 + 3] & 0xFF;
            int fp = _cc[n * 506832829 >> hashShift & _msk];
            if (n != ((in[fp] & 0xFF) << 24 | (in[fp + 1] & 0xFF) << 16 | (in[fp + 2] & 0xFF) << 8 | in[fp + 3] & 0xFF) || fp + 4 >= i2 || i2 + 4 >= offLen) {
                _cc[n * 506832829 >> hashShift & _msk] = i2;
            } else {
                int tLen;
                if (in[fp + 4] == in[i2 + 4]) {
                    hLen = 5;
                    int o = fp + 5;
                    int io = i2 + 5;
                    tLen = io + 64 < offLen ? (o + 64 < i2 ? 64 : i2 - o) : offLen - io;
                    while (hLen < tLen && in[o++] == in[io++]) {
                        ++hLen;
                    }
                } else {
                    hLen = 4;
                }
                hOff = i2 - fp;
                _cc[n * 506832829 >> hashShift & _msk] = i2;
                if (lastHit < i2) {
                    len = i2 - lastHit - 1;
                    if (len < 60) {
                        target[targetIndex++] = (byte)(len << 2);
                    } else if (len < 256) {
                        target[targetIndex] = -16;
                        target[targetIndex + 1] = (byte)len;
                        targetIndex += 2;
                    } else if (len < 65536) {
                        target[targetIndex] = -12;
                        target[targetIndex + 1] = (byte)len;
                        target[targetIndex + 2] = (byte)(len >> 8);
                        targetIndex += 3;
                    } else if (len < 0x1000000) {
                        target[targetIndex] = -8;
                        target[targetIndex + 1] = (byte)len;
                        target[targetIndex + 2] = (byte)(len >> 8);
                        target[targetIndex + 3] = (byte)(len >> 16);
                        targetIndex += 4;
                    } else {
                        target[targetIndex] = -4;
                        target[targetIndex + 1] = (byte)len;
                        target[targetIndex + 2] = (byte)(len >> 8);
                        target[targetIndex + 3] = (byte)(len >> 16);
                        target[targetIndex + 4] = (byte)(len >> 24);
                        targetIndex += 5;
                    }
                    System.arraycopy(in, lastHit, target, targetIndex, len + 1);
                    targetIndex += len + 1;
                    lastHit = i2;
                }
                if (hLen <= 11 && hOff < 2048) {
                    target[targetIndex] = (byte)(1 | hLen - 4 << 2 | hOff >> 3 & 0xE0);
                    target[targetIndex + 1] = (byte)(hOff & 0xFF);
                    targetIndex += 2;
                } else if (hOff < 65536) {
                    target[targetIndex] = (byte)(2 | hLen - 1 << 2);
                    target[targetIndex + 1] = (byte)hOff;
                    target[targetIndex + 2] = (byte)(hOff >> 8);
                    targetIndex += 3;
                } else {
                    target[targetIndex] = (byte)(3 | hLen - 1 << 2);
                    target[targetIndex + 1] = (byte)hOff;
                    target[targetIndex + 2] = (byte)(hOff >> 8);
                    target[targetIndex + 3] = (byte)(hOff >> 16);
                    target[targetIndex + 4] = (byte)(hOff >> 24);
                    targetIndex += 5;
                }
                tLen = lastHit > offLenM4 ? offLenM4 : lastHit;
                while (i2 < tLen) {
                    _cc[((in[i2] & 0xFF) << 24 | (in[i2 + 1] & 0xFF) << 16 | (in[i2 + 2] & 0xFF) << 8 | in[i2 + 3] & 0xFF) * 506832829 >> hashShift & _msk] = i2;
                    ++i2;
                }
                lastHit = i2 + hLen;
                tLen = lastHit - 1 > offLenM4 ? offLenM4 : lastHit - 1;
                while (i2 < tLen) {
                    _cc[((in[i2] & 0xFF) << 24 | (in[i2 + 1] & 0xFF) << 16 | (in[i2 + 2] & 0xFF) << 8 | in[i2 + 3] & 0xFF) * 506832829 >> hashShift & _msk] = i2;
                    ++i2;
                }
                i2 = lastHit - 1;
            }
            ++i2;
        }
        if (lastHit < offLen) {
            len = offLen - lastHit - 1;
            if (len < 60) {
                target[targetIndex++] = (byte)(len << 2);
            } else if (len < 256) {
                target[targetIndex] = -16;
                target[targetIndex + 1] = (byte)len;
                targetIndex += 2;
            } else if (len < 65536) {
                target[targetIndex] = -12;
                target[targetIndex + 1] = (byte)len;
                target[targetIndex + 2] = (byte)(len >> 8);
                targetIndex += 3;
            } else if (len < 0x1000000) {
                target[targetIndex] = -8;
                target[targetIndex + 1] = (byte)len;
                target[targetIndex + 2] = (byte)(len >> 8);
                target[targetIndex + 3] = (byte)(len >> 16);
                targetIndex += 4;
            } else {
                target[targetIndex] = -4;
                target[targetIndex + 1] = (byte)len;
                target[targetIndex + 2] = (byte)(len >> 8);
                target[targetIndex + 3] = (byte)(len >> 16);
                target[targetIndex + 4] = (byte)(len >> 24);
                targetIndex += 5;
            }
            System.arraycopy(in, lastHit, target, targetIndex, len + 1);
            targetIndex += len + 1;
        }
        out.setLength(targetIndex);
        return out;
    }

    public static final JSnappyBuffer decompress(byte[] in, int offset, int length, JSnappyBuffer out) throws Exception {
        int sourceIndex = offset;
        int targetLength = 0;
        int p = 0;
        do {
            targetLength += (in[sourceIndex] & 0x7F) << p++ * 7;
        } while ((in[sourceIndex++] & 0x80) == 128);
        if (out == null) {
            out = new JSnappyBuffer(targetLength);
        } else {
            out.clear(targetLength);
        }
        out.setLength(targetLength);
        byte[] outBuffer = out.getData();
        int n = 0;
        int o = 0;
        int targetIndex = 0;
        int offLen = offset + length;
        while (sourceIndex < offLen && targetIndex < targetLength) {
            int c;
            int bc = in[sourceIndex] & 3;
            if (bc == 0) {
                if ((o = (n = in[sourceIndex++] >> 2 & 0x3F) - 60) > -1) {
                    ++o;
                    c = 1;
                    n = in[sourceIndex] & 0xFF;
                    while (c < o) {
                        n |= (in[sourceIndex + c] & 0xFF) << c * 8;
                        ++c;
                    }
                    sourceIndex += o;
                }
                System.arraycopy(in, sourceIndex, outBuffer, targetIndex, n + 1);
                sourceIndex += n + 1;
                targetIndex += n + 1;
                continue;
            }
            if (bc == 1) {
                n = (in[sourceIndex] >> 2 & 7) + 4;
                o = (in[sourceIndex] & 0xE0) << 3 | in[sourceIndex + 1] & 0xFF;
                sourceIndex += 2;
            } else if (bc == 2) {
                n = (in[sourceIndex] >> 2 & 0x3F) + 1;
                o = in[sourceIndex + 1] & 0xFF | (in[sourceIndex + 2] & 0xFF) << 8;
                sourceIndex += 3;
            } else {
                n = (in[sourceIndex] >> 2 & 0x3F) + 1;
                o = in[sourceIndex + 1] & 0xFF | (in[sourceIndex + 2] & 0xFF) << 8 | (in[sourceIndex + 3] & 0xFF) << 16 | (in[sourceIndex + 4] & 0xFF) << 24;
                sourceIndex += 5;
            }
            p = targetIndex - o;
            c = p + n;
            while (p < c) {
                outBuffer[targetIndex++] = outBuffer[p++];
            }
        }
        if (targetIndex > targetLength) {
            throw new IOException("Superfluous input data encountered on offset (index:" + targetIndex + " max:" + targetLength + ")");
        }
        return out;
    }

    protected static final int nlzs(int x) {
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        return (x & 0xFFFF) + (x >> 16 & 0xFFFF);
    }

    protected static final int bitMask(int x) {
        if (x <= 256) {
            return 256;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return 1 << (x & 0xFFFF) + (x >> 16 & 0xFFFF) - 1;
    }
}

