/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.impl.MSearchElement;

final class SqlSearchElement
implements MimdbSearchElement {
    private final int type;
    private final String column;
    private final boolean preparendType;
    private Object value;
    private int columnNo;

    public SqlSearchElement(int type) throws Exception {
        this.column = null;
        this.type = type;
        this.value = null;
        this.columnNo = -1;
        this.preparendType = false;
    }

    public SqlSearchElement(String column, int type) throws Exception {
        this.column = column;
        this.type = type;
        this.value = null;
        this.columnNo = -1;
        this.preparendType = true;
    }

    public SqlSearchElement(String column, int type, Object value) throws Exception {
        this.column = column;
        this.type = type;
        this.value = value;
        this.columnNo = -1;
        this.preparendType = false;
    }

    public String getColumn() {
        return this.column;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isPreparend() {
        return this.preparendType;
    }

    public boolean isWhere() {
        switch (this.type) {
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                return false;
            }
        }
        return true;
    }

    public boolean isAndOr() {
        switch (this.type) {
            case 20: 
            case 21: {
                return true;
            }
        }
        return true;
    }

    public boolean isOffLimit() {
        return this.type == 30;
    }

    public int columnNameByNo(MimdbTable table) throws Exception {
        if (this.column != null) {
            this.columnNo = table.getColumnNameByNo(this.column);
            if (this.columnNo == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + this.column + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            return this.columnNo;
        }
        throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return MSearchElement.toStringStatic(this.type, this.column, this.value, this.preparendType);
    }
}

