/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.MLongIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;

public class MTimestampIndex
extends MLongIndex {
    public MTimestampIndex(long id, String n) {
        this(id, n, 0);
    }

    public MTimestampIndex(long id, String n, int size) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
    }

    public void add(Time value, int lineNo) throws Exception {
        if (value == null) {
            super.add(null, lineNo);
        } else {
            super.add(MimdbUtils.convertSqlTimestamp(value).getTime(), lineNo);
        }
    }

    public void add(Object value, int lineNo) throws Exception {
        if (value == null) {
            super.add(null, lineNo);
        } else {
            super.add(MimdbUtils.convertSqlTimestamp(value).getTime(), lineNo);
        }
    }

    public int getType() {
        return 6;
    }

    public int getDBType() {
        return 93;
    }

    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Long> lst = new ArrayList<Long>(1);
                lst.add(MimdbUtils.convertSqlTimestamp(o).getTime());
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Long> lst = new ArrayList<Long>(len);
                int i = 0;
                while (i < len) {
                    lst.add(MimdbUtils.convertSqlTimestamp(n.get(i)).getTime());
                    ++i;
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertSqlTimestamp(info.getValue()).getTime());
        return info;
    }
}

