/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.AbstractNumberIndex;
import org.maachang.mimdb.core.impl.FlagsMiddleSearch;
import org.maachang.mimdb.core.impl.LikeAnalyzer;
import org.maachang.mimdb.core.impl.LikeParser;
import org.maachang.mimdb.core.impl.LikeParserImpl;
import org.maachang.mimdb.core.impl.MStringIndexKey;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.impl.NGram;
import org.maachang.mimdb.core.impl.NGramLineList;
import org.maachang.mimdb.core.impl.NGramResult;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.NumberList;
import org.maachang.mimdb.core.util.ObjectKeySet;
import org.maachang.mimdb.core.util.ObjectList;

public class MStringIndex
implements MimdbIndex {
    protected String name = null;
    protected long dbId = -1L;
    protected boolean ngramFlag = false;
    private ObjectList<MStringColumnWorkChild> work = null;
    private int workLength = -1;
    private MStringIndexKey[] indexList = null;
    protected Object[] lineList = null;
    protected int[] nullLineList = null;
    protected int[] sortNoList = null;
    protected int allLength = -1;
    protected Object likeNGram = null;
    protected boolean indexFlag = false;

    public MStringIndex(long id, String n) {
        this(id, n, 0, false);
    }

    public MStringIndex(long id, String n, int size) {
        this(id, n, size, false);
    }

    public MStringIndex(long id, String n, int size, boolean ngram) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
        this.ngramFlag = ngram;
    }

    public void clear() {
        this.work = null;
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.likeNGram = null;
        this.indexFlag = false;
    }

    public long getDbId() {
        return this.dbId;
    }

    public boolean isNGram() {
        return this.ngramFlag;
    }

    public void add(String value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        this.work.add(new MStringColumnWorkChild(new MStringIndexKey(value), lineNo));
    }

    public void add(char[] value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        this.work.add(new MStringColumnWorkChild(new MStringIndexKey(value), lineNo));
    }

    public void add(MStringIndexKey value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        this.work.add(new MStringColumnWorkChild(value, lineNo));
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertString(value), lineNo);
    }

    public void createIndex() throws Exception {
        Object n;
        MStringColumnWorkChild k;
        int len;
        if (this.work == null) {
            this.clear();
            return;
        }
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.likeNGram = null;
        this.indexFlag = false;
        NumberList nullList = new NumberList(32);
        int _allLength = len = this.work.size();
        NNObjectKeyValue<MStringIndexKey, MStringColumnIndexChild> map = new NNObjectKeyValue<MStringIndexKey, MStringColumnIndexChild>(len << 1);
        int i = 0;
        while (i < len) {
            k = this.work.get(i);
            if (k.value.isNull()) {
                nullList.add(k.lineNo);
            } else {
                n = (MStringColumnIndexChild)map.get(k.value);
                if (n != null) {
                    ((MStringColumnIndexChild)n).lineNo.add(k.lineNo);
                } else {
                    map.put(k.value, new MStringColumnIndexChild(k.value, k.lineNo));
                }
            }
            ++i;
        }
        k = null;
        n = null;
        this.work = null;
        len = map.size();
        if (len > 0) {
            Object[] lst = new MStringColumnIndexChild[len];
            NNObjectKeyValue it = map.reset();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt++] = (MStringColumnIndexChild)map.get((MStringIndexKey)it.next());
            }
            it = null;
            map = null;
            Arrays.sort(lst);
            MStringIndexKey[] _indexList = new MStringIndexKey[len];
            Object[] _lineList = new Object[len];
            int[] _sortNoList = new int[_allLength];
            Arrays.fill(_sortNoList, -1);
            int i2 = 0;
            while (i2 < len) {
                n = lst[i2];
                _indexList[i2] = ((MStringColumnIndexChild)n).value;
                int[] nlst = ((MStringColumnIndexChild)n).getLineNo();
                _lineList[i2] = nlst;
                int lenJ = nlst.length;
                int j = 0;
                while (j < lenJ) {
                    _sortNoList[nlst[j]] = i2;
                    ++j;
                }
                ++i2;
            }
            lst = null;
            this.indexList = _indexList;
            this.lineList = _lineList;
            this.sortNoList = _sortNoList;
            if (this.ngramFlag) {
                this.likeNGram = NGram.createIndex(_indexList);
            }
        }
        if ((len = nullList.size()) > 0) {
            int[] _nullLineList = new int[len];
            int i3 = 0;
            while (i3 < len) {
                _nullLineList[i3] = nullList.get(i3);
                ++i3;
            }
            nullList = null;
            this.nullLineList = _nullLineList;
        }
        this.allLength = _allLength;
        this.indexFlag = true;
    }

    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<MStringIndexKey> lst = new ArrayList<MStringIndexKey>(1);
                lst.add(new MStringIndexKey(MimdbUtils.convertString(o)));
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<MStringIndexKey> lst = new ArrayList<MStringIndexKey>(len);
                int i = 0;
                while (i < len) {
                    lst.add(new MStringIndexKey(MimdbUtils.convertString(n.get(i))));
                    ++i;
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(new MStringIndexKey(MimdbUtils.convertString(info.getValue())));
        return info;
    }

    protected final int _stringBinarySearchMString(MStringIndexKey target) {
        if (this.indexList == null) {
            return -1;
        }
        return MimdbUtils.searchMStringIndexKey(this.indexList, target);
    }

    /*
     * Unable to fully structure code
     */
    protected int _MStringBinarySearchBM(boolean big, boolean eq, MStringIndexKey target) {
        block9: {
            block10: {
                if (this.indexList == null) {
                    return -1;
                }
                p = MimdbUtils.searchMStringIndexKeyBS(big, this.indexList, target);
                if (!eq) break block10;
                if (!big) ** GOTO lbl17
                while (p < this.indexList.length) {
                    if (this.indexList[p].toBig(target) > 0) {
                        ++p;
                        continue;
                    }
                    break block9;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (this.indexList[p].toBig(target) <= 0) {
                        ++p;
                        continue;
                    }
                    --p;
                    break block9;
lbl17:
                    // 2 sources

                    ** while (p < this.indexList.length)
                }
lbl18:
                // 1 sources

                break block9;
            }
            if (!big) ** GOTO lbl32
            while (p < this.indexList.length) {
                if (this.indexList[p].toBig(target) >= 0) {
                    ++p;
                    continue;
                }
                break block9;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                if (this.indexList[p].toBig(target) < 0) {
                    ++p;
                    continue;
                }
                --p;
                break;
lbl32:
                // 2 sources

                ** while (p < this.indexList.length)
            }
        }
        return p;
    }

    protected final int[] normalLike(Object[] ps, int allLen) throws Exception {
        int p;
        MStringIndexKey value;
        int j;
        int rLen;
        int len = ps.length;
        int n = -99;
        MStringIndexKey[] indexs = this.indexList;
        boolean last = false;
        NGramResult list = null;
        NGramResult newList = null;
        MStringIndexKey bw = null;
        int i = 0;
        while (i < len) {
            if (ps[i] instanceof Integer) {
                if ((Integer)ps[i] == -9) {
                    last = true;
                } else {
                    n = (Integer)ps[i];
                }
            } else {
                MStringIndexKey v = (MStringIndexKey)ps[i];
                if (n > 0) {
                    if (list == null) {
                        list = new NGramLineList(allLen);
                    }
                    newList = list.newList();
                    rLen = list.length();
                    if (last) {
                        if (bw == null) {
                            j = 0;
                            while (j < rLen) {
                                value = indexs[list.position(j)];
                                if (value.length() == list.offset(j) + n + v.length() && value.equals(list.offset(j) + n, v, 0, v.length())) {
                                    newList.add(list.position(j), list.offset(j) + n + v.length());
                                }
                                ++j;
                            }
                        } else {
                            int bwLen = bw.length;
                            j = 0;
                            while (j < rLen) {
                                value = indexs[list.position(j)];
                                while (true) {
                                    if (value.length() == list.offset(j) + n + v.length() && value.equals(list.offset(j) + n, v, 0, v.length())) {
                                        newList.add(list.position(j), list.offset(j) + n + v.length());
                                        break;
                                    }
                                    p = value.indexOf(bw, list.offset(j) - (bwLen - 1));
                                    if (p == -1) break;
                                    list.offset(j, p + bwLen);
                                }
                                ++j;
                            }
                        }
                        last = false;
                    } else if (bw == null) {
                        j = 0;
                        while (j < rLen) {
                            value = indexs[list.position(j)];
                            if (value.length() >= list.offset(j) + n + v.length() && value.equals(list.offset(j) + n, v, 0, v.length())) {
                                newList.add(list.position(j), list.offset(j) + n + v.length());
                            }
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < rLen) {
                            value = indexs[list.position(j)];
                            while (true) {
                                if (value.length() >= list.offset(j) + n + v.length() && value.equals(list.offset(j) + n, v, 0, v.length())) {
                                    newList.add(list.position(j), list.offset(j) + n + v.length());
                                    break;
                                }
                                p = value.indexOf(bw, list.offset(j));
                                if (p == -1) break;
                                list.offset(j, p + bw.length);
                            }
                            ++j;
                        }
                    }
                    list = newList;
                    newList = null;
                    n = -99;
                    bw = null;
                } else if (!last) {
                    switch (n) {
                        case 0: {
                            newList = new NGramLineList(false, allLen);
                            rLen = allLen;
                            j = MimdbUtils.searchMStringIndexKeyBS(false, indexs, v);
                            if (!indexs[j].startsWith(v)) {
                                ++j;
                            }
                            while (j < rLen) {
                                if (!indexs[j].startsWith(v)) break;
                                newList.add(j, v.length());
                                ++j;
                            }
                            list = newList;
                            newList = null;
                            break;
                        }
                        case -1: {
                            if (list != null) {
                                newList = list.newList();
                                rLen = list.length();
                                j = 0;
                                while (j < rLen) {
                                    p = indexs[list.position(j)].indexOf(v, list.offset(j));
                                    if (p != -1) {
                                        newList.add(list.position(j), p + v.length());
                                    }
                                    ++j;
                                }
                            } else {
                                newList = new NGramLineList(false, allLen);
                                rLen = allLen;
                                j = 0;
                                while (j < rLen) {
                                    p = indexs[j].indexOf(v, 0);
                                    if (p != -1) {
                                        newList.add(j, p + v.length());
                                    }
                                    ++j;
                                }
                            }
                            bw = v;
                            list = newList;
                            newList = null;
                            break;
                        }
                        case -99: {
                            throw new MimdbException("Like\u69cb\u6587\u304c\u4e0d\u6b63\u3067\u3059");
                        }
                    }
                }
                if (last) {
                    if (list != null) {
                        newList = list.newList();
                        rLen = list.length();
                        j = 0;
                        while (j < rLen) {
                            if (indexs[list.position((int)j)].length == list.offset(j) + 1 + v.length() && indexs[list.position(j)].endsWith(v)) {
                                newList.add(list.position(j), v.length());
                            }
                            ++j;
                        }
                    } else {
                        newList = new NGramLineList(false, allLen);
                        rLen = allLen;
                        j = 0;
                        while (j < rLen) {
                            if (indexs[j].endsWith(v)) {
                                newList.add(j, v.length());
                            }
                            ++j;
                        }
                    }
                    list = newList;
                    newList = null;
                    bw = null;
                    break;
                }
                if (list == null || list.length() <= 0) {
                    return AbstractNumberIndex.NOT;
                }
            }
            ++i;
        }
        if (list == null || list.length() <= 0) {
            return AbstractNumberIndex.NOT;
        }
        if (n > 0) {
            newList = list.newList();
            rLen = list.length();
            if (bw == null) {
                j = 0;
                while (j < rLen) {
                    if (indexs[list.position(j)].length() == list.offset(j) + n) {
                        newList.add(list.position(j), 0);
                    }
                    ++j;
                }
            } else {
                int bwLen = bw.length;
                j = 0;
                while (j < rLen) {
                    value = indexs[list.position(j)];
                    while (true) {
                        if (value.length() == list.offset(j) + n) {
                            newList.add(list.position(j), 0);
                            break;
                        }
                        p = value.indexOf(bw, list.offset(j) - (bwLen - 1));
                        if (p == -1) break;
                        list.offset(j, p + bwLen);
                    }
                    ++j;
                }
            }
            list = newList;
            newList = null;
            if (list.length() <= 0) {
                return AbstractNumberIndex.NOT;
            }
        }
        return list.list();
    }

    protected final int[] ngramLike(Object[] ps, int allLen) throws Exception {
        int len = ps.length;
        int n = -99;
        MStringIndexKey[] indexs = this.indexList;
        NGramResult list = null;
        NGramResult newList = null;
        boolean last = false;
        MStringIndexKey bw = null;
        int i = 0;
        while (i < len) {
            if (ps[i] instanceof Integer) {
                if ((Integer)ps[i] == -9) {
                    last = true;
                } else {
                    n = (Integer)ps[i];
                }
            } else {
                MStringIndexKey v = (MStringIndexKey)ps[i];
                if (n > 0) {
                    if (list == null) {
                        list = new NGramLineList(allLen);
                    }
                    if (last) {
                        newList = NGram.eqaulsPosition(true, list, this.likeNGram, v, n, bw);
                        last = false;
                    } else {
                        newList = NGram.eqaulsPosition(false, list, this.likeNGram, v, n, bw);
                    }
                    list = newList;
                    newList = null;
                    n = -99;
                    bw = null;
                } else if (!last) {
                    switch (n) {
                        case 0: {
                            list = NGram.startsWith(this.likeNGram, v);
                            break;
                        }
                        case -1: {
                            list = NGram.indexOf(list, this.likeNGram, v);
                            bw = v;
                            break;
                        }
                        case -99: {
                            throw new MimdbException("Like\u69cb\u6587\u304c\u4e0d\u6b63\u3067\u3059");
                        }
                    }
                }
                if (last) {
                    list = NGram.endsWith(list, this.likeNGram, v);
                    bw = null;
                    break;
                }
                if (list == null || list.length() <= 0) {
                    return AbstractNumberIndex.NOT;
                }
            }
            ++i;
        }
        if (list == null || list.length() <= 0) {
            return AbstractNumberIndex.NOT;
        }
        if (n > 0) {
            ((NGramLineList)list).endOffset(n, indexs, bw);
            if (list.length() <= 0) {
                return AbstractNumberIndex.NOT;
            }
        }
        return list.list();
    }

    protected final Object[] _createLikeParser(String like) throws Exception {
        LikeParser p = LikeAnalyzer.parser(like);
        Object[] o = ((LikeParserImpl)p).parser;
        int len = o.length;
        int i = 0;
        while (i < len) {
            if (o[i] instanceof String) {
                o[i] = new MStringIndexKey((String)o[i]);
            }
            ++i;
        }
        return o;
    }

    protected final int _calcUseLineSize(int[] posList) {
        if (posList == null) {
            return 0;
        }
        int ret = 0;
        int len = posList.length;
        int i = 0;
        while (i < len) {
            if (posList[i] != -1) {
                int[] n = posList[i] == -9 ? this.nullLineList : (int[])this.lineList[posList[i]];
                ret += n.length;
            }
            ++i;
        }
        return ret;
    }

    protected final MimdbMiddleSearch _createMiddleSearch(MimdbMiddleSearch and, MimdbMiddleSearch or) {
        if (and != null) {
            FlagsMiddleSearch ret = (FlagsMiddleSearch)and;
            ret.create(ret.dbId, ret.noList);
            if (or != null) {
                ret.or(or);
            }
            return ret;
        }
        if (or != null) {
            if (or.isAnd()) {
                or.or(or);
            }
            return or;
        }
        return new FlagsMiddleSearch(this.dbId, this.allLength);
    }

    protected final void _addSearchLineNo(MimdbMiddleSearch ret, int pos) {
        if (pos == -1) {
            return;
        }
        int[] n = pos == -9 ? this.nullLineList : (int[])this.lineList[pos];
        this._addLineNo(ret, true, n);
    }

    protected final void _addSearchLineOffNo(MimdbMiddleSearch ret, int pos) {
        if (pos == -1) {
            return;
        }
        int[] n = pos == -9 ? this.nullLineList : (int[])this.lineList[pos];
        this._addLineNo(ret, false, n);
    }

    protected final void _addLineNo(MimdbMiddleSearch ret, boolean onFlg, int[] n) {
        if (onFlg) {
            ret.addArray(n);
        } else {
            ret.offArray(n);
        }
    }

    protected final int _searchNormal(MimdbSearchElement target) throws Exception {
        if (this.lineList == null) {
            return -1;
        }
        switch (target.getType()) {
            case 1: 
            case 2: {
                return this._stringBinarySearchMString((MStringIndexKey)target.getValue());
            }
            case 3: {
                return this._MStringBinarySearchBM(true, false, (MStringIndexKey)target.getValue());
            }
            case 4: {
                return this._MStringBinarySearchBM(true, true, (MStringIndexKey)target.getValue());
            }
            case 5: {
                return this._MStringBinarySearchBM(false, false, (MStringIndexKey)target.getValue());
            }
            case 6: {
                return this._MStringBinarySearchBM(false, true, (MStringIndexKey)target.getValue());
            }
        }
        throw new MimdbException("\u6570\u5b57\u691c\u7d22\u306b\u5bfe\u3057\u3066\u3001\u4e0d\u5f53\u306a\u691c\u7d22\u6761\u4ef6[" + target.getType() + "]\u3067\u3059");
    }

    protected final int[] _searchIn(MimdbSearchElement target) throws Exception {
        List searchInfo = (List)target.getValue();
        int len = searchInfo.size();
        if (len <= 0) {
            return AbstractNumberIndex.NOT;
        }
        int[] ret = new int[len];
        ObjectKeySet dblChk = new ObjectKeySet(len << 1);
        int i = 0;
        while (i < len) {
            Object o = searchInfo.get(i);
            if (dblChk.contains(o)) {
                ret[i] = -1;
            } else {
                dblChk.add(o);
                ret[i] = o == null ? -9 : this._stringBinarySearchMString((MStringIndexKey)o);
            }
            ++i;
        }
        return ret;
    }

    protected final int[] _searchLike(MimdbSearchElement target) throws Exception {
        Object[] ps = this._createLikeParser(target.getValue().toString());
        int allLen = this.indexList.length;
        int len = ps.length;
        if (len == 1) {
            int n = (Integer)ps[0];
            if (n == -1) {
                int[] ret = new int[allLen];
                int i = 0;
                while (i < allLen) {
                    ret[i] = i;
                    ++i;
                }
                return ret;
            }
            if (this.indexList == null) {
                return AbstractNumberIndex.NOT;
            }
            MStringIndexKey[] indexs = this.indexList;
            int[] lst = new int[allLen];
            int lstCnt = 0;
            int i = 0;
            while (i < allLen) {
                if (indexs[i].length == n) {
                    lst[lstCnt++] = i;
                }
                ++i;
            }
            int[] ret = new int[lstCnt];
            System.arraycopy(lst, 0, ret, 0, lstCnt);
            lst = null;
            return ret;
        }
        if (this.indexList == null) {
            return AbstractNumberIndex.NOT;
        }
        if (len == 3 && ps[0] instanceof Integer && ps[1] instanceof Integer && ps[2] instanceof MStringIndexKey && (Integer)ps[0] == 0 && (Integer)ps[1] == -9) {
            return new int[]{this._stringBinarySearchMString((MStringIndexKey)ps[2])};
        }
        if (this.ngramFlag) {
            return this.ngramLike(ps, allLen);
        }
        return this.normalLike(ps, allLen);
    }

    protected final int[] _searchNull(MimdbSearchElement target) throws Exception {
        switch (target.getType()) {
            case 1: 
            case 2: {
                if (this.nullLineList == null) {
                    return null;
                }
                return this.nullLineList;
            }
        }
        throw new MimdbException("\u6570\u5b57NULL\u691c\u7d22\u306b\u5bfe\u3057\u3066\u3001\u4e0d\u5f53\u306a\u691c\u7d22\u6761\u4ef6[" + target.getType() + "]\u3067\u3059");
    }

    protected MimdbMiddleSearch _coreSearch(MimdbSearchElement info, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        if (info == null) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.indexFlag) {
            throw new MimdbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (info.getValue() == null) {
            int[] nullPos = this._searchNull(info);
            if (info.getType() == 1) {
                if (nullPos == null) {
                    return null;
                }
                MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
                this._addLineNo(ret, true, nullPos);
                return ret;
            }
            return this.neqSearch(-1, and, or);
        }
        if (info.getType() == 7 || info.getType() == 8) {
            int[] inPos = info.getType() == 7 ? this._searchIn(info) : this._searchLike(info);
            if (this._calcUseLineSize(inPos) <= 0) {
                return null;
            }
            MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
            int len = inPos.length;
            int i = 0;
            while (i < len) {
                this._addSearchLineNo(ret, inPos[i]);
                ++i;
            }
            return ret;
        }
        int pos = this._searchNormal(info);
        if (info.getType() != 2 && pos == -1) {
            return null;
        }
        switch (info.getType()) {
            case 1: {
                return this.eqSearch(pos, and, or);
            }
            case 2: {
                return this.neqSearch(pos, and, or);
            }
            case 3: 
            case 4: {
                return this.lBigSearch(pos, and, or);
            }
            case 5: 
            case 6: {
                return this.rBigSearch(pos, and, or);
            }
        }
        return null;
    }

    protected final MimdbMiddleSearch eqSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        this._addSearchLineNo(ret, pos);
        return ret;
    }

    protected final MimdbMiddleSearch neqSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        if (pos == -1) {
            ret.all();
        } else {
            ret.all();
            this._addSearchLineOffNo(ret, pos);
        }
        return ret;
    }

    protected final MimdbMiddleSearch lBigSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        int len = this.lineList.length;
        int i = pos;
        while (i < len) {
            this._addSearchLineNo(ret, i);
            ++i;
        }
        return ret;
    }

    protected final MimdbMiddleSearch rBigSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        int i = pos;
        while (i >= 0) {
            this._addSearchLineNo(ret, i);
            --i;
        }
        return ret;
    }

    public boolean isIndex() {
        return this.indexFlag;
    }

    public MimdbMiddleSearch search(MimdbSearchElement info) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, null);
    }

    public MimdbMiddleSearch and(MimdbSearchElement info, MimdbMiddleSearch and) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), and, null);
    }

    public MimdbMiddleSearch or(MimdbSearchElement info, MimdbMiddleSearch or) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, or);
    }

    public int getIndexSize() {
        return this.indexList.length;
    }

    public int[] getSortNoList() {
        return this.sortNoList;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return 5;
    }

    public int getDBType() {
        return 12;
    }

    private static final class MStringColumnWorkChild {
        MStringIndexKey value;
        int lineNo;

        public MStringColumnWorkChild(MStringIndexKey v, int n) {
            this.value = v;
            this.lineNo = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MStringColumnIndexChild
    implements Comparable<MStringColumnIndexChild> {
        MStringIndexKey value;
        NumberList lineNo = new NumberList();

        public MStringColumnIndexChild(MStringIndexKey v, int n) {
            this.value = v;
            this.lineNo.add(n);
        }

        @Override
        public int compareTo(MStringColumnIndexChild n) {
            return this.value.compareTo(n.value);
        }

        public int[] getLineNo() {
            int len = this.lineNo.size();
            int[] ret = new int[len];
            int i = 0;
            while (i < len) {
                ret[i] = this.lineNo.get(i);
                ++i;
            }
            return ret;
        }
    }
}

