/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.AbstractNumberIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.NumberList;
import org.maachang.mimdb.core.util.ObjectList;

public class MLongIndex
extends AbstractNumberIndex {
    protected ObjectList<MLongColumnWorkChild> work = null;
    protected int workLength = -1;
    protected long[] indexList = null;

    protected MLongIndex() {
    }

    public MLongIndex(long id, String n) {
        this(id, n, 0);
    }

    public MLongIndex(long id, String n, int size) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
    }

    public void clear() {
        super.clear();
        this.work = null;
        this.indexList = null;
    }

    public void add(Long value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        if (value == null) {
            this.work.add(new MLongColumnWorkChild(value, -1, true));
        } else {
            this.work.add(new MLongColumnWorkChild(value, lineNo, false));
        }
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertLong(value), lineNo);
    }

    public void createIndex() throws Exception {
        Object n;
        MLongColumnWorkChild k;
        int len;
        if (this.work == null) {
            this.clear();
            return;
        }
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
        NumberList nullList = new NumberList(32);
        int _allLength = len = this.work.size();
        NNObjectKeyValue<Long, MLongColumnIndexChild> map = new NNObjectKeyValue<Long, MLongColumnIndexChild>(len * 2);
        int i = 0;
        while (i < len) {
            k = this.work.get(i);
            if (k.nullFlag) {
                nullList.add(k.lineNo);
            } else {
                n = (MLongColumnIndexChild)map.get(k.value);
                if (n != null) {
                    ((MLongColumnIndexChild)n).lineNo.add(k.lineNo);
                } else {
                    map.put(k.value, new MLongColumnIndexChild(k.value, k.lineNo));
                }
            }
            ++i;
        }
        k = null;
        n = null;
        this.work = null;
        len = map.size();
        if (len > 0) {
            Object[] lst = new MLongColumnIndexChild[len];
            NNObjectKeyValue it = map.reset();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt++] = (MLongColumnIndexChild)map.get((Long)it.next());
            }
            it = null;
            map = null;
            Arrays.sort(lst);
            long[] _indexList = new long[len];
            Object[] _lineList = new Object[len];
            int[] _sortNoList = new int[_allLength];
            Arrays.fill(_sortNoList, -1);
            int i2 = 0;
            while (i2 < len) {
                n = lst[i2];
                _indexList[i2] = ((MLongColumnIndexChild)n).value;
                int[] nlst = ((MLongColumnIndexChild)n).getLineNo();
                _lineList[i2] = nlst;
                int lenJ = nlst.length;
                int j = 0;
                while (j < lenJ) {
                    _sortNoList[nlst[j]] = i2;
                    ++j;
                }
                ++i2;
            }
            lst = null;
            this.indexList = _indexList;
            this.lineList = _lineList;
            this.sortNoList = _sortNoList;
        }
        if ((len = nullList.size()) > 0) {
            int[] _nullLineList = new int[len];
            int i3 = 0;
            while (i3 < len) {
                _nullLineList[i3] = nullList.get(i3);
                ++i3;
            }
            nullList = null;
            this.nullLineList = _nullLineList;
        }
        this.allLength = _allLength;
        this.indexFlag = true;
    }

    public int getIndexSize() {
        return this.indexList.length;
    }

    public int getType() {
        return 3;
    }

    public int getDBType() {
        return -5;
    }

    public boolean isNGram() {
        return false;
    }

    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Long> lst = new ArrayList<Long>(1);
                lst.add(MimdbUtils.convertLong(o));
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Long> lst = new ArrayList<Long>(len);
                int i = 0;
                while (i < len) {
                    lst.add(MimdbUtils.convertLong(n.get(i)));
                    ++i;
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertLong(info.getValue()));
        return info;
    }

    protected final int _numberBinarySearch(Object target) {
        if (this.indexList == null) {
            return -1;
        }
        return MimdbUtils.searchLong(this.indexList, (Long)target);
    }

    protected int _numberBinarySearchBM(boolean big, boolean eq, Object target) {
        if (this.indexList == null) {
            return -1;
        }
        long t = (Long)target;
        int p = MimdbUtils.searchLongBS(big, this.indexList, t);
        if (eq && this.indexList[p] == t) {
            return p;
        }
        if (big) {
            if (this.indexList.length <= p + 1) {
                return -1;
            }
            return p + 1;
        }
        if (p <= 0) {
            return -1;
        }
        return p - 1;
    }

    private static final class MLongColumnWorkChild {
        long value;
        int lineNo;
        boolean nullFlag;

        public MLongColumnWorkChild(long v, int n, boolean nf) {
            this.value = v;
            this.lineNo = n;
            this.nullFlag = nf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MLongColumnIndexChild
    implements Comparable<MLongColumnIndexChild> {
        long value;
        NumberList lineNo = new NumberList();

        public MLongColumnIndexChild(long v, int n) {
            this.value = v;
            this.lineNo.add(n);
        }

        @Override
        public int compareTo(MLongColumnIndexChild n) {
            return (int)(this.value - n.value);
        }

        public int[] getLineNo() {
            int len = this.lineNo.size();
            int[] ret = new int[len];
            int i = 0;
            while (i < len) {
                ret[i] = this.lineNo.get(i);
                ++i;
            }
            return ret;
        }
    }
}

