/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.CountMetaDataImpl;
import org.maachang.mimdb.core.CountResultRowImpl;
import org.maachang.mimdb.core.MetaDataImpl;
import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.ResultCache;
import org.maachang.mimdb.core.ResultImpl;
import org.maachang.mimdb.core.ResultRowImpl;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.impl.EqualsNoList;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.impl.WhereBlock;

public class MimdbPreparedStatement
implements MimdbBase {
    protected MimdbStatement src;
    protected long dbId;
    protected String name;
    protected EqualsNoList columns;
    protected boolean countFlag;
    protected SortElement sort;
    protected WhereBlock block;
    protected MimdbSearchElement[] preparendParams;
    protected int preparendParamsSize;
    private MimdbSearchElement[] executionParams = null;
    private int viewOffset = -1;
    private int viewLimit = -1;
    protected int defOffset = -1;
    protected int defLimit = -1;

    public void clear() {
        this.src = null;
        this.dbId = -1L;
        this.name = null;
        this.columns = null;
        this.countFlag = false;
        this.sort = null;
        this.block = null;
        this.preparendParams = null;
        this.preparendParamsSize = 0;
        this.executionParams = null;
        this.viewOffset = -1;
        this.viewLimit = -1;
        this.defOffset = -1;
        this.defLimit = -1;
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.name;
    }

    public int paramsLength() {
        return this.preparendParamsSize;
    }

    public MimdbPreparedStatement clearParams() {
        this.executionParams = null;
        return this;
    }

    public MimdbPreparedStatement setParams(int index, Object value) {
        if (this.preparendParams == null || index < 0 || index >= this.preparendParamsSize) {
            return this;
        }
        if (this.executionParams == null) {
            this.executionParams = new MimdbSearchElement[this.preparendParamsSize];
        }
        this.executionParams[index] = this.preparendParams[index];
        this.executionParams[index].setValue(value);
        return this;
    }

    public String paramNoByColumnName(int index) {
        if (this.preparendParams == null || index < 0 || index >= this.preparendParamsSize) {
            return null;
        }
        return this.preparendParams[index].getColumn();
    }

    public int paramNoByColumnNo(int index) {
        if (this.preparendParams == null || index < 0 || index >= this.preparendParamsSize) {
            return -1;
        }
        return MimdbTableManager.getInstance().get(this.name).getColumnNameByNo(this.preparendParams[index].getColumn());
    }

    public int paramNoByColumnType(int index) {
        if (this.preparendParams == null || index < 0 || index >= this.preparendParamsSize) {
            return -1;
        }
        return MimdbTableManager.getInstance().get(this.name).getColumnType(this.preparendParams[index].getColumn());
    }

    public MimdbPreparedStatement setOffset(int off) {
        this.viewOffset = off <= -1 ? -1 : off;
        return this;
    }

    public MimdbPreparedStatement setLimit(int limit) {
        this.viewLimit = limit <= -1 ? -1 : limit;
        return this;
    }

    public MimdbResult executeQuery() throws Exception {
        return this.executeQuery(false);
    }

    public MimdbResult executeQuery(boolean mode) throws Exception {
        MimdbTable table;
        if (this.dbId == -1L) {
            throw new MimdbException("\u5fc5\u8981\u306a\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int pOff = this.defOffset;
        int pLmt = this.defLimit;
        if (this.preparendParamsSize > 0) {
            if (this.executionParams == null) {
                throw new MimdbException("\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            int i = 0;
            while (i < this.preparendParamsSize) {
                MimdbSearchElement em = this.executionParams[i];
                if (em == null) {
                    throw new MimdbException("[" + i + "]\u756a\u76ee\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                if (em.getType() == 30) {
                    if ("offset".equals(em.getColumn())) {
                        pOff = MimdbUtils.convertInt(em.getValue());
                    } else {
                        pLmt = MimdbUtils.convertInt(em.getValue());
                    }
                }
                ++i;
            }
        }
        if ((table = MimdbTableManager.getInstance().get(this.name)) == null) {
            throw new MimdbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb(" + this.name + ")\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (table.getDbId() != this.dbId) {
            if (mode) {
                throw new MimdbException("\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb[" + this.name + "]\u306f\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.dbId = table.getDbId();
        }
        this.initSortElement(table);
        int off = this.viewOffset;
        int limit = this.viewLimit;
        this.executionParams = null;
        this.viewOffset = -1;
        this.viewLimit = -1;
        if (off == -1 && limit == -1) {
            if (pOff != -1) {
                off = pOff;
            }
            if (pLmt != -1) {
                limit = pLmt;
            }
        }
        if (off != -1 || limit != -1) {
            if (off != -1) {
                if (limit == -1) {
                    limit = 999999999;
                }
            } else if (limit != -1) {
                off = 0;
            }
        }
        ResultCache cache = ResultCache.get();
        ResultImpl ret = cache.result;
        if (this.block == null || this.block.size() == 0) {
            if (this.countFlag) {
                CountMetaDataImpl meta = cache.countMeta;
                cache.countMeta.create(ret);
                CountResultRowImpl row = cache.countRow;
                cache.countRow.create(ret, table.size());
                ret.create(this.dbId, table, cache, meta, row, null, 1, 1);
            } else {
                MetaDataImpl meta = cache.meta;
                cache.meta.create(ret, this.columns);
                ResultRowImpl row = cache.row;
                cache.row.create(ret);
                cache.pointer.create(table.mainTable, this.sort, off, limit);
                cache.pointer.execute();
                ret.create(this.dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
            }
            return ret;
        }
        MimdbMiddleSearch res = MimdbPreparedStatement.search(this.dbId, table, null, this.block);
        if (res == null || res.size() <= 0) {
            if (this.countFlag) {
                CountMetaDataImpl meta = cache.countMeta;
                cache.countMeta.create(ret);
                CountResultRowImpl row = cache.countRow;
                cache.countRow.create(ret, 0);
                ret.create(this.dbId, table, cache, meta, row, null, 1, 1);
            } else {
                MetaDataImpl meta = cache.meta;
                cache.meta.create(ret, this.columns);
                ResultRowImpl row = cache.row;
                cache.row.create(ret);
                cache.pointer.createZero(table.mainTable, this.sort, off, limit);
                cache.pointer.execute();
                ret.create(this.dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
            }
            return ret;
        }
        if (this.countFlag) {
            CountMetaDataImpl meta = cache.countMeta;
            cache.countMeta.create(ret);
            CountResultRowImpl row = cache.countRow;
            cache.countRow.create(ret, res.size());
            ret.create(this.dbId, table, cache, meta, row, null, 1, 1);
        } else {
            MetaDataImpl meta = cache.meta;
            cache.meta.create(ret, this.columns);
            ResultRowImpl row = cache.row;
            cache.row.create(ret);
            cache.pointer.create(res, table.mainTable, this.sort, off, limit);
            cache.pointer.execute();
            ret.create(this.dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
        }
        return ret;
    }

    private static final MimdbMiddleSearch search(long dbId, MimdbTable table, MimdbMiddleSearch res, WhereBlock block) throws Exception {
        int len = block.size();
        int andor = -1;
        int i = 0;
        while (i < len) {
            Object o = block.get(i);
            if (o instanceof WhereBlock) {
                MimdbMiddleSearch blockRes = MimdbPreparedStatement.search(dbId, table, null, (WhereBlock)o);
                if (blockRes == null) {
                    if (andor == -1 || andor == 0) {
                        res = null;
                    }
                } else if (andor == 0) {
                    res.and(blockRes);
                } else if (andor == 1) {
                    if (res == null || res.size() <= 0) {
                        res = blockRes;
                    } else {
                        res.or(blockRes);
                    }
                    res = res.size() > 0 ? res : null;
                } else {
                    res = blockRes.size() > 0 ? blockRes : null;
                }
            } else {
                MimdbSearchElement em = (MimdbSearchElement)o;
                switch (em.getType()) {
                    case 20: {
                        andor = 0;
                        break;
                    }
                    case 21: {
                        andor = 1;
                        break;
                    }
                    default: {
                        if (andor == -1) {
                            res = table.getIndex(em.getColumnNo()).search(em);
                        } else if (andor == 0 && res != null) {
                            res = table.getIndex(em.getColumnNo()).and(em, res);
                        } else if (andor == 1) {
                            res = table.getIndex(em.getColumnNo()).or(em, res);
                        } else {
                            throw new MimdbException("\u4e0d\u660e\u306aand or\u6761\u4ef6\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f(column:" + em.toString() + " code:" + andor + ")");
                        }
                        andor = -1;
                    }
                }
            }
            ++i;
        }
        return res;
    }

    private final void initSortElement(MimdbTable table) {
        if (this.sort == null || this.sort.sortNoList == null) {
            return;
        }
        if (this.sort.indexList == null) {
            int[] noList = this.sort.sortNoList;
            int len = noList.length;
            int[][] idx = new int[len][];
            int i = 0;
            while (i < len) {
                MimdbIndex index = table.getIndex(noList[i]);
                idx[i] = (int[])(index != null ? index.getSortNoList() : null);
                ++i;
            }
            this.sort.indexLength = len == 1 ? table.getIndex(noList[0]).getIndexSize() : -1;
            this.sort.indexList = idx;
        }
    }
}

